/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.AbsFunction;
import org.apache.fop.fo.expr.BodyStartFunction;
import org.apache.fop.fo.expr.CIELabColorFunction;
import org.apache.fop.fo.expr.CMYKColorFunction;
import org.apache.fop.fo.expr.CeilingFunction;
import org.apache.fop.fo.expr.FloorFunction;
import org.apache.fop.fo.expr.FromNearestSpecifiedValueFunction;
import org.apache.fop.fo.expr.FromParentFunction;
import org.apache.fop.fo.expr.FromTableColumnFunction;
import org.apache.fop.fo.expr.Function;
import org.apache.fop.fo.expr.InheritedPropFunction;
import org.apache.fop.fo.expr.LabelEndFunction;
import org.apache.fop.fo.expr.MaxFunction;
import org.apache.fop.fo.expr.MinFunction;
import org.apache.fop.fo.expr.NCnameProperty;
import org.apache.fop.fo.expr.NumericOp;
import org.apache.fop.fo.expr.OCAColorFunction;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.PropertyTokenizer;
import org.apache.fop.fo.expr.ProportionalColumnWidthFunction;
import org.apache.fop.fo.expr.RGBAColorFunction;
import org.apache.fop.fo.expr.RGBColorFunction;
import org.apache.fop.fo.expr.RGBICCColorFunction;
import org.apache.fop.fo.expr.RGBNamedColorFunction;
import org.apache.fop.fo.expr.RoundFunction;
import org.apache.fop.fo.expr.SystemColorFunction;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.StringProperty;

public final class PropertyParser
extends PropertyTokenizer {
    private PropertyInfo propInfo;
    private static final String RELUNIT = "em";
    private static final String ROOT_RELUNIT = "rem";
    private static final HashMap FUNCTION_TABLE = new HashMap();

    public static Property parse(String string, PropertyInfo propertyInfo) throws PropertyException {
        try {
            return new PropertyParser(string, propertyInfo).parseProperty();
        }
        catch (PropertyException propertyException) {
            propertyException.setPropertyInfo(propertyInfo);
            throw propertyException;
        }
    }

    private PropertyParser(String string, PropertyInfo propertyInfo) {
        super(string);
        this.propInfo = propertyInfo;
    }

    private Property parseProperty() throws PropertyException {
        this.next();
        if (this.currentToken == 0) {
            return StringProperty.getInstance((String)"");
        }
        ListProperty listProperty = null;
        while (true) {
            Property property = this.parseAdditiveExpr();
            if (this.currentToken == 0) {
                if (listProperty != null) {
                    listProperty.addProperty(property);
                    return listProperty;
                }
                return property;
            }
            if (listProperty == null) {
                listProperty = new ListProperty(property);
                continue;
            }
            listProperty.addProperty(property);
        }
    }

    private Property parseAdditiveExpr() throws PropertyException {
        Property property = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 8: {
                    this.next();
                    property = this.evalAddition(property.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
                case 9: {
                    this.next();
                    property = this.evalSubtraction(property.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
            }
            break;
        }
        return property;
    }

    private Property parseMultiplicativeExpr() throws PropertyException {
        Property property = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 11: {
                    this.next();
                    property = this.evalDivide(property.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
                case 10: {
                    this.next();
                    property = this.evalModulo(property.getNumber(), this.parseUnaryExpr().getNumber());
                    continue block5;
                }
                case 2: {
                    this.next();
                    property = this.evalMultiply(property.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
            }
            break;
        }
        return property;
    }

    private Property parseUnaryExpr() throws PropertyException {
        if (this.currentToken == 9) {
            this.next();
            return this.evalNegate(this.parseUnaryExpr().getNumeric());
        }
        return this.parsePrimaryExpr();
    }

    private void expectRpar() throws PropertyException {
        if (this.currentToken != 4) {
            throw new PropertyException("expected )");
        }
        this.next();
    }

    private Property parsePrimaryExpr() throws PropertyException {
        StringProperty stringProperty;
        if (this.currentToken == 13) {
            this.next();
        }
        switch (this.currentToken) {
            case 3: {
                this.next();
                Property property = this.parseAdditiveExpr();
                this.expectRpar();
                return property;
            }
            case 5: {
                stringProperty = StringProperty.getInstance((String)this.currentTokenValue);
                break;
            }
            case 1: {
                stringProperty = new NCnameProperty(this.currentTokenValue);
                break;
            }
            case 16: {
                stringProperty = NumberProperty.getInstance((Double)Double.valueOf(this.currentTokenValue));
                break;
            }
            case 17: {
                stringProperty = NumberProperty.getInstance((Integer)Integer.valueOf(this.currentTokenValue));
                break;
            }
            case 14: {
                double d2 = Double.parseDouble(this.currentTokenValue.substring(0, this.currentTokenValue.length() - 1)) / 100.0;
                PercentBase percentBase = this.propInfo.getPercentBase();
                if (percentBase != null) {
                    if (percentBase.getDimension() == 0) {
                        stringProperty = NumberProperty.getInstance((double)(d2 * percentBase.getBaseValue()));
                        break;
                    }
                    if (percentBase.getDimension() == 1) {
                        if (percentBase instanceof LengthBase) {
                            if (d2 == 0.0) {
                                stringProperty = FixedLength.ZERO_FIXED_LENGTH;
                                break;
                            }
                            Length length = ((LengthBase)percentBase).getBaseLength();
                            if (length != null && length.isAbsolute()) {
                                stringProperty = FixedLength.getInstance((double)(d2 * (double)length.getValue()));
                                break;
                            }
                        }
                        stringProperty = new PercentLength(d2, percentBase);
                        break;
                    }
                    throw new PropertyException("Illegal percent dimension value");
                }
                stringProperty = NumberProperty.getInstance((double)d2);
                break;
            }
            case 12: {
                int n2 = this.currentTokenValue.length() - this.currentUnitLength;
                String string = this.currentTokenValue.substring(n2);
                double d3 = Double.parseDouble(this.currentTokenValue.substring(0, n2));
                if (RELUNIT.equals(string)) {
                    stringProperty = (Property)NumericOp.multiply((Numeric)NumberProperty.getInstance((double)d3), (Numeric)this.propInfo.currentFontSize());
                    break;
                }
                if (ROOT_RELUNIT.equals(string)) {
                    stringProperty = (Property)NumericOp.multiply((Numeric)NumberProperty.getInstance((double)d3), (Numeric)this.getRootFontSize());
                    break;
                }
                if ("px".equals(string)) {
                    float f2 = this.propInfo.getPropertyList().getFObj().getUserAgent().getSourceResolution();
                    stringProperty = FixedLength.getInstance((double)d3, (String)string, (float)(72.0f / f2));
                    break;
                }
                stringProperty = FixedLength.getInstance((double)d3, (String)string);
                break;
            }
            case 15: {
                stringProperty = ColorProperty.getInstance((FOUserAgent)this.propInfo.getUserAgent(), (String)this.currentTokenValue);
                break;
            }
            case 7: {
                Function function = (Function)FUNCTION_TABLE.get(this.currentTokenValue);
                if (function == null) {
                    throw new PropertyException("no such function: " + this.currentTokenValue);
                }
                this.next();
                this.propInfo.pushFunction(function);
                Property property = function.eval(this.parseArgs(function), this.propInfo);
                this.propInfo.popFunction();
                return property;
            }
            default: {
                throw new PropertyException("syntax error");
            }
        }
        this.next();
        return stringProperty;
    }

    private Numeric getRootFontSize() throws PropertyException {
        PropertyList propertyList = null;
        for (PropertyList propertyList2 = this.propInfo.getPropertyList(); propertyList2 != null && propertyList2.getFObj().getNameId() != 16; propertyList2 = propertyList2.getParentPropertyList()) {
            propertyList = propertyList2;
        }
        if (propertyList == null) {
            throw new PropertyException("The root font size cannot be determined for 'rem' resolution.");
        }
        Length length = propertyList.get(103).getLength();
        return length;
    }

    Property[] parseArgs(Function function) throws PropertyException {
        int n2;
        int n3 = function.getRequiredArgsCount();
        int n4 = function.getOptionalArgsCount();
        boolean bl = function.hasVariableArgs();
        ArrayList<Property> arrayList = new ArrayList<Property>(n3 + n4);
        if (this.currentToken == 4) {
            this.next();
        } else {
            while (true) {
                Property property = this.parseAdditiveExpr();
                n2 = arrayList.size();
                if (n2 >= n3 && n2 - n3 >= n4 && !bl) {
                    throw new PropertyException("Unexpected function argument at index " + n2);
                }
                arrayList.add(property);
                if (this.currentToken != 13) break;
                this.next();
            }
            this.expectRpar();
        }
        int n5 = arrayList.size();
        if (n5 < n3) {
            throw new PropertyException("Expected " + n3 + " required arguments, but only " + n5 + " specified");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (arrayList.size() >= n3 + n2 + 1) continue;
            arrayList.add(function.getOptionalArgDefault(n2, this.propInfo));
        }
        return arrayList.toArray(new Property[arrayList.size()]);
    }

    private Property evalAddition(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in addition");
        }
        return (Property)NumericOp.addition((Numeric)numeric, (Numeric)numeric2);
    }

    private Property evalSubtraction(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in subtraction");
        }
        return (Property)NumericOp.subtraction((Numeric)numeric, (Numeric)numeric2);
    }

    private Property evalNegate(Numeric numeric) throws PropertyException {
        if (numeric == null) {
            throw new PropertyException("Non numeric operand to unary minus");
        }
        return (Property)NumericOp.negate((Numeric)numeric);
    }

    private Property evalMultiply(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in multiplication");
        }
        return (Property)NumericOp.multiply((Numeric)numeric, (Numeric)numeric2);
    }

    private Property evalDivide(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in division");
        }
        return (Property)NumericOp.divide((Numeric)numeric, (Numeric)numeric2);
    }

    private Property evalModulo(Number number, Number number2) throws PropertyException {
        if (number == null || number2 == null) {
            throw new PropertyException("Non number operand to modulo");
        }
        return NumberProperty.getInstance((double)(number.doubleValue() % number2.doubleValue()));
    }

    static {
        FUNCTION_TABLE.put("ceiling", new CeilingFunction());
        FUNCTION_TABLE.put("floor", new FloorFunction());
        FUNCTION_TABLE.put("round", new RoundFunction());
        FUNCTION_TABLE.put("min", new MinFunction());
        FUNCTION_TABLE.put("max", new MaxFunction());
        FUNCTION_TABLE.put("abs", new AbsFunction());
        FUNCTION_TABLE.put("rgb", new RGBColorFunction());
        FUNCTION_TABLE.put("rgba", new RGBAColorFunction());
        FUNCTION_TABLE.put("system-color", new SystemColorFunction());
        FUNCTION_TABLE.put("from-table-column", new FromTableColumnFunction());
        FUNCTION_TABLE.put("inherited-property-value", new InheritedPropFunction());
        FUNCTION_TABLE.put("from-nearest-specified-value", new FromNearestSpecifiedValueFunction());
        FUNCTION_TABLE.put("from-parent", new FromParentFunction());
        FUNCTION_TABLE.put("proportional-column-width", new ProportionalColumnWidthFunction());
        FUNCTION_TABLE.put("label-end", new LabelEndFunction());
        FUNCTION_TABLE.put("body-start", new BodyStartFunction());
        FUNCTION_TABLE.put("rgb-icc", new RGBICCColorFunction(false));
        FUNCTION_TABLE.put("fox-rgb-icc", new RGBICCColorFunction(true));
        FUNCTION_TABLE.put("rgb-named-color", new RGBNamedColorFunction());
        FUNCTION_TABLE.put("cie-lab-color", new CIELabColorFunction());
        FUNCTION_TABLE.put("cmyk", new CMYKColorFunction());
        FUNCTION_TABLE.put("oca", new OCAColorFunction());
    }
}

