/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.io.Serializable;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Trait;
import org.apache.fop.complexscripts.bidi.InlineRun;

public class InlineArea
extends Area {
    private static final long serialVersionUID = -8940066479810170980L;
    protected int blockProgressionOffset;
    private Area parentArea;
    private int storedIPDVariation;
    protected InlineAdjustingInfo adjustingInfo;
    protected int xOffset;
    protected int yOffset;
    public static final int STATIC = 0;
    public static final int RELATIVE = 1;
    public static final int ABSOLUTE = 2;
    private int positioning = 0;

    public InlineArea() {
        this(0, -1);
    }

    protected InlineArea(int n2, int n3) {
        this.blockProgressionOffset = n2;
        this.setBidiLevel(n3);
    }

    public InlineAdjustingInfo getAdjustingInfo() {
        return this.adjustingInfo;
    }

    public void setAdjustingInfo(int n2, int n3, int n4) {
        this.adjustingInfo = new InlineAdjustingInfo(n2, n3, n4);
    }

    public void setAdjustingInfo(InlineAdjustingInfo inlineAdjustingInfo) {
        this.adjustingInfo = inlineAdjustingInfo;
    }

    public void setAdjustment(int n2) {
        if (this.adjustingInfo != null) {
            this.adjustingInfo.adjustment = n2;
        }
    }

    public void increaseIPD(int n2) {
        this.ipd += n2;
    }

    public void setBlockProgressionOffset(int n2) {
        this.blockProgressionOffset = n2;
    }

    public int getBlockProgressionOffset() {
        return this.blockProgressionOffset;
    }

    public void setParentArea(Area area) {
        this.parentArea = area;
    }

    public Area getParentArea() {
        return this.parentArea;
    }

    public void addChildArea(Area area) {
        super.addChildArea(area);
        if (area instanceof InlineArea) {
            ((InlineArea)area).setParentArea(this);
        }
    }

    public boolean hasUnderline() {
        return this.getTraitAsBoolean(Trait.UNDERLINE);
    }

    public boolean hasOverline() {
        return this.getTraitAsBoolean(Trait.OVERLINE);
    }

    public boolean hasLineThrough() {
        return this.getTraitAsBoolean(Trait.LINETHROUGH);
    }

    public boolean isBlinking() {
        return this.getTraitAsBoolean(Trait.BLINK);
    }

    public boolean applyVariationFactor(double d2, int n2, int n3) {
        if (this.adjustingInfo != null) {
            this.setIPD(this.getIPD() + this.adjustingInfo.applyVariationFactor(d2));
        }
        return false;
    }

    public void handleIPDVariation(int n2) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Handling IPD variation for " + ((Object)((Object)this)).getClass().getSimpleName() + ": increase by " + n2 + " mpt."));
        }
        if (n2 != 0) {
            this.increaseIPD(n2);
            this.notifyIPDVariation(n2);
        }
    }

    protected void notifyIPDVariation(int n2) {
        Area area = this.getParentArea();
        if (area instanceof InlineArea) {
            ((InlineArea)area).handleIPDVariation(n2);
        } else if (area instanceof LineArea) {
            ((LineArea)area).handleIPDVariation(n2);
        } else if (area == null) {
            this.storedIPDVariation += n2;
        }
    }

    int getVirtualOffset() {
        return this.getBlockProgressionOffset();
    }

    int getVirtualBPD() {
        return this.getBPD();
    }

    public List collectInlineRuns(List list) {
        assert (list != null);
        list.add(new InlineRun(this, new int[]{this.getBidiLevel()}));
        return list;
    }

    public boolean isAncestorOrSelf(InlineArea inlineArea) {
        return inlineArea == this || this.isAncestor(inlineArea);
    }

    public boolean isAncestor(InlineArea inlineArea) {
        Area area = this.getParentArea();
        while (area != null) {
            if (area == inlineArea) {
                return true;
            }
            if (area instanceof InlineArea) {
                area = ((InlineArea)area).getParentArea();
                continue;
            }
            area = null;
        }
        return false;
    }

    public void setXOffset(int n2) {
        this.xOffset = n2;
    }

    public void setYOffset(int n2) {
        this.yOffset = n2;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setPositioning(int n2) {
        this.positioning = n2;
    }

    public int getPositioning() {
        return this.positioning;
    }

    protected class InlineAdjustingInfo
    implements Serializable {
        private static final long serialVersionUID = -5601387735459712149L;
        protected int availableStretch;
        protected int availableShrink;
        protected int adjustment;

        protected InlineAdjustingInfo(int n2, int n3, int n4) {
            this.availableStretch = n2;
            this.availableShrink = n3;
            this.adjustment = n4;
        }

        protected int applyVariationFactor(double d2) {
            int n2 = this.adjustment;
            this.adjustment = (int)((double)this.adjustment * d2);
            return this.adjustment - n2;
        }
    }
}

