/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.CFFDataInput;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFExpertCharset;
import org.apache.fontbox.cff.CFFExpertEncoding;
import org.apache.fontbox.cff.CFFExpertSubsetCharset;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFISOAdobeCharset;
import org.apache.fontbox.cff.CFFOperator;
import org.apache.fontbox.cff.CFFStandardEncoding;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cff.FDSelect;
import org.apache.fontbox.util.Charsets;

public class CFFParser {
    private static final Log LOG = LogFactory.getLog(CFFParser.class);
    private static final String TAG_OTTO = "OTTO";
    private static final String TAG_TTCF = "ttcf";
    private static final String TAG_TTFONLY = "\u0000\u0001\u0000\u0000";
    private String[] stringIndex = null;
    private ByteSource source;
    private String debugFontName;

    public List<CFFFont> parse(byte[] byArray, ByteSource byteSource) throws IOException {
        this.source = byteSource;
        return this.parse(byArray, 0);
    }

    public List<CFFFont> parse(byte[] byArray) throws IOException {
        return this.parse(byArray, 0);
    }

    public List<CFFFont> parse(byte[] byArray, int n2) throws IOException {
        String string;
        CFFDataInput cFFDataInput = new CFFDataInput(byArray);
        if (n2 > 0) {
            cFFDataInput.setPosition(n2);
        }
        if (TAG_OTTO.equals(string = CFFParser.readTagName(cFFDataInput))) {
            cFFDataInput = this.createTaggedCFFDataInput(cFFDataInput, byArray);
        } else {
            if (TAG_TTCF.equals(string)) {
                throw new IOException("True Type Collection fonts are not supported.");
            }
            if (TAG_TTFONLY.equals(string)) {
                throw new IOException("OpenType fonts containing a true type font are not supported.");
            }
            cFFDataInput.setPosition(0);
        }
        Header header = CFFParser.readHeader(cFFDataInput);
        String[] stringArray = CFFParser.readStringIndexData(cFFDataInput);
        if (stringArray == null) {
            throw new IOException("Name index missing in CFF font");
        }
        byte[][] byArray2 = CFFParser.readIndexData(cFFDataInput);
        this.stringIndex = CFFParser.readStringIndexData(cFFDataInput);
        byte[][] byArray3 = CFFParser.readIndexData(cFFDataInput);
        ArrayList<CFFFont> arrayList = new ArrayList<CFFFont>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            CFFFont cFFFont = this.parseFont(cFFDataInput, stringArray[i2], byArray2[i2]);
            cFFFont.setGlobalSubrIndex(byArray3);
            cFFFont.setData(this.source);
            arrayList.add(cFFFont);
        }
        return arrayList;
    }

    private CFFDataInput createTaggedCFFDataInput(CFFDataInput cFFDataInput, byte[] byArray) throws IOException {
        int n2 = cFFDataInput.readShort();
        short s2 = cFFDataInput.readShort();
        short s3 = cFFDataInput.readShort();
        short s4 = cFFDataInput.readShort();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = CFFParser.readTagName(cFFDataInput);
            long l2 = CFFParser.readLong(cFFDataInput);
            long l3 = CFFParser.readLong(cFFDataInput);
            long l4 = CFFParser.readLong(cFFDataInput);
            if (!"CFF ".equals(string)) continue;
            byte[] byArray2 = Arrays.copyOfRange(byArray, (int)l3, (int)(l3 + l4));
            return new CFFDataInput(byArray2);
        }
        throw new IOException("CFF tag not found in this OpenType font.");
    }

    private static String readTagName(CFFDataInput cFFDataInput) throws IOException {
        byte[] byArray = cFFDataInput.readBytes(4);
        return new String(byArray, Charsets.ISO_8859_1);
    }

    private static long readLong(CFFDataInput cFFDataInput) throws IOException {
        return cFFDataInput.readCard16() << 16 | cFFDataInput.readCard16();
    }

    private static Header readHeader(CFFDataInput cFFDataInput) throws IOException {
        Header header = new Header();
        header.major = cFFDataInput.readCard8();
        header.minor = cFFDataInput.readCard8();
        header.hdrSize = cFFDataInput.readCard8();
        header.offSize = cFFDataInput.readOffSize();
        return header;
    }

    private static int[] readIndexDataOffsets(CFFDataInput cFFDataInput) throws IOException {
        int n2 = cFFDataInput.readCard16();
        if (n2 == 0) {
            return null;
        }
        int n3 = cFFDataInput.readOffSize();
        int[] nArray = new int[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            int n4 = cFFDataInput.readOffset(n3);
            if (n4 > cFFDataInput.length()) {
                throw new IOException("illegal offset value " + n4 + " in CFF font");
            }
            nArray[i2] = n4;
        }
        return nArray;
    }

    private static byte[][] readIndexData(CFFDataInput cFFDataInput) throws IOException {
        int[] nArray = CFFParser.readIndexDataOffsets(cFFDataInput);
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length - 1;
        byte[][] byArrayArray = new byte[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2 + 1] - nArray[i2];
            byArrayArray[i2] = cFFDataInput.readBytes(n3);
        }
        return byArrayArray;
    }

    private static String[] readStringIndexData(CFFDataInput cFFDataInput) throws IOException {
        int[] nArray = CFFParser.readIndexDataOffsets(cFFDataInput);
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length - 1;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2 + 1] - nArray[i2];
            if (n3 < 0) {
                throw new IOException("Negative index data length + " + n3 + " at " + i2 + ": offsets[" + (i2 + 1) + "]=" + nArray[i2 + 1] + ", offsets[" + i2 + "]=" + nArray[i2]);
            }
            stringArray[i2] = new String(cFFDataInput.readBytes(n3), Charsets.ISO_8859_1);
        }
        return stringArray;
    }

    private static DictData readDictData(CFFDataInput cFFDataInput) throws IOException {
        DictData dictData = new DictData();
        while (cFFDataInput.hasRemaining()) {
            dictData.add(CFFParser.readEntry(cFFDataInput));
        }
        return dictData;
    }

    private static DictData readDictData(CFFDataInput cFFDataInput, int n2) throws IOException {
        DictData dictData = new DictData();
        int n3 = cFFDataInput.getPosition() + n2;
        while (cFFDataInput.getPosition() < n3) {
            dictData.add(CFFParser.readEntry(cFFDataInput));
        }
        return dictData;
    }

    private static DictData.Entry readEntry(CFFDataInput cFFDataInput) throws IOException {
        int n2;
        DictData.Entry entry;
        block3: {
            entry = new DictData.Entry();
            while (true) {
                if ((n2 = cFFDataInput.readUnsignedByte()) >= 0 && n2 <= 21) break block3;
                if (n2 == 28 || n2 == 29) {
                    entry.operands.add(CFFParser.readIntegerNumber(cFFDataInput, n2));
                    continue;
                }
                if (n2 == 30) {
                    entry.operands.add(CFFParser.readRealNumber(cFFDataInput, n2));
                    continue;
                }
                if (n2 < 32 || n2 > 254) break;
                entry.operands.add(CFFParser.readIntegerNumber(cFFDataInput, n2));
            }
            throw new IOException("invalid DICT data b0 byte: " + n2);
        }
        entry.operator = CFFParser.readOperator(cFFDataInput, n2);
        return entry;
    }

    private static CFFOperator readOperator(CFFDataInput cFFDataInput, int n2) throws IOException {
        CFFOperator.Key key = CFFParser.readOperatorKey(cFFDataInput, n2);
        return CFFOperator.getOperator((CFFOperator.Key)key);
    }

    private static CFFOperator.Key readOperatorKey(CFFDataInput cFFDataInput, int n2) throws IOException {
        if (n2 == 12) {
            int n3 = cFFDataInput.readUnsignedByte();
            return new CFFOperator.Key(n2, n3);
        }
        return new CFFOperator.Key(n2);
    }

    private static Integer readIntegerNumber(CFFDataInput cFFDataInput, int n2) throws IOException {
        if (n2 == 28) {
            return cFFDataInput.readShort();
        }
        if (n2 == 29) {
            return cFFDataInput.readInt();
        }
        if (n2 >= 32 && n2 <= 246) {
            return n2 - 139;
        }
        if (n2 >= 247 && n2 <= 250) {
            int n3 = cFFDataInput.readUnsignedByte();
            return (n2 - 247) * 256 + n3 + 108;
        }
        if (n2 >= 251 && n2 <= 254) {
            int n4 = cFFDataInput.readUnsignedByte();
            return -(n2 - 251) * 256 - n4 - 108;
        }
        throw new IllegalArgumentException();
    }

    private static Double readRealNumber(CFFDataInput cFFDataInput, int n2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl) {
            int[] nArray;
            int n3 = cFFDataInput.readUnsignedByte();
            block10: for (int n4 : nArray = new int[]{n3 / 16, n3 % 16}) {
                switch (n4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        stringBuilder.append(n4);
                        bl2 = false;
                        continue block10;
                    }
                    case 10: {
                        stringBuilder.append(".");
                        continue block10;
                    }
                    case 11: {
                        if (bl3) {
                            LOG.warn((Object)("duplicate 'E' ignored after " + stringBuilder));
                            continue block10;
                        }
                        stringBuilder.append("E");
                        bl2 = true;
                        bl3 = true;
                        continue block10;
                    }
                    case 12: {
                        if (bl3) {
                            LOG.warn((Object)("duplicate 'E-' ignored after " + stringBuilder));
                            continue block10;
                        }
                        stringBuilder.append("E-");
                        bl2 = true;
                        bl3 = true;
                        continue block10;
                    }
                    case 13: {
                        continue block10;
                    }
                    case 14: {
                        stringBuilder.append("-");
                        continue block10;
                    }
                    case 15: {
                        bl = true;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        if (bl2) {
            stringBuilder.append("0");
        }
        if (stringBuilder.length() == 0) {
            return 0.0;
        }
        return Double.valueOf(stringBuilder.toString());
    }

    private CFFFont parseFont(CFFDataInput cFFDataInput, String string, byte[] byArray) throws IOException {
        Object object;
        DictData.Entry entry;
        CFFCIDFont cFFCIDFont;
        boolean bl;
        CFFDataInput cFFDataInput2 = new CFFDataInput(byArray);
        DictData dictData = CFFParser.readDictData(cFFDataInput2);
        DictData.Entry entry2 = dictData.getEntry("SyntheticBase");
        if (entry2 != null) {
            throw new IOException("Synthetic Fonts are not supported");
        }
        boolean bl2 = bl = dictData.getEntry("ROS") != null;
        if (bl) {
            cFFCIDFont = new CFFCIDFont();
            entry = dictData.getEntry("ROS");
            cFFCIDFont.setRegistry(this.readString(entry.getNumber(0).intValue()));
            cFFCIDFont.setOrdering(this.readString(entry.getNumber(1).intValue()));
            cFFCIDFont.setSupplement(entry.getNumber(2).intValue());
        } else {
            cFFCIDFont = new CFFType1Font();
        }
        this.debugFontName = string;
        cFFCIDFont.setName(string);
        cFFCIDFont.addValueToTopDict("version", (Object)this.getString(dictData, "version"));
        cFFCIDFont.addValueToTopDict("Notice", (Object)this.getString(dictData, "Notice"));
        cFFCIDFont.addValueToTopDict("Copyright", (Object)this.getString(dictData, "Copyright"));
        cFFCIDFont.addValueToTopDict("FullName", (Object)this.getString(dictData, "FullName"));
        cFFCIDFont.addValueToTopDict("FamilyName", (Object)this.getString(dictData, "FamilyName"));
        cFFCIDFont.addValueToTopDict("Weight", (Object)this.getString(dictData, "Weight"));
        cFFCIDFont.addValueToTopDict("isFixedPitch", (Object)dictData.getBoolean("isFixedPitch", false));
        cFFCIDFont.addValueToTopDict("ItalicAngle", (Object)dictData.getNumber("ItalicAngle", 0));
        cFFCIDFont.addValueToTopDict("UnderlinePosition", (Object)dictData.getNumber("UnderlinePosition", -100));
        cFFCIDFont.addValueToTopDict("UnderlineThickness", (Object)dictData.getNumber("UnderlineThickness", 50));
        cFFCIDFont.addValueToTopDict("PaintType", (Object)dictData.getNumber("PaintType", 0));
        cFFCIDFont.addValueToTopDict("CharstringType", (Object)dictData.getNumber("CharstringType", 2));
        cFFCIDFont.addValueToTopDict("FontMatrix", dictData.getArray("FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
        cFFCIDFont.addValueToTopDict("UniqueID", (Object)dictData.getNumber("UniqueID", null));
        cFFCIDFont.addValueToTopDict("FontBBox", dictData.getArray("FontBBox", Arrays.asList(0, 0, 0, 0)));
        cFFCIDFont.addValueToTopDict("StrokeWidth", (Object)dictData.getNumber("StrokeWidth", 0));
        cFFCIDFont.addValueToTopDict("XUID", dictData.getArray("XUID", null));
        entry = dictData.getEntry("CharStrings");
        int n2 = entry.getNumber(0).intValue();
        cFFDataInput.setPosition(n2);
        byte[][] byArray2 = CFFParser.readIndexData(cFFDataInput);
        DictData.Entry entry3 = dictData.getEntry("charset");
        if (entry3 != null) {
            int n3 = entry3.getNumber(0).intValue();
            if (!bl && n3 == 0) {
                object = CFFISOAdobeCharset.getInstance();
            } else if (!bl && n3 == 1) {
                object = CFFExpertCharset.getInstance();
            } else if (!bl && n3 == 2) {
                object = CFFExpertSubsetCharset.getInstance();
            } else {
                cFFDataInput.setPosition(n3);
                object = this.readCharset(cFFDataInput, byArray2.length, bl);
            }
        } else {
            object = bl ? new EmptyCharset(byArray2.length) : CFFISOAdobeCharset.getInstance();
        }
        cFFCIDFont.setCharset((CFFCharset)object);
        cFFCIDFont.charStrings = byArray2;
        if (bl) {
            List<Number> list;
            this.parseCIDFontDicts(cFFDataInput, dictData, cFFCIDFont, byArray2.length);
            List list2 = null;
            List list3 = cFFCIDFont.getFontDicts();
            if (!list3.isEmpty() && ((Map)list3.get(0)).containsKey("FontMatrix")) {
                list2 = (List)((Map)list3.get(0)).get("FontMatrix");
            }
            if ((list = dictData.getArray("FontMatrix", null)) == null) {
                if (list2 != null) {
                    cFFCIDFont.addValueToTopDict("FontMatrix", list2);
                } else {
                    cFFCIDFont.addValueToTopDict("FontMatrix", dictData.getArray("FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
                }
            } else if (list2 != null) {
                this.concatenateMatrix(list, list2);
            }
        } else {
            this.parseType1Dicts(cFFDataInput, dictData, (CFFType1Font)cFFCIDFont, (CFFCharset)object);
        }
        return cFFCIDFont;
    }

    private void concatenateMatrix(List<Number> list, List<Number> list2) {
        double d2 = list.get(0).doubleValue();
        double d3 = list.get(1).doubleValue();
        double d4 = list.get(2).doubleValue();
        double d5 = list.get(3).doubleValue();
        double d6 = list.get(4).doubleValue();
        double d7 = list.get(5).doubleValue();
        double d8 = list2.get(0).doubleValue();
        double d9 = list2.get(1).doubleValue();
        double d10 = list2.get(2).doubleValue();
        double d11 = list2.get(3).doubleValue();
        double d12 = list2.get(4).doubleValue();
        double d13 = list2.get(5).doubleValue();
        list.set(0, d2 * d8 + d3 * d10);
        list.set(1, d2 * d9 + d3 * d5);
        list.set(2, d4 * d8 + d5 * d10);
        list.set(3, d4 * d9 + d5 * d11);
        list.set(4, d6 * d8 + d7 * d10 + d12);
        list.set(5, d6 * d9 + d7 * d11 + d13);
    }

    private void parseCIDFontDicts(CFFDataInput cFFDataInput, DictData dictData, CFFCIDFont cFFCIDFont, int n2) throws IOException {
        DictData.Entry entry = dictData.getEntry("FDArray");
        if (entry == null) {
            throw new IOException("FDArray is missing for a CIDKeyed Font.");
        }
        int n3 = entry.getNumber(0).intValue();
        cFFDataInput.setPosition(n3);
        byte[][] byArray = CFFParser.readIndexData(cFFDataInput);
        LinkedList<Map<String, Object>> linkedList = new LinkedList<Map<String, Object>>();
        LinkedList linkedList2 = new LinkedList();
        for (byte[] byArray2 : byArray) {
            CFFDataInput cFFDataInput2 = new CFFDataInput(byArray2);
            DictData dictData2 = CFFParser.readDictData(cFFDataInput2);
            DictData.Entry entry2 = dictData2.getEntry("Private");
            if (entry2 == null) {
                throw new IOException("Font DICT invalid without \"Private\" entry");
            }
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
            linkedHashMap.put("FontName", this.getString(dictData2, "FontName"));
            linkedHashMap.put("FontType", dictData2.getNumber("FontType", 0));
            linkedHashMap.put("FontBBox", dictData2.getArray("FontBBox", null));
            linkedHashMap.put("FontMatrix", dictData2.getArray("FontMatrix", null));
            linkedList2.add(linkedHashMap);
            int n4 = entry2.getNumber(1).intValue();
            cFFDataInput.setPosition(n4);
            int n5 = entry2.getNumber(0).intValue();
            DictData dictData3 = CFFParser.readDictData(cFFDataInput, n5);
            Map<String, Object> map = this.readPrivateDict(dictData3);
            linkedList.add(map);
            int n6 = (Integer)dictData3.getNumber("Subrs", 0);
            if (n6 <= 0) continue;
            cFFDataInput.setPosition(n4 + n6);
            map.put("Subrs", CFFParser.readIndexData(cFFDataInput));
        }
        Object object = dictData.getEntry("FDSelect");
        int n7 = ((DictData.Entry)object).getNumber(0).intValue();
        cFFDataInput.setPosition(n7);
        FDSelect fDSelect = CFFParser.readFDSelect(cFFDataInput, n2, cFFCIDFont);
        cFFCIDFont.setFontDict(linkedList2);
        cFFCIDFont.setPrivDict(linkedList);
        cFFCIDFont.setFdSelect(fDSelect);
    }

    private Map<String, Object> readPrivateDict(DictData dictData) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(17);
        linkedHashMap.put("BlueValues", dictData.getDelta("BlueValues", null));
        linkedHashMap.put("OtherBlues", dictData.getDelta("OtherBlues", null));
        linkedHashMap.put("FamilyBlues", dictData.getDelta("FamilyBlues", null));
        linkedHashMap.put("FamilyOtherBlues", dictData.getDelta("FamilyOtherBlues", null));
        linkedHashMap.put("BlueScale", dictData.getNumber("BlueScale", 0.039625));
        linkedHashMap.put("BlueShift", dictData.getNumber("BlueShift", 7));
        linkedHashMap.put("BlueFuzz", dictData.getNumber("BlueFuzz", 1));
        linkedHashMap.put("StdHW", dictData.getNumber("StdHW", null));
        linkedHashMap.put("StdVW", dictData.getNumber("StdVW", null));
        linkedHashMap.put("StemSnapH", dictData.getDelta("StemSnapH", null));
        linkedHashMap.put("StemSnapV", dictData.getDelta("StemSnapV", null));
        linkedHashMap.put("ForceBold", dictData.getBoolean("ForceBold", false));
        linkedHashMap.put("LanguageGroup", dictData.getNumber("LanguageGroup", 0));
        linkedHashMap.put("ExpansionFactor", dictData.getNumber("ExpansionFactor", 0.06));
        linkedHashMap.put("initialRandomSeed", dictData.getNumber("initialRandomSeed", 0));
        linkedHashMap.put("defaultWidthX", dictData.getNumber("defaultWidthX", 0));
        linkedHashMap.put("nominalWidthX", dictData.getNumber("nominalWidthX", 0));
        return linkedHashMap;
    }

    private void parseType1Dicts(CFFDataInput cFFDataInput, DictData dictData, CFFType1Font cFFType1Font, CFFCharset cFFCharset) throws IOException {
        CFFStandardEncoding cFFStandardEncoding;
        DictData.Entry entry = dictData.getEntry("Encoding");
        int n2 = entry != null ? entry.getNumber(0).intValue() : 0;
        switch (n2) {
            case 0: {
                cFFStandardEncoding = CFFStandardEncoding.getInstance();
                break;
            }
            case 1: {
                cFFStandardEncoding = CFFExpertEncoding.getInstance();
                break;
            }
            default: {
                cFFDataInput.setPosition(n2);
                cFFStandardEncoding = this.readEncoding(cFFDataInput, cFFCharset);
            }
        }
        cFFType1Font.setEncoding((CFFEncoding)cFFStandardEncoding);
        DictData.Entry entry2 = dictData.getEntry("Private");
        if (entry2 == null) {
            throw new IOException("Private dictionary entry missing for font " + cFFType1Font.fontName);
        }
        int n3 = entry2.getNumber(1).intValue();
        cFFDataInput.setPosition(n3);
        int n4 = entry2.getNumber(0).intValue();
        DictData dictData2 = CFFParser.readDictData(cFFDataInput, n4);
        Map<String, Object> map = this.readPrivateDict(dictData2);
        for (Map.Entry<String, Object> entry3 : map.entrySet()) {
            cFFType1Font.addToPrivateDict(entry3.getKey(), entry3.getValue());
        }
        int n5 = (Integer)dictData2.getNumber("Subrs", 0);
        if (n5 > 0) {
            cFFDataInput.setPosition(n3 + n5);
            cFFType1Font.addToPrivateDict("Subrs", (Object)CFFParser.readIndexData(cFFDataInput));
        }
    }

    private String readString(int n2) throws IOException {
        if (n2 >= 0 && n2 <= 390) {
            return CFFStandardString.getName((int)n2);
        }
        if (n2 - 391 < this.stringIndex.length) {
            return this.stringIndex[n2 - 391];
        }
        return "SID" + n2;
    }

    private String getString(DictData dictData, String string) throws IOException {
        DictData.Entry entry = dictData.getEntry(string);
        return entry != null ? this.readString(entry.getNumber(0).intValue()) : null;
    }

    private CFFEncoding readEncoding(CFFDataInput cFFDataInput, CFFCharset cFFCharset) throws IOException {
        int n2 = cFFDataInput.readCard8();
        int n3 = n2 & 0x7F;
        switch (n3) {
            case 0: {
                return this.readFormat0Encoding(cFFDataInput, cFFCharset, n2);
            }
            case 1: {
                return this.readFormat1Encoding(cFFDataInput, cFFCharset, n2);
            }
        }
        throw new IllegalArgumentException();
    }

    private Format0Encoding readFormat0Encoding(CFFDataInput cFFDataInput, CFFCharset cFFCharset, int n2) throws IOException {
        Format0Encoding format0Encoding = new Format0Encoding();
        format0Encoding.format = n2;
        format0Encoding.nCodes = cFFDataInput.readCard8();
        format0Encoding.add(0, 0, ".notdef");
        for (int i2 = 1; i2 <= format0Encoding.nCodes; ++i2) {
            int n3 = cFFDataInput.readCard8();
            int n4 = cFFCharset.getSIDForGID(i2);
            format0Encoding.add(n3, n4, this.readString(n4));
        }
        if ((n2 & 0x80) != 0) {
            this.readSupplement(cFFDataInput, format0Encoding);
        }
        return format0Encoding;
    }

    private Format1Encoding readFormat1Encoding(CFFDataInput cFFDataInput, CFFCharset cFFCharset, int n2) throws IOException {
        Format1Encoding format1Encoding = new Format1Encoding();
        format1Encoding.format = n2;
        format1Encoding.nRanges = cFFDataInput.readCard8();
        format1Encoding.add(0, 0, ".notdef");
        int n3 = 1;
        for (int i2 = 0; i2 < format1Encoding.nRanges; ++i2) {
            int n4 = cFFDataInput.readCard8();
            int n5 = cFFDataInput.readCard8();
            for (int i3 = 0; i3 < 1 + n5; ++i3) {
                int n6 = cFFCharset.getSIDForGID(n3);
                int n7 = n4 + i3;
                format1Encoding.add(n7, n6, this.readString(n6));
                ++n3;
            }
        }
        if ((n2 & 0x80) != 0) {
            this.readSupplement(cFFDataInput, format1Encoding);
        }
        return format1Encoding;
    }

    private void readSupplement(CFFDataInput cFFDataInput, CFFBuiltInEncoding cFFBuiltInEncoding) throws IOException {
        cFFBuiltInEncoding.nSups = cFFDataInput.readCard8();
        cFFBuiltInEncoding.supplement = new CFFBuiltInEncoding.Supplement[cFFBuiltInEncoding.nSups];
        for (int i2 = 0; i2 < cFFBuiltInEncoding.supplement.length; ++i2) {
            CFFBuiltInEncoding.Supplement supplement = new CFFBuiltInEncoding.Supplement();
            supplement.code = cFFDataInput.readCard8();
            supplement.sid = cFFDataInput.readSID();
            supplement.name = this.readString(supplement.sid);
            cFFBuiltInEncoding.supplement[i2] = supplement;
            cFFBuiltInEncoding.add(supplement.code, supplement.sid, this.readString(supplement.sid));
        }
    }

    private static FDSelect readFDSelect(CFFDataInput cFFDataInput, int n2, CFFCIDFont cFFCIDFont) throws IOException {
        int n3 = cFFDataInput.readCard8();
        switch (n3) {
            case 0: {
                return CFFParser.readFormat0FDSelect(cFFDataInput, n3, n2, cFFCIDFont);
            }
            case 3: {
                return CFFParser.readFormat3FDSelect(cFFDataInput, n3, n2, cFFCIDFont);
            }
        }
        throw new IllegalArgumentException();
    }

    private static Format0FDSelect readFormat0FDSelect(CFFDataInput cFFDataInput, int n2, int n3, CFFCIDFont cFFCIDFont) throws IOException {
        Format0FDSelect format0FDSelect = new Format0FDSelect(cFFCIDFont);
        format0FDSelect.format = n2;
        format0FDSelect.fds = new int[n3];
        for (int i2 = 0; i2 < format0FDSelect.fds.length; ++i2) {
            format0FDSelect.fds[i2] = cFFDataInput.readCard8();
        }
        return format0FDSelect;
    }

    private static Format3FDSelect readFormat3FDSelect(CFFDataInput cFFDataInput, int n2, int n3, CFFCIDFont cFFCIDFont) throws IOException {
        Format3FDSelect format3FDSelect = new Format3FDSelect(cFFCIDFont);
        format3FDSelect.format = n2;
        format3FDSelect.nbRanges = cFFDataInput.readCard16();
        format3FDSelect.range3 = new Range3[format3FDSelect.nbRanges];
        for (int i2 = 0; i2 < format3FDSelect.nbRanges; ++i2) {
            Range3 range3 = new Range3();
            range3.first = cFFDataInput.readCard16();
            range3.fd = cFFDataInput.readCard8();
            format3FDSelect.range3[i2] = range3;
        }
        format3FDSelect.sentinel = cFFDataInput.readCard16();
        return format3FDSelect;
    }

    private CFFCharset readCharset(CFFDataInput cFFDataInput, int n2, boolean bl) throws IOException {
        int n3 = cFFDataInput.readCard8();
        switch (n3) {
            case 0: {
                return this.readFormat0Charset(cFFDataInput, n3, n2, bl);
            }
            case 1: {
                return this.readFormat1Charset(cFFDataInput, n3, n2, bl);
            }
            case 2: {
                return this.readFormat2Charset(cFFDataInput, n3, n2, bl);
            }
        }
        throw new IllegalArgumentException();
    }

    private Format0Charset readFormat0Charset(CFFDataInput cFFDataInput, int n2, int n3, boolean bl) throws IOException {
        Format0Charset format0Charset = new Format0Charset(bl);
        format0Charset.format = n2;
        if (bl) {
            format0Charset.addCID(0, 0);
        } else {
            format0Charset.addSID(0, 0, ".notdef");
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            int n4 = cFFDataInput.readSID();
            if (bl) {
                format0Charset.addCID(i2, n4);
                continue;
            }
            format0Charset.addSID(i2, n4, this.readString(n4));
        }
        return format0Charset;
    }

    private Format1Charset readFormat1Charset(CFFDataInput cFFDataInput, int n2, int n3, boolean bl) throws IOException {
        Format1Charset format1Charset = new Format1Charset(bl);
        format1Charset.format = n2;
        if (bl) {
            format1Charset.addCID(0, 0);
            format1Charset.rangesCID2GID = new ArrayList<RangeMapping>();
        } else {
            format1Charset.addSID(0, 0, ".notdef");
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            int n4 = cFFDataInput.readSID();
            int n5 = cFFDataInput.readCard8();
            if (!bl) {
                for (int i3 = 0; i3 < 1 + n5; ++i3) {
                    int n6 = n4 + i3;
                    format1Charset.addSID(i2 + i3, n6, this.readString(n6));
                }
            } else {
                format1Charset.rangesCID2GID.add(new RangeMapping(i2, n4, n5));
            }
            i2 += n5;
        }
        return format1Charset;
    }

    private Format2Charset readFormat2Charset(CFFDataInput cFFDataInput, int n2, int n3, boolean bl) throws IOException {
        Format2Charset format2Charset = new Format2Charset(bl);
        format2Charset.format = n2;
        if (bl) {
            format2Charset.addCID(0, 0);
            format2Charset.rangesCID2GID = new ArrayList<RangeMapping>();
        } else {
            format2Charset.addSID(0, 0, ".notdef");
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            int n4 = cFFDataInput.readSID();
            int n5 = cFFDataInput.readCard16();
            if (!bl) {
                for (int i3 = 0; i3 < 1 + n5; ++i3) {
                    int n6 = n4 + i3;
                    format2Charset.addSID(i2 + i3, n6, this.readString(n6));
                }
            } else {
                format2Charset.rangesCID2GID.add(new RangeMapping(i2, n4, n5));
            }
            i2 += n5;
        }
        return format2Charset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.debugFontName + "]";
    }

    public static interface ByteSource {
        public byte[] getBytes() throws IOException;
    }

    private static class Header {
        private int major;
        private int minor;
        private int hdrSize;
        private int offSize;

        private Header() {
        }

        public String toString() {
            return this.getClass().getName() + "[major=" + this.major + ", minor=" + this.minor + ", hdrSize=" + this.hdrSize + ", offSize=" + this.offSize + "]";
        }
    }

    private static class DictData {
        private final Map<String, Entry> entries = new HashMap<String, Entry>();

        private DictData() {
        }

        public void add(Entry entry) {
            if (entry.operator != null) {
                this.entries.put(entry.operator.getName(), entry);
            }
        }

        public Entry getEntry(String string) {
            return this.entries.get(string);
        }

        public Boolean getBoolean(String string, boolean bl) {
            Entry entry = this.getEntry(string);
            return entry != null && !entry.getArray().isEmpty() ? entry.getBoolean(0) : bl;
        }

        public List<Number> getArray(String string, List<Number> list) {
            Entry entry = this.getEntry(string);
            return entry != null && !entry.getArray().isEmpty() ? entry.getArray() : list;
        }

        public Number getNumber(String string, Number number) {
            Entry entry = this.getEntry(string);
            return entry != null && !entry.getArray().isEmpty() ? (Number)entry.getNumber(0) : (Number)number;
        }

        public List<Number> getDelta(String string, List<Number> list) {
            Entry entry = this.getEntry(string);
            return entry != null && !entry.getArray().isEmpty() ? entry.getDelta() : list;
        }

        public String toString() {
            return this.getClass().getName() + "[entries=" + this.entries + "]";
        }

        private static class Entry {
            private List<Number> operands = new ArrayList<Number>();
            private CFFOperator operator = null;

            private Entry() {
            }

            public Number getNumber(int n2) {
                return this.operands.get(n2);
            }

            public Boolean getBoolean(int n2) {
                Number number = this.operands.get(n2);
                if (number instanceof Integer) {
                    switch (number.intValue()) {
                        case 0: {
                            return Boolean.FALSE;
                        }
                        case 1: {
                            return Boolean.TRUE;
                        }
                    }
                }
                throw new IllegalArgumentException();
            }

            public List<Number> getArray() {
                return this.operands;
            }

            public List<Number> getDelta() {
                ArrayList<Number> arrayList = new ArrayList<Number>(this.operands);
                for (int i2 = 1; i2 < arrayList.size(); ++i2) {
                    Number number = (Number)arrayList.get(i2 - 1);
                    Number number2 = (Number)arrayList.get(i2);
                    Integer n2 = number.intValue() + number2.intValue();
                    arrayList.set(i2, n2);
                }
                return arrayList;
            }

            public String toString() {
                return this.getClass().getName() + "[operands=" + this.operands + ", operator=" + this.operator + "]";
            }
        }
    }

    private static class EmptyCharset
    extends EmbeddedCharset {
        protected EmptyCharset(int n2) {
            super(true);
            this.addCID(0, 0);
            for (int i2 = 1; i2 <= n2; ++i2) {
                this.addCID(i2, i2);
            }
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName();
        }
    }

    private static class Format0Encoding
    extends CFFBuiltInEncoding {
        private int format;
        private int nCodes;

        private Format0Encoding() {
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[format=" + this.format + ", nCodes=" + this.nCodes + ", supplement=" + Arrays.toString(this.supplement) + "]";
        }
    }

    private static class Format1Encoding
    extends CFFBuiltInEncoding {
        private int format;
        private int nRanges;

        private Format1Encoding() {
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[format=" + this.format + ", nRanges=" + this.nRanges + ", supplement=" + Arrays.toString(this.supplement) + "]";
        }
    }

    static abstract class CFFBuiltInEncoding
    extends CFFEncoding {
        private int nSups;
        private Supplement[] supplement;

        CFFBuiltInEncoding() {
        }

        static class Supplement {
            private int code;
            private int sid;
            private String name;

            Supplement() {
            }

            public int getCode() {
                return this.code;
            }

            public int getSID() {
                return this.sid;
            }

            public String getName() {
                return this.name;
            }

            public String toString() {
                return this.getClass().getName() + "[code=" + this.code + ", sid=" + this.sid + "]";
            }
        }
    }

    private static class Format0FDSelect
    extends FDSelect {
        private int format;
        private int[] fds;

        private Format0FDSelect(CFFCIDFont cFFCIDFont) {
            super(cFFCIDFont);
        }

        public int getFDIndex(int n2) {
            if (n2 < this.fds.length) {
                return this.fds[n2];
            }
            return 0;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[fds=" + Arrays.toString(this.fds) + "]";
        }
    }

    private static final class Format3FDSelect
    extends FDSelect {
        private int format;
        private int nbRanges;
        private Range3[] range3;
        private int sentinel;

        private Format3FDSelect(CFFCIDFont cFFCIDFont) {
            super(cFFCIDFont);
        }

        public int getFDIndex(int n2) {
            for (int i2 = 0; i2 < this.nbRanges; ++i2) {
                if (this.range3[i2].first > n2) continue;
                if (i2 + 1 < this.nbRanges) {
                    if (this.range3[i2 + 1].first <= n2) continue;
                    return this.range3[i2].fd;
                }
                if (this.sentinel > n2) {
                    return this.range3[i2].fd;
                }
                return -1;
            }
            return 0;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[format=" + this.format + " nbRanges=" + this.nbRanges + ", range3=" + Arrays.toString(this.range3) + " sentinel=" + this.sentinel + "]";
        }
    }

    private static final class Range3 {
        private int first;
        private int fd;

        private Range3() {
        }

        public String toString() {
            return this.getClass().getName() + "[first=" + this.first + ", fd=" + this.fd + "]";
        }
    }

    private static class Format0Charset
    extends EmbeddedCharset {
        private int format;

        protected Format0Charset(boolean bl) {
            super(bl);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[format=" + this.format + "]";
        }
    }

    private static class Format1Charset
    extends EmbeddedCharset {
        private int format;
        private List<RangeMapping> rangesCID2GID;

        protected Format1Charset(boolean bl) {
            super(bl);
        }

        public int getCIDForGID(int n2) {
            if (this.isCIDFont()) {
                for (RangeMapping rangeMapping : this.rangesCID2GID) {
                    if (!rangeMapping.isInRange(n2)) continue;
                    return rangeMapping.mapValue(n2);
                }
            }
            return super.getCIDForGID(n2);
        }

        public int getGIDForCID(int n2) {
            if (this.isCIDFont()) {
                for (RangeMapping rangeMapping : this.rangesCID2GID) {
                    if (!rangeMapping.isInReverseRange(n2)) continue;
                    return rangeMapping.mapReverseValue(n2);
                }
            }
            return super.getGIDForCID(n2);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[format=" + this.format + "]";
        }
    }

    private static class Format2Charset
    extends EmbeddedCharset {
        private int format;
        private List<RangeMapping> rangesCID2GID;

        protected Format2Charset(boolean bl) {
            super(bl);
        }

        public int getCIDForGID(int n2) {
            for (RangeMapping rangeMapping : this.rangesCID2GID) {
                if (!rangeMapping.isInRange(n2)) continue;
                return rangeMapping.mapValue(n2);
            }
            return super.getCIDForGID(n2);
        }

        public int getGIDForCID(int n2) {
            for (RangeMapping rangeMapping : this.rangesCID2GID) {
                if (!rangeMapping.isInReverseRange(n2)) continue;
                return rangeMapping.mapReverseValue(n2);
            }
            return super.getGIDForCID(n2);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[format=" + this.format + "]";
        }
    }

    private static final class RangeMapping {
        private final int startValue;
        private final int endValue;
        private final int startMappedValue;
        private final int endMappedValue;

        private RangeMapping(int n2, int n3, int n4) {
            this.startValue = n2;
            this.endValue = this.startValue + n4;
            this.startMappedValue = n3;
            this.endMappedValue = this.startMappedValue + n4;
        }

        boolean isInRange(int n2) {
            return n2 >= this.startValue && n2 <= this.endValue;
        }

        boolean isInReverseRange(int n2) {
            return n2 >= this.startMappedValue && n2 <= this.endMappedValue;
        }

        int mapValue(int n2) {
            if (this.isInRange(n2)) {
                return this.startMappedValue + (n2 - this.startValue);
            }
            return 0;
        }

        int mapReverseValue(int n2) {
            if (this.isInReverseRange(n2)) {
                return this.startValue + (n2 - this.startMappedValue);
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "[start value=" + this.startValue + ", end value=" + this.endValue + ", start mapped-value=" + this.startMappedValue + ", end mapped-value=" + this.endMappedValue + "]";
        }
    }

    static abstract class EmbeddedCharset
    extends CFFCharset {
        protected EmbeddedCharset(boolean bl) {
            super(bl);
        }
    }
}

