/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.json;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.transform.URIResolver;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.oxygen.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.validate.external.api.ExternalValidator;
import ro.sync.exml.validate.external.api.ValidationSeverity;
import ro.sync.exml.validate.external.json.JSONSchemaWarningsGenerator;
import ro.sync.exml.validate.external.json.JSONValidationUtil;

public class JSONValidator
implements ExternalValidator {
    private static final Logger logger = LoggerFactory.getLogger((String)JSONValidator.class.getName());
    private static final String INVALID_ASSOCIATED_SCHEMA = "The JSON Schema is empty, does not contain any definition.";
    private Schema compiledSchema;
    private ro.sync.exml.validate.external.api.ValidationException schemaException;
    private JSONSchemaWarningsGenerator warningsGenerator;

    public JSONValidator(Reader schemaReader, String schemaSystemId, SchemaClient httpClient) {
        JSONObject schemaJson = null;
        try {
            schemaJson = new JSONObject(new JSONTokener(schemaReader), true, false);
            Schema schema = this.compiledSchema = httpClient != null ? SchemaLoader.load(schemaJson, httpClient) : SchemaLoader.load(schemaJson);
            if (this.compiledSchema instanceof EmptySchema) {
                this.schemaException = new ro.sync.exml.validate.external.api.ValidationException(INVALID_ASSOCIATED_SCHEMA, schemaSystemId, ValidationSeverity.WARNING, null);
            }
            this.warningsGenerator = new JSONSchemaWarningsGenerator(schemaJson, httpClient, schemaSystemId);
        }
        catch (JSONException je) {
            this.schemaException = new ro.sync.exml.validate.external.api.ValidationException(je.getMessage(), schemaSystemId, ValidationSeverity.ERROR, (Throwable)je);
            JSONValidationUtil.setExceptionLocation(this.schemaException, je.getLocation());
        }
        catch (SchemaException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            if (ex.getCause() instanceof JSONException) {
                if (ex.getSchemaLocation() != null) {
                    schemaSystemId = JSONValidationUtil.getLocation(schemaSystemId, ex.getSchemaLocation());
                }
                this.schemaException = new ro.sync.exml.validate.external.api.ValidationException(ex.getMessage(), schemaSystemId, ValidationSeverity.ERROR, (Throwable)ex);
                JSONValidationUtil.setExceptionLocation(this.schemaException, ((JSONException)ex.getCause()).getLocation());
            } else {
                this.schemaException = JSONValidationUtil.createJsonSchemaException(ex.getSchemaLocation(), ex.getMessage(), true, schemaSystemId, httpClient, schemaJson);
            }
        }
        catch (Exception ex) {
            this.schemaException = new ro.sync.exml.validate.external.api.ValidationException(ex.getMessage(), schemaSystemId, ValidationSeverity.ERROR, (Throwable)ex);
        }
    }

    public List<ro.sync.exml.validate.external.api.ValidationException> validate(Reader reader, String systemID, URIResolver uriResolver, Map<String, String> additionalProperties) {
        List<Object> exList = new ArrayList<ro.sync.exml.validate.external.api.ValidationException>(1);
        if (this.schemaException == null) {
            Object instanceObject = null;
            try {
                instanceObject = JSONUtil.createJsonInstance((Reader)reader);
                this.compiledSchema.validate(instanceObject);
            }
            catch (ValidationException ve) {
                exList = JSONValidationUtil.createValidationProblems(systemID, instanceObject, ve);
            }
            catch (JSONException je) {
                ro.sync.exml.validate.external.api.ValidationException e = new ro.sync.exml.validate.external.api.ValidationException(je.getMessage(), systemID, ValidationSeverity.ERROR, (Throwable)je);
                JSONValidationUtil.setExceptionLocation(e, je.getLocation());
                exList.add(e);
            }
        } else {
            exList.add(this.schemaException);
        }
        HashSet set = new HashSet();
        exList = exList.stream().filter(ex -> set.add(ex.getMessage() + ex.getLineNumber() + ex.getColumnNumber())).collect(Collectors.toList());
        Collections.sort(exList, (p1, p2) -> {
            int diff = p1.getLineNumber() - p2.getLineNumber();
            return diff != 0 ? diff : p1.getColumnNumber() - p2.getColumnNumber();
        });
        return exList;
    }

    public ro.sync.exml.validate.external.api.ValidationException getSchemaException() {
        return this.schemaException;
    }

    public List<ro.sync.exml.validate.external.api.ValidationException> getIgnoredPropsWarnings() {
        ArrayList<ro.sync.exml.validate.external.api.ValidationException> warnings = new ArrayList<ro.sync.exml.validate.external.api.ValidationException>();
        if (this.warningsGenerator != null) {
            this.warningsGenerator.getUnprocessedPropsWarnings(this.compiledSchema).forEach(warnings::add);
        }
        return warnings;
    }

    public Schema getCompiledSchema() {
        return this.compiledSchema;
    }
}

