/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.converter;

import org.everit.json.schema.loader.SpecificationVersion;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONSchemaVersionConverter {
    private static final String REF = "$ref";
    private SpecificationVersion targetVersion;

    public JSONObject convertSchemaToSelectedVersion(String schema, SpecificationVersion targetVersion) {
        this.targetVersion = targetVersion;
        JSONObject schemaObject = new JSONObject(schema);
        schemaObject.put("$schema", (Object)targetVersion.metaSchemaUrls().get(0));
        if (schemaObject.has("id")) {
            schemaObject.put("$id", schemaObject.get("id"));
            schemaObject.remove("id");
        }
        this.parseSchema(schemaObject);
        return schemaObject;
    }

    private void parseSchema(JSONObject schema) {
        String[] properties = JSONObject.getNames((JSONObject)schema);
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                String property = properties[i];
                Object propertyValue = schema.get(property);
                if ("dependencies".equals(property)) {
                    this.convertDependencies(schema);
                } else if ("items".equals(property) && schema.opt(property) instanceof JSONArray && this.targetVersion.isAtLeast(SpecificationVersion.DRAFT_2020_12)) {
                    JSONArray tupleItems = (JSONArray)schema.get(property);
                    schema.put("prefixItems", (Object)tupleItems);
                    schema.remove(property);
                } else if ("additionalItems".equals(property) && schema.has("prefixItems") && this.targetVersion.isAtLeast(SpecificationVersion.DRAFT_2020_12)) {
                    schema.put("items", schema.get(property));
                    schema.remove(property);
                } else if (("exclusiveMaximum".equals(property) || "exclusiveMinimum".equals(property)) && schema.get(property) instanceof Boolean) {
                    schema.remove(property);
                } else if ("definitions".equals(property) && schema.opt(property) instanceof JSONObject) {
                    schema.put("$defs", (Object)schema.getJSONObject(property));
                    schema.remove(property);
                } else if (REF.equals(property) && schema.get(property) instanceof String) {
                    schema.put(property, (Object)schema.getString(property).replace("/definitions/", "/$defs/"));
                } else if ("allOf".equals(property)) {
                    this.extractNestedRef(schema);
                }
                this.parseObjectOrArray(propertyValue);
            }
        }
    }

    private void parseObjectOrArray(Object propertyValue) {
        if (propertyValue instanceof JSONObject) {
            this.parseSchema((JSONObject)propertyValue);
        } else if (propertyValue instanceof JSONArray) {
            for (Object item : (JSONArray)propertyValue) {
                if (!(item instanceof JSONObject)) continue;
                this.parseSchema((JSONObject)item);
            }
        }
    }

    private void extractNestedRef(JSONObject schema) {
        JSONObject nestedObjectSchema;
        JSONArray allOfArray = schema.optJSONArray("allOf");
        if (allOfArray != null && allOfArray.length() == 1 && allOfArray.optJSONObject(0) != null && (nestedObjectSchema = allOfArray.optJSONObject(0)).has(REF) && nestedObjectSchema.opt(REF) instanceof String && !schema.has(REF)) {
            schema.put(REF, (Object)nestedObjectSchema.getString(REF).replace("/definitions/", "/$defs/"));
            schema.remove("allOf");
        }
    }

    private void convertDependencies(JSONObject schema) {
        JSONObject dependenciesObject = schema.optJSONObject("dependencies");
        if (dependenciesObject != null) {
            for (String dependency : dependenciesObject.keySet()) {
                Object dependencyValue = dependenciesObject.get(dependency);
                if (dependencyValue instanceof JSONObject) {
                    if (schema.has("dependentSchemas") && schema.opt("dependentSchemas") instanceof JSONObject) {
                        schema.getJSONObject("dependentSchemas").put(dependency, dependencyValue);
                        continue;
                    }
                    schema.put("dependentSchemas", (Object)new JSONObject().put(dependency, dependencyValue));
                    continue;
                }
                if (!(dependencyValue instanceof JSONArray)) continue;
                if (schema.has("dependentRequired") && schema.opt("dependentRequired") instanceof JSONObject) {
                    schema.getJSONObject("dependentRequired").put(dependency, dependencyValue);
                    continue;
                }
                schema.put("dependentRequired", (Object)new JSONObject().put(dependency, dependencyValue));
            }
            schema.remove("dependencies");
        }
    }
}

