/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class StringHighlighter
extends Highlighter {
    private String start;
    private String end;
    private String escape;
    private boolean doubleEscapes;
    private boolean spansNewLines;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.start = params.getParam("string");
        this.end = params.getParam("endString", this.start);
        this.escape = params.getParam("escape");
        this.doubleEscapes = params.isSet("doubleEscapes");
        this.spansNewLines = params.isSet("spanNewLines");
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
    }

    @Override
    public boolean startsWith(CharIter in) {
        return in.startsWith(this.start);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        in.moveNext(this.start.length());
        boolean wasEscape = false;
        while (!in.finished()) {
            block5: {
                if (!this.spansNewLines && StringHighlighter.isNewLine(in.current())) break;
                if (in.startsWith(this.end) && !wasEscape) {
                    if (this.doubleEscapes && in.startsWith(this.end, this.end.length())) {
                        in.moveNext();
                        break block5;
                    } else {
                        in.moveNext(this.end.length() - 1);
                        break;
                    }
                }
                wasEscape = this.escape != null && in.startsWith(this.escape) && !wasEscape;
            }
            in.moveNext();
        }
        if (!in.finished()) {
            in.moveNext();
        }
        out.add(in.markedToStyledBlock(this.styleName));
        return true;
    }

    @Override
    public String getDefaultStyle() {
        return "string";
    }
}

