/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class RegexHighlighterEx
extends Highlighter {
    protected Pattern pattern;
    protected Matcher matcher;
    protected boolean finished;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        String[] flagString;
        super.init(params);
        int flags = 0;
        String[] stringArray = flagString = params.getParam("flags", "").split("[;,]");
        int n = flagString.length;
        int n2 = 0;
        while (n2 < n) {
            String flag = stringArray[n2];
            if ("CASE_INSENSITIVE".equalsIgnoreCase(flag = flag.trim())) {
                flags += 2;
            } else if ("DOTALL".equalsIgnoreCase(flag)) {
                flags += 32;
            } else if ("MULTILINE".equalsIgnoreCase(flag)) {
                flags += 8;
            } else if ("UNICODE_CASE".equalsIgnoreCase(flag)) {
                flags += 64;
            } else if ("LITERAL".equalsIgnoreCase(flag)) {
                flags += 16;
            } else if ("UNIX_LINES".equalsIgnoreCase(flag)) {
                ++flags;
            } else if ("COMMENTS".equalsIgnoreCase(flag)) {
                flags += 4;
            } else if ("CANON_EQ".equalsIgnoreCase(flag)) {
                flags += 128;
            }
            ++n2;
        }
        String pat = params.getParam("pattern");
        if (params.isSet("pattern")) {
            try {
                this.pattern = Pattern.compile(pat, flags);
            }
            catch (PatternSyntaxException e) {
                throw new HighlighterConfigurationException(e.getMessage(), e);
            }
        }
        if (this.pattern == null) {
            throw new HighlighterConfigurationException("Required parameter 'pattern' is not set.");
        }
    }

    @Override
    public String getDefaultStyle() {
        return null;
    }

    @Override
    public void reset() {
        this.matcher = null;
        this.finished = false;
    }

    @Override
    public boolean startsWith(CharIter in) {
        if (this.matcher == null) {
            this.matcher = in.createMatcher(this.pattern);
            this.finished = !this.matcher.find();
        }
        while (!this.finished && this.matcher.start() < in.getPosition()) {
            boolean bl = this.finished = !this.matcher.find();
        }
        if (!this.finished) {
            return this.matcher.start() == in.getPosition();
        }
        return false;
    }

    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        if (!this.finished) {
            in.moveNext(this.matcher.end() - this.matcher.start());
            out.add(in.markedToStyledBlock(this.styleName));
            this.finished = !this.matcher.find();
            return true;
        }
        return false;
    }
}

