/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.Collection;
import java.util.HashSet;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public abstract class WholeHighlighter
extends Highlighter {
    private Collection<String> styles = new HashSet<String>();
    private boolean emptyStyle = true;
    private boolean allStyles = false;

    void loadStyles(Params params) {
        if (!params.isSet("empty")) {
            this.emptyStyle = false;
        }
        if (params.isSet("all")) {
            this.allStyles = true;
            return;
        }
        params.getMutliParams("style", this.styles);
    }

    boolean appliesOnEmptyStyle() {
        return this.emptyStyle;
    }

    boolean appliesOnAllStyles() {
        return this.allStyles;
    }

    boolean appliesOnStyle(String style) {
        return this.styles.contains(style);
    }

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        if (params != null && params.isSet("applyOnStyles")) {
            this.loadStyles(params.getParams("applyOnStyles"));
        }
    }
}

