/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.xslthl.Block;
import net.sf.xslthl.Config;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.StyledBlock;

public class ConnectorSaxonEE {
    private static Location fakeLocation = new Location(){

        @Override
        public Location saveLocation() {
            return this;
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        @Override
        public int getColumnNumber() {
            return 0;
        }
    };

    private static void blockToSaxon6Node(Block b, Builder builder, Config config) throws Exception {
        if (b.isStyled()) {
            Class<?> fpQnameClazz = Class.forName("net.sf.saxon.om.FingerprintedQName");
            Constructor<?> constructor = fpQnameClazz.getConstructor(String.class, String.class, String.class);
            Object fpQname = constructor.newInstance(config.prefix, config.uri, ((StyledBlock)b).getStyle());
            ConnectorSaxonEE.startElement(builder, fpQname);
            ConnectorSaxonEE.outputCharacters(builder, b.getText());
            builder.endElement();
        } else {
            ConnectorSaxonEE.outputCharacters(builder, b.getText());
        }
    }

    private static void startElement(Builder builder, Object fpQname) throws Exception {
        try {
            Method startElement = builder.getClass().getMethod("startElement", Class.forName("net.sf.saxon.om.NodeName"), SchemaType.class, Integer.TYPE, Integer.TYPE);
            startElement.invoke((Object)builder, fpQname, AnyType.getInstance(), 0, 0);
        }
        catch (Exception ex) {
            Method startElement = builder.getClass().getMethod("startElement", Class.forName("net.sf.saxon.om.NodeName"), SchemaType.class, Class.forName("net.sf.saxon.expr.parser.Location"), Integer.TYPE);
            startElement.invoke((Object)builder, fpQname, AnyType.getInstance(), fakeLocation, 0);
        }
    }

    private static void outputCharacters(Builder builder, String text) throws Exception {
        Method characters = null;
        try {
            characters = builder.getClass().getMethod("characters", String.class, Integer.TYPE, Integer.TYPE);
            characters.invoke((Object)builder, text, 0, 0);
        }
        catch (Exception ex) {
            characters = builder.getClass().getMethod("characters", CharSequence.class, Class.forName("net.sf.saxon.expr.parser.Location"), Integer.TYPE);
            characters.invoke((Object)builder, text, fakeLocation, 0);
        }
    }

    public static SequenceIterator highlight(XPathContext context, String hlCode, SequenceIterator nodes) throws Exception {
        return ConnectorSaxonEE.highlight(context, hlCode, nodes, null);
    }

    public static SequenceIterator highlight(XPathContext context, String hlCode, SequenceIterator seq, String configFilename) throws Exception {
        try {
            Config c = Config.getInstance(configFilename);
            MainHighlighter hl = c.getMainHighlighter(hlCode);
            byte childType = (Byte)Class.forName("net.sf.saxon.om.AxisInfo").getField("CHILD").get(null);
            Method iterateAxis = Class.forName("net.sf.saxon.om.NodeInfo").getMethod("iterateAxis", Byte.TYPE, Class.forName("net.sf.saxon.pattern.NodeTest"));
            Class<?> axisIterClazz = Class.forName("net.sf.saxon.tree.iter.AxisIterator");
            Method next = axisIterClazz.getMethod("next", new Class[0]);
            ArrayList<Object> resultNodes = new ArrayList<Object>();
            Item itm = null;
            while ((itm = seq.next()) != null) {
                if (itm instanceof NodeInfo) {
                    NodeInfo ni = (NodeInfo)itm;
                    SequenceIterator ae = (SequenceIterator)iterateAxis.invoke((Object)ni, childType, AnyNodeTest.getInstance());
                    Item itm2 = null;
                    while ((itm2 = ae.next()) != null) {
                        if (itm2 instanceof NodeInfo) {
                            NodeInfo n2i = (NodeInfo)itm2;
                            if (n2i.getNodeKind() == 3) {
                                if (hl != null) {
                                    Builder builder = context.getController().makeBuilder();
                                    builder.open();
                                    builder.startDocument(0);
                                    List<Block> l = hl.highlight(n2i.getStringValue());
                                    for (Block b : l) {
                                        ConnectorSaxonEE.blockToSaxon6Node(b, builder, c);
                                    }
                                    builder.endDocument();
                                    builder.close();
                                    NodeInfo doc = builder.getCurrentRoot();
                                    Object elms = iterateAxis.invoke((Object)doc, childType, AnyNodeTest.getInstance());
                                    Item crt = null;
                                    while ((crt = (Item)next.invoke(elms, new Object[0])) != null) {
                                        resultNodes.add(crt);
                                    }
                                    continue;
                                }
                                resultNodes.add(n2i);
                                continue;
                            }
                            resultNodes.add(n2i);
                            continue;
                        }
                        resultNodes.add(itm2);
                    }
                    continue;
                }
                resultNodes.add(itm);
            }
            Class<?> lstIterClassName = Class.forName("net.sf.saxon.tree.iter.ListIterator");
            Constructor<?> constructor = lstIterClassName.getConstructor(List.class);
            return (SequenceIterator)constructor.newInstance(resultNodes);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

