/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dynamic.resources.converter;

import com.oxygenxml.dynamic.resources.converter.ConverterLicenseValidationHandler;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.xml.sax.ErrorHandler;
import ro.sync.licensemanager.base.LicenseCheckerWithOxygenParent;
import ro.sync.licensemanager.webhelp.WebHelpLicenseChecker;

public class LicenseCheckUtil {
    private static final String PUBLISHING_LICENSE_FILENAME = "licensekey.txt";
    private static boolean wasCheckedForLicense = false;
    private static IOException licenseException = null;

    private LicenseCheckUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void checkLicense(String pluginDir, String productName, ErrorHandler errorHandler) throws IOException {
        if (!wasCheckedForLicense) {
            ConverterLicenseValidationHandler validationHandler = new ConverterLicenseValidationHandler(errorHandler);
            if (pluginDir != null) {
                WebHelpLicenseChecker whLicenseChecker = new WebHelpLicenseChecker((LicenseCheckerWithOxygenParent.LicenseValidationHandler)validationHandler, pluginDir, PUBLISHING_LICENSE_FILENAME, LicenseCheckUtil.getInvalidLicenseMessage(pluginDir), productName, new String[]{"Publishing-Engine"});
                whLicenseChecker.checkLicense();
                wasCheckedForLicense = true;
                if (!validationHandler.hasErrors()) return;
                licenseException = new IOException(validationHandler.getErrorMessage());
                throw licenseException;
            }
            licenseException = new IOException("The " + productName + " directory cannot be determined.");
            wasCheckedForLicense = true;
            throw licenseException;
        }
        if (licenseException == null) return;
        throw licenseException;
    }

    private static String getInvalidLicenseMessage(String pluginDirPath) {
        return MessageFormat.format("Cannot find a valid \"{0}\" license file in:\n- the DITA-OT directory: \"{1}\"\n- the plugin base directory: \"{2}\"\n\nPlease place your Oxygen Publishing Engine license key in a file called \"{3}\" and copy it to one of the above locations.\n\nIf you do not have a license key or you need more details, please contact sales@oxygenxml.com.\n", PUBLISHING_LICENSE_FILENAME, LicenseCheckUtil.getDitaOtDirPath(pluginDirPath), pluginDirPath, PUBLISHING_LICENSE_FILENAME);
    }

    private static String getDitaOtDirPath(String pluginDirPath) {
        String ditaOtDirPath = null;
        if (pluginDirPath != null) {
            try {
                File ditaOtDir;
                File pluginDir = new File(pluginDirPath).getCanonicalFile();
                File ditaOtPluginsDir = pluginDir.getParentFile();
                if (ditaOtPluginsDir != null && (ditaOtDir = ditaOtPluginsDir.getParentFile()) != null) {
                    ditaOtDirPath = ditaOtDir.getAbsolutePath();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ditaOtDirPath == null) {
            ditaOtDirPath = "[DITA-OT-DIRECTORY]";
        }
        return ditaOtDirPath;
    }
}

