/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dynamic.resources.converter;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterCreator;
import com.oxygenxml.batch.converter.core.converters.word.FileImageManager;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import com.oxygenxml.dynamic.resources.converter.ConverterUtil;
import com.oxygenxml.dynamic.resources.converter.LicenseCheckUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.CatalogResourceResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ResourceResolver;
import org.dita.dost.util.CatalogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.Resolver;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;

public abstract class ConverterReader
implements XMLReader {
    private static final Logger logger = LoggerFactory.getLogger((String)ConverterReader.class.getName());
    private static final String PRODUCT_NAME = "Oxygen Dynamic Resources Converter plugin";
    private EntityResolver resolver;
    private ContentHandler handler;
    private ErrorHandler errorHandler;
    private static final HashMap<String, String> CACHE_FOR_CONVERTED_CONTENT = new HashMap();
    private static final String IMPOSED_MAIN_MEDIA_FOLDER_NAME = "oxy-converter-media";
    private static final String FILE_MEDIA_FOLDER_NAME_SUFFIX = "-media-resources";
    private static final HashSet<File> MEDIA_FOLDERS = new HashSet();
    private String pluginDirPath;
    private static boolean isShutdownHookAdded;
    private boolean shouldCreateContentForPreview;

    private static synchronized void addShutDownHook() {
        if (!isShutdownHookAdded) {
            Runtime.getRuntime().addShutdownHook(new Thread("Remove media items"){

                @Override
                public void run() {
                    for (File mediaDir : MEDIA_FOLDERS) {
                        FileSystemUtil.deleteRecursivelly((File)mediaDir);
                    }
                }
            });
            isShutdownHookAdded = true;
        }
    }

    public ConverterReader() {
        this(false);
    }

    public ConverterReader(boolean shouldCreateContentForPreview) {
        this.shouldCreateContentForPreview = shouldCreateContentForPreview;
        if (!shouldCreateContentForPreview) {
            File pluginXmlFile;
            ConverterReader.addShutDownHook();
            String pluginPath = "plugin:com.oxygenxml.dynamic.resources.converter:plugin.xml";
            Resolver uriResolver = CatalogUtils.getCatalogResolver();
            ResolvedResource pluginFileResource = uriResolver.getCatalogResolver().resolveURI(pluginPath, null);
            if (pluginFileResource != null && pluginFileResource.getResolvedURI() != null && (pluginXmlFile = URLUtil.getCanonicalFileFromFileUrl((URL)URLUtil.convertToURL((String)pluginFileResource.getResolvedURI().toString()))) != null) {
                this.pluginDirPath = pluginXmlFile.getParentFile().getAbsolutePath();
                try {
                    InputStream is = pluginFileResource.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.pluginDirPath == null) {
                logger.error("The Dynamic Resources Converter plugin directory cannot be determined, ");
            }
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        LicenseCheckUtil.checkLicense(this.pluginDirPath, PRODUCT_NAME, this.errorHandler);
        URL url = new URL(input.getSystemId());
        try {
            String contentKey = URLUtil.getCanonicalURL((URL)url).toExternalForm();
            String convertedContent = CACHE_FOR_CONVERTED_CONTENT.get(contentKey);
            if (convertedContent == null) {
                Object imposedMediaFolder = IMPOSED_MAIN_MEDIA_FOLDER_NAME;
                String inputFileName = URLUtil.uncorrect((String)URLUtil.extractFileName((URL)url));
                if (inputFileName != null) {
                    imposedMediaFolder = (String)imposedMediaFolder + "/" + URLUtil.removeExtension((String)inputFileName) + FILE_MEDIA_FOLDER_NAME_SUFFIX;
                }
                File mediaFolder = new File(URLUtil.getCanonicalFileFromFileUrl((URL)url).getParentFile(), (String)imposedMediaFolder);
                mediaFolder = ConverterFileUtils.getUniqueFileWithCounter((File)mediaFolder, (boolean)false);
                FileImageManager.imposeMediaDirectoryInOutput((File)mediaFolder);
                convertedContent = this.convertContent(input);
                CACHE_FOR_CONVERTED_CONTENT.put(contentKey, convertedContent);
                MEDIA_FOLDERS.add(new File(URLUtil.getCanonicalFileFromFileUrl((URL)url).getParentFile(), IMPOSED_MAIN_MEDIA_FOLDER_NAME));
            }
            Configuration config = new Configuration();
            Resolver resolver = CatalogUtils.getCatalogResolver();
            ParseOptions parseOptions = config.getParseOptions();
            parseOptions.withEntityResolver((EntityResolver)resolver);
            config.setParseOptions(parseOptions);
            config.setResourceResolver((ResourceResolver)new CatalogResourceResolver(resolver));
            Transformer transformer = new TransformerFactoryImpl(config).newTransformer();
            transformer.transform(new StreamSource(new StringReader(convertedContent), url.toExternalForm()), new SAXResult(this.handler));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String convertContent(InputSource input) throws TransformerException, SAXException, IOException {
        String convertedContent = "";
        URL url = URLUtil.convertToURL((String)input.getSystemId());
        String converterType = this.determineConverterType(URLUtil.getExtension((String)url.toExternalForm()));
        if (converterType != null) {
            final File fileToConvert = URLUtil.getCanonicalFileFromFileUrl((URL)url);
            if (fileToConvert != null) {
                Converter converter = ConverterCreator.create((String)converterType);
                converter = this.customizeConverter(converter);
                ConversionResult conversionResult = converter.convert(fileToConvert, input.getCharacterStream(), stylesheet -> ConverterUtil.createTransformer(stylesheet, this.resolver), new ConversionInputsProvider(){

                    public File getOutputFolder() {
                        return fileToConvert.getParentFile();
                    }

                    public List<File> getInputFiles() {
                        return Arrays.asList(fileToConvert);
                    }

                    public Boolean getAdditionalOptionValue(String additionalOptionId) {
                        Boolean toRet = null;
                        if (ConverterReader.this.shouldCreateContentForPreview && "forbid.creating.external.content".equals(additionalOptionId)) {
                            toRet = true;
                        }
                        return toRet;
                    }

                    public Integer getMaxHeadingLevelForCreatingTopics() {
                        return null;
                    }

                    public String getFormatForSameTypeReferences() {
                        return ConverterReader.this.getFormat();
                    }
                });
                convertedContent = ConverterUtil.enrichWithDoctype(conversionResult, converterType, this.resolver);
            }
        } else {
            this.errorHandler.error(new SAXParseException("The '" + input.getSystemId() + "' file format is not supported by converter.", "", "", 0, 0));
        }
        return convertedContent;
    }

    public Converter customizeConverter(Converter converter) {
        return converter;
    }

    public abstract String determineConverterType(String var1);

    public abstract String[] getAllowedInputExtensions();

    public abstract String getFormat();

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }
}

