/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.spansupport.TEITableCellSpanProvider;
import ro.sync.ecss.extensions.tei.table.TEIConstants;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TEIDocumentTypeHelper
extends AbstractDocumentTypeHelper
implements TEIConstants {
    private static final String[] ROW_ELEMENT_NAMES = new String[]{"row"};
    private static final String[] CELL_ELEMENT_NAMES = new String[]{"cell"};
    private static final String[] TABLE_ELEMENT_NAMES = new String[]{"table"};

    @Override
    public void checkTableColSpanIsDefined(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableCellSpanProvider, AuthorElement cellElement) throws AuthorOperationException {
    }

    @Override
    public String[] getTableCellElementNames() {
        return CELL_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableElementLocalName() {
        return TABLE_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableRowElementNames() {
        return ROW_ELEMENT_NAMES;
    }

    @Override
    public AuthorTableCellSpanProvider getTableCellSpanProvider(AuthorElement tableElement) {
        TEITableCellSpanProvider tableCellSpanProvider = new TEITableCellSpanProvider();
        tableCellSpanProvider.init(tableElement);
        return tableCellSpanProvider;
    }

    @Override
    public void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableCellSpanProvider, AuthorElement cellElement, int startCol, int endCol) {
        int colSpan = endCol - startCol + 1;
        if (colSpan > 1) {
            authorAccess.getDocumentController().setAttribute("cols", new AttrValue(String.valueOf(colSpan)), cellElement);
        } else {
            authorAccess.getDocumentController().removeAttribute("cols", cellElement);
        }
    }

    @Override
    public void updateTableRowSpan(AuthorAccess authorAccess, AuthorElement cellElement, int rowSpan) {
        if (rowSpan > 1) {
            authorAccess.getDocumentController().setAttribute("rows", new AttrValue(String.valueOf(rowSpan)), cellElement);
        } else {
            authorAccess.getDocumentController().removeAttribute("rows", cellElement);
        }
    }

    @Override
    public void updateTableColumnNumber(AuthorAccess authorAccess, AuthorElement tableElement, int colNumber) {
        authorAccess.getDocumentController().setAttribute("cols", new AttrValue(String.valueOf(colNumber)), tableElement);
    }

    @Override
    public void updateTableRowNumber(AuthorAccess authorAccess, AuthorElement tableElement, int relativeValue) {
        AttrValue oldValue = tableElement.getAttribute("rows");
        if (oldValue != null && oldValue.getValue() != null) {
            try {
                int oldNumberOfRows = NumberParserUtil.parseInt((String)oldValue.getValue());
                authorAccess.getDocumentController().setAttribute("rows", new AttrValue(String.valueOf(oldNumberOfRows + relativeValue)), tableElement);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String[] getIgnoredRowAttributes() {
        return new String[]{"rows"};
    }

    @Override
    public String[] getIgnoredCellIDAttributes() {
        return new String[]{"xml:id", "id"};
    }

    @Override
    public String[] getIgnoredColumnAttributes() {
        return new String[]{"cols"};
    }
}

