/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;
import ro.sync.ecss.extensions.commons.table.support.HTMLTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSandHTMLTableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider {
    private CALSTableCellInfoProvider calsTableCellInfoProvider = new CALSTableCellInfoProvider();
    private HTMLTableCellInfoProvider htmlTableCellInfoProvider = new HTMLTableCellInfoProvider();

    public Integer getColSpan(AuthorElement cellElement) {
        Integer toReturn = this.htmlTableCellInfoProvider.getColSpan(cellElement);
        if (toReturn == null) {
            toReturn = this.calsTableCellInfoProvider.getColSpan(cellElement);
        }
        return toReturn;
    }

    public Integer getRowSpan(AuthorElement cellElement) {
        Integer toReturn = this.htmlTableCellInfoProvider.getRowSpan(cellElement);
        if (toReturn == null) {
            toReturn = this.calsTableCellInfoProvider.getRowSpan(cellElement);
        }
        return toReturn;
    }

    public void init(AuthorElement tableNode) {
        this.calsTableCellInfoProvider.init(tableNode);
        this.htmlTableCellInfoProvider.init(tableNode);
    }

    public String getDescription() {
        return "Provides information about cells in CALS and HTML tables";
    }

    public AuthorTableCellSpanProvider getCALSTableCellSpanProvider() {
        return this.calsTableCellInfoProvider;
    }

    public AuthorTableCellSpanProvider getXHTMLTableCellSpanProvider() {
        return this.htmlTableCellInfoProvider;
    }

    public boolean hasColumnSpecifications(AuthorElement tableElement) {
        boolean hasCols = false;
        hasCols = "tgroup".equalsIgnoreCase(tableElement.getLocalName()) ? this.calsTableCellInfoProvider.hasColumnSpecifications(tableElement) : this.htmlTableCellInfoProvider.hasColumnSpecifications(tableElement);
        return hasCols;
    }

    public List<WidthRepresentation> getCellWidth(AuthorElement cellElement, int colNumberStart, int colSpan) {
        List<WidthRepresentation> toReturn = this.htmlTableCellInfoProvider.getCellWidth(cellElement, colNumberStart, colSpan);
        if (toReturn == null) {
            toReturn = this.calsTableCellInfoProvider.getCellWidth(cellElement, colNumberStart, colSpan);
        }
        return toReturn;
    }

    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] colWidths, String tableCellsTagName) throws AuthorOperationException {
        this.calsTableCellInfoProvider.commitColumnWidthModifications(authorDocumentController, colWidths, tableCellsTagName);
        this.htmlTableCellInfoProvider.commitColumnWidthModifications(authorDocumentController, colWidths, tableCellsTagName);
    }

    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int newTableWidth, String tableCellsTagName) throws AuthorOperationException {
        this.calsTableCellInfoProvider.commitTableWidthModification(authorDocumentController, newTableWidth, tableCellsTagName);
        this.htmlTableCellInfoProvider.commitTableWidthModification(authorDocumentController, newTableWidth, tableCellsTagName);
    }

    public WidthRepresentation getTableWidth(String tableCellsTagName) {
        WidthRepresentation toReturn = this.calsTableCellInfoProvider.getTableWidth(tableCellsTagName);
        if (toReturn == null) {
            toReturn = this.htmlTableCellInfoProvider.getTableWidth(tableCellsTagName);
        }
        return toReturn;
    }

    public boolean isTableAcceptingWidth(String tableCellsTagName) {
        return this.calsTableCellInfoProvider.isTableAcceptingWidth(tableCellsTagName) || this.htmlTableCellInfoProvider.isTableAcceptingWidth(tableCellsTagName);
    }

    public boolean isTableAndColumnsResizable(String tableCellsTagName) {
        return this.calsTableCellInfoProvider.isTableAndColumnsResizable(tableCellsTagName) || this.htmlTableCellInfoProvider.isTableAndColumnsResizable(tableCellsTagName);
    }

    public boolean isAcceptingFixedColumnWidths(String tableCellsTagName) {
        return this.calsTableCellInfoProvider.isAcceptingFixedColumnWidths(tableCellsTagName) || this.htmlTableCellInfoProvider.isAcceptingFixedColumnWidths(tableCellsTagName);
    }

    public boolean isAcceptingPercentageColumnWidths(String tableCellsTagName) {
        return this.calsTableCellInfoProvider.isAcceptingPercentageColumnWidths(tableCellsTagName) || this.htmlTableCellInfoProvider.isAcceptingPercentageColumnWidths(tableCellsTagName);
    }

    public boolean isAcceptingProportionalColumnWidths(String tableCellsTagName) {
        return this.calsTableCellInfoProvider.isAcceptingProportionalColumnWidths(tableCellsTagName) || this.htmlTableCellInfoProvider.isAcceptingProportionalColumnWidths(tableCellsTagName);
    }

    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        List<WidthRepresentation> toReturn = this.htmlTableCellInfoProvider.getAllColspecWidthRepresentations();
        if (toReturn == null) {
            toReturn = this.calsTableCellInfoProvider.getAllColspecWidthRepresentations();
        }
        return toReturn;
    }

    public boolean isPreferPercentageColumnWidths(String tableCellsTagName) {
        return this.htmlTableCellInfoProvider.isPreferPercentageColumnWidths(tableCellsTagName);
    }
}

