/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorNodeUtil;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ToggleSurroundWithElementOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)ToggleSurroundWithElementOperation.class.getName());
    public static final String ARGUMENT_ELEMENT = "element";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("element", 1, "The element to surround with."), new ArgumentDescriptor("schemaAware", 3, "This argument applies only on the surround with element operation and controls if the insertion is schema aware or not. When schema aware is enabled and the element insertion is not allowed, a dialog will be shown proposing insertion solutions, like:\n - splitting an ancestor of the node at insertion offset and inserting the element between the resulted elements;\n - inserting the element somewhere in the proximity of the insertion offset (left or right without skipping content);\n - inserting the element at insertion offset, even it is not allowed.\n\nNote: if a selection exists the surround with element operation is not schema aware.\nPossible values are: true, false. Default value is true.", new String[]{"true", "false"}, "true")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object elementArg = args.getArgumentValue(ARGUMENT_ELEMENT);
        Object schemaAwareArgumentValue = args.getArgumentValue("schemaAware");
        if (elementArg != null && elementArg instanceof String && ((String)elementArg).length() > 0) {
            String fragment = (String)elementArg;
            AuthorElement wrapNode = this.getElementFromFragment(fragment, authorAccess);
            boolean schemaAware = !"false".equals(schemaAwareArgumentValue);
            authorAccess.getDocumentController().beginCompoundEdit();
            try {
                boolean insideWord;
                if (authorAccess.getEditorAccess().hasSelection()) {
                    this.performToggleSelection(authorAccess, fragment, wrapNode, schemaAware);
                }
                int[] wordAtCaret = authorAccess.getEditorAccess().getWordAtCaret();
                int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                AuthorElement elementAtCaret = this.getElementAtCaretOffset(authorAccess);
                AuthorElement elementMatchingRef = this.getElementMatchingReferenceElement(elementAtCaret, authorAccess, wrapNode, true);
                boolean bl = insideWord = wordAtCaret != null && wordAtCaret[0] != caretOffset && wordAtCaret[1] != caretOffset;
                if (elementMatchingRef != null) {
                    int newCaretOffset = 0;
                    if (insideWord) {
                        OffsetInformation info;
                        int[] newOffsets = this.unwrap(elementMatchingRef, wordAtCaret[0], wordAtCaret[1] - 1, authorAccess);
                        int startSentinelsCount = 0;
                        for (int currentOffset = newOffsets[0]; currentOffset < newOffsets[1] && (info = authorAccess.getDocumentController().getContentInformationAtOffset(currentOffset)).getPositionType() == 1; ++currentOffset) {
                            ++startSentinelsCount;
                        }
                        newCaretOffset = caretOffset + startSentinelsCount - (wordAtCaret[0] - newOffsets[0]);
                    } else {
                        newCaretOffset = this.unwrap(elementMatchingRef, caretOffset, caretOffset - 1, authorAccess)[0];
                    }
                    authorAccess.getEditorAccess().setCaretPosition(newCaretOffset);
                }
                if (insideWord) {
                    CommonsOperationsUtil.surroundWithFragment(authorAccess, fragment, wordAtCaret[0], wordAtCaret[1] - 1);
                    authorAccess.getEditorAccess().setCaretPosition(caretOffset + 1);
                }
                CommonsOperationsUtil.surroundWithFragment(authorAccess, schemaAware, fragment);
            }
            catch (AuthorOperationStoppedByUserException ex) {
                authorAccess.getDocumentController().cancelCompoundEdit();
            }
            catch (AuthorOperationException ex) {
                authorAccess.getDocumentController().cancelCompoundEdit();
                throw ex;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                authorAccess.getDocumentController().cancelCompoundEdit();
                throw new AuthorOperationException("The operation could not be executed.", (Throwable)e);
            }
            finally {
                authorAccess.getDocumentController().endCompoundEdit();
            }
        } else {
            throw new IllegalArgumentException("The value of the 'element' argument was not specified.");
        }
    }

    private List<int[]> getSelectedIntervals(AuthorAccess authorAccess) {
        AuthorSelectionModel authorSelectionModel = authorAccess.getEditorAccess().getAuthorSelectionModel();
        List selectionIntervals = authorSelectionModel.getSelectionIntervals();
        ArrayList<int[]> toProcessInterals = new ArrayList<int[]>(selectionIntervals.size());
        for (int i = 0; i < selectionIntervals.size(); ++i) {
            ContentInterval contentInterval = (ContentInterval)selectionIntervals.get(i);
            int[] balancedSelection = authorAccess.getEditorAccess().getBalancedSelection(contentInterval.getStartOffset(), contentInterval.getEndOffset());
            toProcessInterals.add(new int[]{balancedSelection[0], balancedSelection[1] - 1});
        }
        return toProcessInterals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performToggleSelection(AuthorAccess authorAccess, String fragment, AuthorElement wrapNode, boolean schemaAware) throws AuthorOperationException, BadLocationException {
        boolean caretAtStart = authorAccess.getEditorAccess().getCaretOffset() == authorAccess.getEditorAccess().getSelectionStart();
        ArrayList<IntervalAndAction> toProcess = new ArrayList<IntervalAndAction>();
        AuthorDocumentController ctrl = authorAccess.getDocumentController();
        AuthorDocumentFragment authorFragment = ctrl.createNewDocumentFragmentInContext(fragment, authorAccess.getEditorAccess().getCaretOffset());
        List<int[]> toProcessIntervals = this.getSelectedIntervals(authorAccess);
        Iterator<int[]> iterator = toProcessIntervals.iterator();
        while (iterator.hasNext()) {
            this.collectToggleIntervals(authorAccess, toProcess, ctrl, wrapNode, authorFragment, iterator.next(), true, schemaAware);
        }
        this.sortAscending(toProcess);
        IntervalAndAction prevIntervalAction = null;
        Iterator iterator2 = toProcess.iterator();
        while (iterator2.hasNext()) {
            IntervalAndAction intervalAndAction = (IntervalAndAction)iterator2.next();
            int[] contentInterval = intervalAndAction.interval;
            if (prevIntervalAction != null && prevIntervalAction.interval[1] + 1 == contentInterval[0] && prevIntervalAction.action == intervalAndAction.action) {
                prevIntervalAction.interval[1] = contentInterval[1];
                prevIntervalAction.entireIntervalWrapped = prevIntervalAction.entireIntervalWrapped && intervalAndAction.entireIntervalWrapped;
                iterator2.remove();
                continue;
            }
            prevIntervalAction = intervalAndAction;
        }
        if (!toProcess.isEmpty()) {
            boolean allWrapped = this.isAllWrapped(toProcess);
            AuthorNode toRefresh = null;
            authorAccess.getDocumentController().disableLayoutUpdate();
            try {
                int i;
                AuthorDocumentController documentController = authorAccess.getDocumentController();
                boolean mainSurround = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("All intervals are fully wrapped: " + allWrapped);
                }
                ArrayList<Position[]> toSurround = new ArrayList<Position[]>(toProcess.size());
                ArrayList<Integer> surround = new ArrayList<Integer>(toProcess.size());
                int size = toProcess.size();
                for (int i2 = toProcess.size() - 1; i2 >= 0; --i2) {
                    int[] part;
                    IntervalAndAction ia = (IntervalAndAction)toProcess.get(i2);
                    int[] affectedInterval = part = ia.interval;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Process interval: " + ia.action);
                        logger.debug("         Content: '" + ctrl.serializeFragmentToXML(ctrl.createDocumentFragment(part[0], part[1])) + "'");
                    }
                    int action = ia.action;
                    if (ia.action == 0) {
                        int startOffset = part[0];
                        int endOffset = part[1];
                        if (!ia.entireIntervalWrapped || allWrapped) {
                            UnwrapResult result = this.unwrapElementsMatchingReferenceElement(startOffset, endOffset, wrapNode, authorAccess);
                            mainSurround = mainSurround || result.performSurround;
                            affectedInterval = result.intervalToSurround;
                        } else {
                            action = 4;
                        }
                    } else {
                        mainSurround = true;
                    }
                    toSurround.add(new Position[]{documentController.createPositionInContent(affectedInterval[0]), documentController.createPositionInContent(affectedInterval[1])});
                    if (logger.isDebugEnabled()) {
                        logger.debug("Before " + part[0] + ", " + part[1] + " => " + affectedInterval[0] + ", " + affectedInterval[1]);
                    }
                    surround.add(action);
                }
                int offsetN = ((Position[])toSurround.get(0))[1].getOffset();
                int offset1 = ((Position[])toSurround.get(toProcess.size() - 1))[0].getOffset();
                toRefresh = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), offset1, offsetN);
                ArrayList<ContentInterval> toSelect = null;
                AuthorSelectionModel authorSelectionModel = authorAccess.getEditorAccess().getAuthorSelectionModel();
                if (mainSurround) {
                    size = toSurround.size();
                    if (size > 1) {
                        toSelect = new ArrayList(toSurround.size());
                    }
                    for (i = size - 1; i >= 0; --i) {
                        Position[] is = (Position[])toSurround.get(i);
                        Integer action = (Integer)surround.get(i);
                        if (action == 0) {
                            AuthorDocumentFragment newAuthorFragment = ctrl.createNewDocumentFragmentInContext(fragment, is[0].getOffset());
                            authorAccess.getDocumentController().surroundInFragment(newAuthorFragment, is[0].getOffset(), is[1].getOffset());
                        } else if (action == 2) {
                            authorAccess.getDocumentController().insertFragment(is[0].getOffset(), authorFragment);
                        }
                        if (toSelect == null) continue;
                        if (action == 4) {
                            toSelect.add(new ContentInterval(is[0].getOffset(), is[1].getOffset() + 1));
                            continue;
                        }
                        toSelect.add(authorSelectionModel.getSelectionInterval());
                    }
                } else {
                    toSelect = new ArrayList<ContentInterval>(toSurround.size());
                    for (i = toSurround.size() - 1; i >= 0; --i) {
                        Position[] positions = (Position[])toSurround.get(i);
                        int start = !caretAtStart ? positions[0].getOffset() : positions[1].getOffset() + 1;
                        int end = !caretAtStart ? positions[1].getOffset() + 1 : positions[0].getOffset();
                        toSelect.add(new ContentInterval(start, end));
                    }
                }
                authorSelectionModel.setSelectionIntervals(toSelect, true);
            }
            catch (Throwable throwable) {
                authorAccess.getDocumentController().enableLayoutUpdate(toRefresh);
                throw throwable;
            }
            authorAccess.getDocumentController().enableLayoutUpdate(toRefresh);
        }
    }

    private boolean isAllWrapped(List<IntervalAndAction> toProcess) {
        boolean allWrapped = true;
        for (IntervalAndAction intervalAndAction : toProcess) {
            if (intervalAndAction.entireIntervalWrapped) continue;
            allWrapped = false;
            break;
        }
        return allWrapped;
    }

    private void sortAscending(List<IntervalAndAction> toProcess) {
        Collections.sort(toProcess, new Comparator<IntervalAndAction>(){

            @Override
            public int compare(IntervalAndAction o1, IntervalAndAction o2) {
                return o1.interval[0] - o2.interval[0];
            }
        });
    }

    private void collectToggleIntervals(AuthorAccess authorAccess, List<IntervalAndAction> collectedIntervals, AuthorDocumentController ctrl, AuthorElement wrapNode, AuthorDocumentFragment authorFragment, int[] balancedInterval, boolean raw, boolean schemaAware) throws BadLocationException {
        block20: {
            block22: {
                block23: {
                    AuthorSchemaManager authorSchemaManager;
                    block21: {
                        block19: {
                            IntervalAndAction wrapAction = new IntervalAndAction(balancedInterval, 0);
                            if (schemaAware) {
                                wrapAction = this.canToggleSchemaAware(authorAccess, balancedInterval[0], balancedInterval[1], wrapNode, authorFragment);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("Tested '" + ctrl.serializeFragmentToXML(ctrl.createDocumentFragment(balancedInterval[0], balancedInterval[1])) + "' - action: " + wrapAction);
                            }
                            if (wrapAction.action == 3) break block19;
                            collectedIntervals.add(wrapAction);
                            break block20;
                        }
                        if (!raw) break block21;
                        List<int[]> balancedIntervals = ToggleSurroundWithElementOperation.getEquiIntervalFromMarker(authorAccess, balancedInterval);
                        for (int[] is : balancedIntervals) {
                            this.collectToggleIntervals(authorAccess, collectedIntervals, ctrl, wrapNode, authorFragment, is, false, schemaAware);
                        }
                        break block20;
                    }
                    AuthorNode fullySelectedNode = authorAccess.getEditorAccess().getFullySelectedNode(balancedInterval[0], balancedInterval[1] + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Go deep |" + ctrl.serializeFragmentToXML(ctrl.createDocumentFragment(balancedInterval[0], balancedInterval[1])) + "| fully " + (fullySelectedNode != null));
                    }
                    if (fullySelectedNode == null) break block22;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Fully selected node " + fullySelectedNode);
                    }
                    if (balancedInterval[0] + 1 != balancedInterval[1]) break block23;
                    boolean add = true;
                    if (schemaAware && (authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager()) != null && !authorSchemaManager.hasLoadingErrors() && !authorSchemaManager.isLearnSchema()) {
                        add = authorSchemaManager.canInsertDocumentFragment(authorFragment, balancedInterval[0] + 1, (short)1);
                    }
                    if (!add) break block20;
                    collectedIntervals.add(new IntervalAndAction(new int[]{balancedInterval[0] + 1, balancedInterval[1]}, 2));
                    break block20;
                }
                this.collectToggleIntervals(authorAccess, collectedIntervals, ctrl, wrapNode, authorFragment, new int[]{balancedInterval[0] + 1, balancedInterval[1] - 1}, false, schemaAware);
                break block20;
            }
            AuthorNode commonParentNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), balancedInterval[0], balancedInterval[1]);
            if (logger.isDebugEnabled()) {
                logger.debug("Common " + commonParentNode);
            }
            if (commonParentNode instanceof AuthorParentNode) {
                List contentNodes = ((AuthorParentNode)commonParentNode).getContentNodes();
                ArrayList<int[]> split = new ArrayList<int[]>();
                int start = balancedInterval[0];
                int end = balancedInterval[1];
                if (logger.isDebugEnabled()) {
                    logger.debug("Interval " + start + ", " + end);
                }
                for (AuthorNode authorNode : contentNodes) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Child " + authorNode);
                    }
                    if (authorNode.getStartOffset() >= start && authorNode.getEndOffset() <= end) {
                        if (start < authorNode.getStartOffset()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Add interval " + start + ",  " + (authorNode.getStartOffset() - 1));
                            }
                            split.add(new int[]{start, authorNode.getStartOffset() - 1});
                        }
                        split.add(new int[]{authorNode.getStartOffset(), authorNode.getEndOffset()});
                        if (logger.isDebugEnabled()) {
                            logger.debug("Addd interval" + authorNode.getStartOffset() + ", " + authorNode.getEndOffset());
                        }
                        start = authorNode.getEndOffset() + 1;
                        continue;
                    }
                    if (authorNode.getStartOffset() <= end) continue;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("At end " + start + ", " + end);
                }
                if (start <= end) {
                    split.add(new int[]{start, end});
                }
                if (split.size() > 1) {
                    for (int i = 0; i < split.size(); ++i) {
                        this.collectToggleIntervals(authorAccess, collectedIntervals, ctrl, wrapNode, authorFragment, (int[])split.get(i), false, schemaAware);
                    }
                }
            }
        }
    }

    private int[] extendSelectionOverSentinels(int startOffset, int endOffset, int maxStartOffset, int maxEndOffset, AuthorAccess authorAccess) throws BadLocationException {
        AuthorNode commonParentNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), startOffset, endOffset);
        if (commonParentNode != null) {
            boolean extended = false;
            if (commonParentNode.getStartOffset() == startOffset - 1 && startOffset - 1 >= maxStartOffset) {
                --startOffset;
                extended = true;
            }
            if (commonParentNode.getEndOffset() == endOffset + 1 && endOffset + 1 <= maxEndOffset) {
                ++endOffset;
                extended = true;
            }
            if (extended) {
                return this.extendSelectionOverSentinels(startOffset, endOffset, maxStartOffset, maxEndOffset, authorAccess);
            }
        }
        return new int[]{startOffset, endOffset};
    }

    private AuthorElement getElementAtCaretOffset(AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode node = null;
        try {
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
            throw new AuthorOperationException("Cannot identify the current element", (Throwable)e);
        }
        for (node = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); node != null && !(node instanceof AuthorElement); node = node.getParent()) {
        }
        if (!(node instanceof AuthorElement)) {
            throw new AuthorOperationException("The carret is not inside an element.");
        }
        AuthorElement targetElement = (AuthorElement)node;
        return targetElement;
    }

    private AuthorElement getElementMatchingReferenceElement(AuthorElement element, AuthorAccess authorAccess, AuthorElement referenceElement, boolean topElement) {
        AuthorNode parent;
        AuthorElement matchingElement = null;
        if (this.elementMatchesReferenceElement(element, referenceElement)) {
            matchingElement = element;
        }
        AuthorElement root = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        while ((matchingElement == null || topElement) && (parent = element.getParent()) instanceof AuthorElement && parent != root) {
            element = (AuthorElement)parent;
            if (!this.elementMatchesReferenceElement(element, referenceElement)) continue;
            matchingElement = element;
        }
        return matchingElement;
    }

    private boolean elementMatchesReferenceElement(AuthorElement element, AuthorElement referenceElement) {
        boolean match = true;
        if (element.getName().equals(referenceElement.getName())) {
            if (element.getNamespace().equals(referenceElement.getNamespace())) {
                int attributesCount = referenceElement.getAttributesCount();
                for (int i = 0; i < attributesCount; ++i) {
                    String attrName = referenceElement.getAttributeAtIndex(i);
                    if (attrName.startsWith("xmlns")) continue;
                    AttrValue elemAttr = element.getAttribute(attrName);
                    AttrValue refElemAttr = referenceElement.getAttribute(attrName);
                    if (elemAttr != null && refElemAttr.getValue().equals(elemAttr.getValue())) continue;
                    match = false;
                    break;
                }
            } else {
                match = false;
            }
        } else {
            match = false;
        }
        return match;
    }

    private AuthorElement getElementFromFragment(String fragment, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorElement element = null;
        AuthorDocumentFragment authorFragment = authorAccess.getDocumentController().createNewDocumentFragmentInContext(fragment, authorAccess.getEditorAccess().getCaretOffset());
        List contentNodes = authorFragment.getContentNodes();
        if (contentNodes.size() != 1 || authorFragment.containsSimpleText()) {
            throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
        }
        AuthorNode authorNode = (AuthorNode)contentNodes.get(0);
        if (authorNode instanceof AuthorElement) {
            if (((AuthorElement)authorNode).getContentNodes().size() > 0) {
                throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
            }
        } else {
            throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
        }
        element = (AuthorElement)authorNode;
        return element;
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Toggle \"surround with element\" operation.\n If there is no selection in the document and the caret is inside a word,\nthe word is wrapped in the given element (or unwrapped if it is already\nincluded in the element), else the fragment is inserted at caret position.\n If there is a selection in the document, it is wrapped in the given element\n(or unwrapped if it is already included in the element).\n";
    }

    private int[] unwrap(AuthorElement element, int start, int end, AuthorAccess authorAccess) {
        try {
            boolean split = start > end;
            AuthorDocumentController controller = authorAccess.getDocumentController();
            int elemStart = element.getStartOffset();
            int elemEnd = element.getEndOffset();
            int[] updatedOffsets = this.extendSelectionOverSentinels(start, end, element.getStartOffset(), element.getEndOffset(), authorAccess);
            start = updatedOffsets[0];
            end = updatedOffsets[1];
            if (start > elemStart && end < elemEnd) {
                AuthorDocumentFragment endFragment = controller.createDocumentFragment(end + 1, elemEnd);
                controller.delete(end + 1, elemEnd);
                AuthorNode node = controller.getNodeAtOffset(elemStart + 1);
                int insertOffset = node.getEndOffset() + 1;
                controller.insertFragment(insertOffset, endFragment);
                int sentinelsNumber = 0;
                int interval = start < end ? end - start + 1 : 0;
                AuthorDocumentFragment fragment = null;
                if (start <= node.getEndOffset() - 1) {
                    fragment = controller.createDocumentFragment(start, node.getEndOffset() - 1);
                    sentinelsNumber = (fragment.getLength() - interval) / 2;
                    controller.delete(start, node.getEndOffset() - 1);
                    node = controller.getNodeAtOffset(elemStart + 1);
                    insertOffset = node.getEndOffset() + 1;
                    controller.insertFragment(insertOffset, fragment);
                }
                start = insertOffset + sentinelsNumber;
                end = start + interval - 1;
            } else if (elemStart >= start && end >= elemEnd - 1) {
                if (elemStart == elemEnd - 1) {
                    controller.deleteNode((AuthorNode)element);
                } else {
                    AuthorDocumentFragment fragment = controller.createDocumentFragment(elemStart + 1, elemEnd - 1);
                    controller.delete(elemStart, elemEnd);
                    controller.insertFragment(elemStart, fragment);
                }
                if (start > elemStart) {
                    --start;
                }
                if (end != elemEnd - 1) {
                    end -= 2;
                }
            } else if (elemStart < start) {
                if (start < elemEnd) {
                    AuthorDocumentFragment fragment = controller.createDocumentFragment(start, elemEnd - 1);
                    controller.delete(start, elemEnd - 1);
                    AuthorNode node = controller.getNodeAtOffset(elemStart + 1);
                    int insertOffset = node.getEndOffset() + 1;
                    controller.insertFragment(insertOffset, fragment);
                    if (split) {
                        end = start = insertOffset + fragment.getLength() / 2;
                    } else {
                        start = insertOffset;
                        end = insertOffset + fragment.getLength() + end - (elemEnd + 1);
                    }
                }
            } else if (end > elemStart) {
                AuthorDocumentFragment fragment = controller.createDocumentFragment(elemStart + 1, end);
                controller.delete(elemStart + 1, end);
                controller.insertFragment(elemStart, fragment);
                end = split ? (start = elemStart + fragment.getLength() / 2) : elemStart + fragment.getLength() - 1;
            } else {
                --end;
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return new int[]{++start, --end};
    }

    private UnwrapResult unwrapElementsMatchingReferenceElement(int start, int end, AuthorElement referenceElement, AuthorAccess authorAccess) throws AuthorOperationException {
        boolean unwrappedContent = false;
        int[] processedInterval = new int[]{start, end};
        try {
            AuthorElement splitElement;
            AuthorDocumentController controller = authorAccess.getDocumentController();
            Segment content = new Segment();
            controller.getChars(start, end - start + 1, content);
            char ch = content.first();
            int currentOffset = start;
            AuthorElement startElement = null;
            AuthorElement endElement = null;
            boolean unwrapStart = false;
            boolean unwrapEnd = false;
            boolean[] mask = new boolean[end - start + 1];
            while (ch != '\uffff') {
                if (ch == '\u0000') {
                    OffsetInformation info = controller.getContentInformationAtOffset(currentOffset);
                    AuthorNode node = info.getNodeForMarkerOffset();
                    if (node instanceof AuthorElement) {
                        int nodeStart = node.getStartOffset();
                        int nodeEnd = node.getEndOffset();
                        if (this.elementMatchesReferenceElement((AuthorElement)node, referenceElement)) {
                            int intervalStart = Math.max(start, nodeStart);
                            int intervalEnd = Math.min(end, nodeEnd);
                            for (int i = intervalStart - start; i <= intervalEnd - start; ++i) {
                                mask[i] = true;
                            }
                            if (info.getPositionType() == 1) {
                                if (end < nodeEnd) {
                                    endElement = (AuthorElement)node;
                                    break;
                                }
                            } else if (info.getPositionType() == 2 && start > nodeStart) {
                                startElement = (AuthorElement)node;
                                unwrapStart = false;
                            }
                        } else {
                            mask[currentOffset - start] = true;
                            if (info.getPositionType() == 1) {
                                if (end < nodeEnd) {
                                    unwrapEnd = true;
                                }
                            } else if (info.getPositionType() == 2 && start > nodeStart) {
                                unwrapStart = true;
                            }
                        }
                    }
                } else if (Character.isWhitespace(ch)) {
                    mask[currentOffset - start] = true;
                }
                ch = content.next();
                ++currentOffset;
            }
            for (int i = 0; i < mask.length; ++i) {
                if (mask[i]) continue;
                unwrappedContent = true;
                break;
            }
            AuthorNode intervalParentElement = null;
            if (!unwrappedContent || unwrapStart || unwrapEnd) {
                int[] updatedOffsets;
                if (endElement != null) {
                    updatedOffsets = this.unwrap(endElement, start, end, authorAccess);
                    start = updatedOffsets[0];
                    end = updatedOffsets[1];
                }
                if (startElement != null) {
                    updatedOffsets = this.unwrap(startElement, start, end, authorAccess);
                    start = updatedOffsets[0];
                    end = updatedOffsets[1];
                }
            } else if (startElement != null) {
                int startOffset = startElement.getEndOffset() + 1;
                int endOffset = endElement != null ? endElement.getStartOffset() - 1 : end;
                AuthorDocumentFragment fragment = controller.createDocumentFragment(startOffset, endOffset);
                AuthorDocumentFragment endFragment = null;
                int delta = 0;
                if (endElement != null) {
                    delta = endElement.getEndOffset() - end;
                    endFragment = controller.createDocumentFragment(endElement.getStartOffset() + 1, endElement.getEndOffset() - 1);
                    controller.deleteNode((AuthorNode)endElement);
                }
                controller.delete(startOffset, endOffset);
                int insertOffset = startElement.getEndOffset();
                if (endElement != null) {
                    controller.insertFragment(insertOffset, endFragment);
                }
                controller.insertFragment(insertOffset, fragment);
                AuthorNode node = controller.getNodeAtOffset(insertOffset);
                end = node.getEndOffset() - delta;
                intervalParentElement = node;
                unwrappedContent = false;
            } else if (endElement != null) {
                AuthorDocumentFragment fragment = controller.createDocumentFragment(start, endElement.getStartOffset() - 1);
                int delta = endElement.getEndOffset() - end;
                controller.delete(start, endElement.getStartOffset() - 1);
                int insertOffset = endElement.getStartOffset() + 1;
                controller.insertFragment(insertOffset, fragment);
                AuthorNode node = controller.getNodeAtOffset(insertOffset);
                end = node.getEndOffset() - delta;
                intervalParentElement = node;
                unwrappedContent = false;
            }
            content = new Segment();
            controller.getChars(start, end - start + 1, content);
            currentOffset = start;
            ch = content.first();
            ArrayList<Integer> startOffsetsToUnwrap = new ArrayList<Integer>();
            while (ch != '\uffff') {
                OffsetInformation info;
                AuthorNode node;
                if (ch == '\u0000' && (node = (info = controller.getContentInformationAtOffset(currentOffset)).getNodeForMarkerOffset()) instanceof AuthorElement && this.elementMatchesReferenceElement((AuthorElement)node, referenceElement)) {
                    int nodeStart = node.getStartOffset();
                    int nodeEnd = node.getEndOffset();
                    if (info.getPositionType() == 1 && end >= nodeEnd) {
                        startOffsetsToUnwrap.add(0, nodeStart);
                    }
                }
                ch = content.next();
                ++currentOffset;
            }
            for (Integer offset : startOffsetsToUnwrap) {
                AuthorNode node = controller.getNodeAtOffset(offset + 1);
                int[] updatedOffsets = this.unwrap((AuthorElement)node, start, end, authorAccess);
                start = updatedOffsets[0];
                end = updatedOffsets[1];
            }
            processedInterval = new int[]{start, end};
            AuthorNode commonParentNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), start, end);
            if (commonParentNode instanceof AuthorElement && (splitElement = this.getElementMatchingReferenceElement((AuthorElement)commonParentNode, authorAccess, referenceElement, true)) != null && splitElement != intervalParentElement) {
                int[] newOffsets = this.unwrap(splitElement, start, end, authorAccess);
                processedInterval = new int[]{newOffsets[0], newOffsets[1]};
                unwrappedContent = false;
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("The operation could not be executed.", (Throwable)e);
        }
        return new UnwrapResult(unwrappedContent, processedInterval);
    }

    private IntervalAndAction canToggleSchemaAware(AuthorAccess authorAccess, int start, int end, AuthorElement wrapNode, AuthorDocumentFragment surroundFragment) throws BadLocationException {
        int action = 0;
        boolean fullyWrapped = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (authorSchemaManager != null && !authorSchemaManager.hasLoadingErrors() && !authorSchemaManager.isLearnSchema()) {
            action = 3;
            AuthorNode commonParentNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), start, end);
            boolean canUnwrap = true;
            fullyWrapped = this.isFullyWrappedInterval(authorAccess, start, end, wrapNode);
            canUnwrap = fullyWrapped;
            if (!canUnwrap && commonParentNode instanceof AuthorElement) {
                canUnwrap = this.elementMatchesReferenceElement((AuthorElement)commonParentNode, wrapNode);
            }
            boolean canWrap = false;
            if (!canUnwrap) {
                canWrap = this.canWrap(authorAccess, surroundFragment, start, end, commonParentNode, (short)1);
            }
            if (canWrap || canUnwrap) {
                action = 0;
            }
        }
        return new IntervalAndAction(new int[]{start, end}, action, fullyWrapped);
    }

    private boolean isFullyWrappedInterval(AuthorAccess authorAccess, int start, int end, AuthorElement referenceElement) throws BadLocationException {
        boolean fullySelected;
        AuthorDocumentController controller = authorAccess.getDocumentController();
        Segment content = new Segment();
        controller.getChars(start, end - start + 1, content);
        char ch = content.first();
        int currentOffset = start;
        short[] mask = new short[end - start + 1];
        short notWrapped = 0;
        short wrapped = 1;
        int neutral = 2;
        while (ch != '\uffff') {
            if (ch == '\u0000') {
                OffsetInformation info = controller.getContentInformationAtOffset(currentOffset);
                AuthorNode node = info.getNodeForMarkerOffset();
                if (node instanceof AuthorElement) {
                    int nodeStart = node.getStartOffset();
                    int nodeEnd = node.getEndOffset();
                    if (this.elementMatchesReferenceElement((AuthorElement)node, referenceElement)) {
                        int intervalStart = Math.max(start, nodeStart);
                        int intervalEnd = Math.min(end, nodeEnd);
                        for (int i = intervalStart - start; i <= intervalEnd - start; ++i) {
                            mask[i] = wrapped;
                        }
                        if (info.getPositionType() == 1 && end < nodeEnd) {
                            break;
                        }
                    } else {
                        mask[currentOffset - start] = neutral;
                    }
                }
            } else if (Character.isWhitespace(ch)) {
                mask[currentOffset - start] = neutral;
            }
            ch = content.next();
            ++currentOffset;
        }
        boolean unwrappedContent = false;
        boolean hasWrapped = false;
        if (logger.isDebugEnabled()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < mask.length; ++i) {
                b.append(mask[i]).append(",");
            }
            logger.debug("Mask: " + b.toString());
        }
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == notWrapped) {
                unwrappedContent = true;
                break;
            }
            if (mask[i] != wrapped) continue;
            hasWrapped = true;
        }
        boolean bl = fullySelected = !unwrappedContent && hasWrapped;
        if (!fullySelected) {
            AuthorNode commonParentNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), start, end);
            if (logger.isDebugEnabled()) {
                logger.debug("CommonParentNode " + commonParentNode);
            }
            if (commonParentNode instanceof AuthorElement) {
                AuthorElement toggleElement = this.getElementMatchingReferenceElement((AuthorElement)commonParentNode, authorAccess, referenceElement, true);
                if (logger.isDebugEnabled()) {
                    logger.debug("Ancestor toggle element: " + toggleElement);
                }
                fullySelected = toggleElement != null;
            }
        }
        return fullySelected;
    }

    private boolean canWrap(AuthorAccess authorAccess, AuthorDocumentFragment surroundInFragment, int start, int end, AuthorNode parentOfChange, short validationMode) throws BadLocationException {
        boolean canWrap = true;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (authorSchemaManager != null && !authorSchemaManager.hasLoadingErrors() && !authorSchemaManager.isLearnSchema() && (canWrap = authorSchemaManager.canInsertDocumentFragment(surroundInFragment, start, validationMode))) {
            WhatElementsCanGoHereContext whatElementsCanGoHereContext = null;
            whatElementsCanGoHereContext = parentOfChange instanceof AuthorElement ? authorSchemaManager.createWhatElementsCanGoHereContext(parentOfChange.getStartOffset() + 1) : new WhatElementsCanGoHereContext();
            AuthorElement[] elementsPath = ToggleSurroundWithElementOperation.getElementsPath(surroundInFragment);
            for (int i = 0; i < elementsPath.length; ++i) {
                this.pushContextElement(whatElementsCanGoHereContext, elementsPath[i].getName());
            }
            AuthorDocumentFragment authorFragment = authorAccess.getDocumentController().createDocumentFragment(start, end);
            canWrap = authorSchemaManager.canInsertDocumentFragments(new AuthorDocumentFragment[]{authorFragment}, whatElementsCanGoHereContext, validationMode);
        }
        return canWrap;
    }

    private void pushContextElement(WhatElementsCanGoHereContext context, String elementName) {
        ContextElement contextElement = new ContextElement();
        contextElement.setQName(elementName);
        context.pushContextElement(contextElement, null);
    }

    public static AuthorElement[] getElementsPath(AuthorDocumentFragment fragment) {
        LinkedList<AuthorElement> path = new LinkedList<AuthorElement>();
        for (AuthorNode firstLeaf = AuthorNodeUtil.getFirstLeaf((AuthorDocumentFragment)fragment); firstLeaf != null; firstLeaf = firstLeaf.getParent()) {
            if (!(firstLeaf instanceof AuthorElement)) continue;
            path.addFirst((AuthorElement)firstLeaf);
        }
        return path.toArray(new AuthorElement[0]);
    }

    public static List<int[]> getEquiIntervalFromMarker(AuthorAccess authorAccess, int[] interval) throws BadLocationException {
        AuthorNode endNode;
        ArrayList<int[]> toReturn = new ArrayList<int[]>(1);
        AuthorDocumentController ctrl = authorAccess.getDocumentController();
        int startOffset = interval[0];
        int endOffset = interval[1];
        AuthorNode startNode = ctrl.getNodeAtOffset(startOffset);
        if (startNode == (endNode = ctrl.getNodeAtOffset(endOffset + 1))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Same node:" + startNode);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SO:" + startOffset + " EO:" + endOffset);
            }
            toReturn.add(interval);
        } else {
            AuthorNode common = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), startOffset, endOffset);
            if (logger.isDebugEnabled()) {
                logger.debug("SO:" + startOffset + " EO:" + endOffset);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("startNode:" + startNode + " endNode: " + endNode);
            }
            while (common != startNode && startNode != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Split at start end:" + startNode.getEndOffset());
                }
                if (startOffset <= startNode.getEndOffset() - 1) {
                    toReturn.add(new int[]{startOffset, startNode.getEndOffset() - 1});
                }
                startOffset = startNode.getEndOffset() + 1;
                startNode = startNode.getParent();
            }
            int commonIndex = toReturn.size();
            while (common != endNode && endNode != null) {
                if (endNode.getStartOffset() + 1 <= endOffset) {
                    toReturn.add(commonIndex, new int[]{endNode.getStartOffset() + 1, endOffset});
                }
                endOffset = endNode.getStartOffset() - 1;
                endNode = endNode.getParent();
            }
            if (startOffset <= endOffset) {
                toReturn.add(commonIndex, new int[]{startOffset, endOffset});
            }
        }
        return toReturn;
    }

    private static class IntervalAndAction {
        private static final int ACTION_SURROUND = 0;
        private static final int ACTION_INSERT = 2;
        private static final int ACTION_INVALID = 3;
        private static final int ACTION_SKIP = 4;
        int[] interval;
        int action = 0;
        private boolean entireIntervalWrapped;

        public IntervalAndAction(int[] interval, int action) {
            this.interval = interval;
            this.action = action;
        }

        public IntervalAndAction(int[] is, int action, boolean fullyWrapped) {
            this.interval = is;
            this.action = action;
            this.entireIntervalWrapped = fullyWrapped;
        }

        public String toString() {
            return "[" + this.interval[0] + ", " + this.interval[1] + "], action: " + this.action + ", fullyWrapped: " + this.entireIntervalWrapped;
        }
    }

    private static class UnwrapResult {
        boolean performSurround;
        int[] intervalToSurround;

        public UnwrapResult(boolean performSurround, int[] intervalToSurround) {
            this.performSurround = performSurround;
            this.intervalToSurround = intervalToSurround;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            if (this.intervalToSurround != null) {
                builder.append(this.intervalToSurround[0] + ", " + this.intervalToSurround[1]);
            }
            builder.append("] perform surround ").append(this.performSurround);
            return builder.toString();
        }
    }
}

