/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ReplaceElementContentOperation
implements AuthorOperation {
    public static final String ARGUMENT_FRAGMENT = "fragment";
    static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("elementLocation", 2, "An XPath expression indicating the element whose attribute will be changed.\nNote: If it is not defined then the element at the caret position or the current fully selected element will be used."), new ArgumentDescriptor("fragment", 1, "The new content of the element.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        try {
            boolean delete;
            AuthorNode node = ReplaceElementContentOperation.getNodeToReplaceContent(authorAccess, args);
            int startContentOffset = node.getStartOffset() + 1;
            int endContentOffset = node.getEndOffset() - 1;
            AuthorDocumentController documentController = authorAccess.getDocumentController();
            if (startContentOffset <= endContentOffset && !(delete = documentController.delete(startContentOffset, endContentOffset))) {
                throw new AuthorOperationException("Could not delete old content node.");
            }
            String fragment = ReplaceElementContentOperation.getFragmentToInsert(args);
            if (fragment.length() > 0) {
                AuthorDocumentFragment documentFragment = documentController.createNewDocumentFragmentInContext(fragment, startContentOffset);
                documentController.insertFragment(startContentOffset, documentFragment);
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("Could not determine the node for which to replace the content.", (Throwable)e);
        }
    }

    private static String getFragmentToInsert(ArgumentsMap args) {
        String fragment = null;
        Object fragmentArgument = args.getArgumentValue(ARGUMENT_FRAGMENT);
        if (fragmentArgument == null) {
            fragment = "";
        } else if (fragmentArgument instanceof String) {
            fragment = (String)fragmentArgument;
        } else {
            throw new IllegalArgumentException("Incorrect fragment argument: " + fragmentArgument);
        }
        return fragment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AuthorNode getNodeToReplaceContent(AuthorAccess authorAccess, ArgumentsMap args) throws BadLocationException, AuthorOperationException {
        AuthorNode node = null;
        Object xpathLocation = args.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        if (xpathLocation instanceof String && !((String)xpathLocation).isEmpty()) {
            AuthorNode[] results = authorAccess.getDocumentController().findNodesByXPath((String)xpathLocation, true, true, true);
            if (results.length <= 0) throw new AuthorOperationException("The element XPath location does not identify an element: " + xpathLocation);
            if (!(results[0] instanceof AuthorElement)) throw new AuthorOperationException("The element XPath location does not identify an element: " + xpathLocation);
            return results[0];
        }
        node = authorAccess.getEditorAccess().getFullySelectedNode();
        if (node != null) return node;
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        return authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Replaces the content of the fully selected element or the content of the element at caret (if the selection is empty or a node is not entirely selected)";
    }
}

