/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ChangePseudoClassesOperation
implements AuthorOperation {
    private static final String ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS = "setLocations";
    private static final String ARGUMENT_SET_PSEUDOCLASS_NAMES = "setPseudoClassNames";
    private static final String ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS = "removeLocations";
    private static final String ARGUMENT_REMOVE_PSEUDOCLASS_NAMES = "removePseudoClassNames";
    private static final String ARGUMENT_INCLUDE_ALL_NODES = "includeAllNodes";
    private static final String YES = "yes";
    private static final String NO = "no";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[5];

    public ChangePseudoClassesOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS, 2, "An XPath expression indicating a list of nodes on which the specified list of pseudo classes will be set.\nNote: If it is not defined, then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SET_PSEUDOCLASS_NAMES, 0, "A space-separated list of pseudo class names which will be set on the matched nodes.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS, 2, "An XPath expression indicating a list of nodes from which the specified list of pseudo classes will be removed.\nNote: If it is not defined, then the element at the caret position will be used.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_REMOVE_PSEUDOCLASS_NAMES, 0, "A space-separated list of pseudo class names which will be removed from the matched nodes.");
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_INCLUDE_ALL_NODES, 3, "The value should be \"yes\" in order to include comments, text and CDATA nodes in the XPath execution, \"no\" to ignore them.", new String[]{YES, NO}, NO);
    }

    public String getDescription() {
        return "Sets a set of pseudo classes to all nodes identified by an XPath expression.\nRemoves a set of pseudo classes from all nodes identified by an XPath expression.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        ChangePseudoClassesOperation.setOrRemovePseudoClasses(authorAccess, args, ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS, ARGUMENT_SET_PSEUDOCLASS_NAMES, true);
        ChangePseudoClassesOperation.setOrRemovePseudoClasses(authorAccess, args, ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS, ARGUMENT_REMOVE_PSEUDOCLASS_NAMES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOrRemovePseudoClasses(AuthorAccess authorAccess, ArgumentsMap args, String xpathLocationKey, String pseudoClassNamesKey, boolean setClasses) throws AuthorOperationException {
        String[] splitPseudoClasses;
        Object xpathLocations = args.getArgumentValue(xpathLocationKey);
        Object pseudoClassNames = args.getArgumentValue(pseudoClassNamesKey);
        Object includeAllNodes = args.getArgumentValue(ARGUMENT_INCLUDE_ALL_NODES);
        if (pseudoClassNames instanceof String && (splitPseudoClasses = ((String)pseudoClassNames).split(" ")) != null && splitPseudoClasses.length > 0) {
            List<AuthorElement> targetElements = ChangePseudoClassesOperation.getTargetElements(authorAccess, xpathLocations, includeAllNodes);
            AuthorDocumentController documentController = authorAccess.getDocumentController();
            documentController.disableLayoutUpdate();
            try {
                for (AuthorElement targetElement : targetElements) {
                    for (String pseudoClass : splitPseudoClasses) {
                        if (setClasses) {
                            documentController.setPseudoClass(pseudoClass, targetElement);
                            continue;
                        }
                        documentController.removePseudoClass(pseudoClass, targetElement);
                    }
                }
            }
            finally {
                AuthorNode commonAncestor = documentController.getCommonAncestor(targetElements.toArray(new AuthorNode[0]));
                documentController.enableLayoutUpdate(commonAncestor);
            }
        }
    }

    private static List<AuthorElement> getTargetElements(AuthorAccess authorAccess, Object xpathLocations, Object includeAllNodes) throws AuthorOperationException {
        ArrayList<AuthorElement> targetElements = new ArrayList<AuthorElement>();
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        if (xpathLocations instanceof String && ((String)xpathLocations).trim().length() > 0) {
            if (includeAllNodes instanceof String) {
                boolean ignoreAllNodes = !includeAllNodes.equals(YES);
                AuthorNode[] results = documentController.findNodesByXPath((String)xpathLocations, ignoreAllNodes, ignoreAllNodes, ignoreAllNodes);
                for (int i = 0; i < results.length; ++i) {
                    AuthorNode authorNode = results[i];
                    if (authorNode.getType() != 0) continue;
                    targetElements.add((AuthorElement)authorNode);
                }
                if (targetElements.isEmpty()) {
                    throw new AuthorOperationException("The element XPath location does not identify an element: " + xpathLocations);
                }
            }
        } else {
            AuthorNode node = null;
            try {
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("Cannot identify the current element", (Throwable)e);
            }
            for (node = documentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); node != null && !(node instanceof AuthorElement); node = node.getParent()) {
            }
            if (node instanceof AuthorElement) {
                targetElements.add((AuthorElement)node);
            } else {
                throw new AuthorOperationException("You need to have the carret inside an element.");
            }
        }
        return targetElements;
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

