/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml;

import java.util.function.Consumer;
import org.apache.xerces.util.XMLChar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.BasicTextUtil;

public class XmlFilteringUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)XmlFilteringUtil.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence filterInvalidXMLChars(CharSequence toCheck, Consumer<String> errorListener) {
        int length;
        StringBuilder errors;
        StringBuilder filtered;
        block13: {
            filtered = null;
            errors = null;
            length = 0;
            if (toCheck == null) break block13;
            length = toCheck.length();
            for (int i = 0; i < length; ++i) {
                char ch;
                boolean checkingSurrogates;
                String problem;
                block15: {
                    block14: {
                        problem = null;
                        checkingSurrogates = false;
                        ch = toCheck.charAt(i);
                        if (!Character.isHighSurrogate(ch)) break block14;
                        if (++i < length) {
                            int cp;
                            checkingSurrogates = true;
                            char low = toCheck.charAt(i);
                            if (!Character.isSurrogatePair(ch, low)) {
                                problem = "The character with decimal code (" + low + ") " + (String)(length > 1 ? "at offset " + i : "") + "is an invalid surrogate character.";
                            }
                            if (!XMLChar.isValid((int)(cp = Character.toCodePoint(ch, low)))) {
                                problem = "The code point with decimal code (" + cp + ") " + (String)(length > 1 ? "at offset " + i : "") + "is an invalid XML character.";
                            }
                            break block15;
                        } else {
                            problem = "The character with decimal code (" + ch + ") " + (String)(length > 1 ? "at offset " + i : "") + "is an invalid XML character.";
                            break;
                        }
                    }
                    if (!XMLChar.isValid((int)ch)) {
                        problem = "The character with decimal code (" + ch + ") " + (String)(length > 1 ? "at offset " + i : "") + "is an invalid XML character.";
                    }
                }
                if (problem != null) {
                    if (errors == null) {
                        errors = new StringBuilder();
                    }
                    errors.append(problem).append("\n");
                    if (filtered != null) continue;
                    filtered = new StringBuilder(toCheck.subSequence(0, checkingSurrogates ? i - 1 : i));
                    continue;
                }
                if (filtered == null) continue;
                filtered.append(ch);
                if (!checkingSurrogates) continue;
                filtered.append(toCheck.charAt(i));
            }
        }
        if (errors != null) {
            Object message = errors.toString();
            if (length > 1 && toCheck != null) {
                message = (String)message + "\nOriginal content:\n\n" + BasicTextUtil.getSomeText(toCheck.toString(), 300);
            }
            if (errorListener != null) {
                errorListener.accept((String)message);
            } else {
                logger.error((String)message);
            }
        }
        if (filtered != null) {
            return filtered.toString();
        }
        return toCheck;
    }
}

