/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util.java;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.java.JavaVersionParser;

final class JavaVersionDetector {
    static boolean versionCachingEnabled = true;
    private static int[] versionCache;
    static boolean skipVersionAPI;
    private static boolean signalVersionAPIErrors;

    private JavaVersionDetector() {
        throw new IllegalStateException("Utility class instantiation is prohibited.");
    }

    static synchronized int[] getVersion() throws NumberFormatException {
        int[] version = null;
        if (versionCachingEnabled && versionCache != null) {
            return Arrays.copyOf(versionCache, versionCache.length);
        }
        if (skipVersionAPI) {
            version = JavaVersionParser.parse(System.getProperty("java.version"));
        } else {
            try {
                version = JavaVersionDetector.getVersionThroughAPI();
            }
            catch (Throwable t) {
                try {
                    version = JavaVersionParser.parse(System.getProperty("java.version"));
                }
                finally {
                    JavaVersionDetector.signalVersionAPIError(t, version);
                }
            }
        }
        if (versionCachingEnabled && version != null && version.length > 0) {
            versionCache = version;
        }
        return version;
    }

    private static void signalVersionAPIError(Throwable error, @Nullable int[] detectedVersion) {
        if (signalVersionAPIErrors) {
            if (detectedVersion == null || detectedVersion.length == 0 || detectedVersion[0] > 1) {
                System.err.println("Unable to use API to detect JRE version:");
                error.printStackTrace(System.err);
            }
            signalVersionAPIErrors = false;
        }
    }

    private static int[] getVersionThroughAPI() throws Throwable {
        if (skipVersionAPI) {
            throw new IllegalAccessException("Access to JRE version API not allowed ('skipVersionAPI' flag enabled).");
        }
        PrivilegedExceptionAction<int[]> runtimeAccessAction = new PrivilegedExceptionAction<int[]>(){

            private Object getAPIVersion() throws ReflectiveOperationException {
                Method runtimeClassVersionMethod = Runtime.class.getDeclaredMethod("version", new Class[0]);
                Object versionObj = runtimeClassVersionMethod.invoke(null, new Object[0]);
                Class<?> runtimeVersionClass = Class.forName("java.lang.Runtime$Version");
                Method versionObjVersionMethod = runtimeVersionClass.getDeclaredMethod("version", new Class[0]);
                return versionObjVersionMethod.invoke(versionObj, new Object[0]);
            }

            @Override
            public int[] run() throws Exception {
                Object jreVersion = this.getAPIVersion();
                if (jreVersion instanceof List) {
                    Object versionField;
                    List jreVersionList = (List)jreVersion;
                    int[] version = new int[4];
                    Iterator versionFieldsIterator = jreVersionList.iterator();
                    for (int i = 0; versionFieldsIterator.hasNext() && i < 4 && (versionField = versionFieldsIterator.next()) instanceof Integer; ++i) {
                        version[i] = (Integer)versionField;
                    }
                    if (version[0] > 0) {
                        return version;
                    }
                }
                throw new Exception("Cannot obtain version from JRE: " + jreVersion);
            }
        };
        try {
            return AccessController.doPrivileged(runtimeAccessAction, null, new RuntimePermission("accessDeclaredMembers"));
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            throw cause != null ? cause : e;
        }
    }

    static synchronized void reset() {
        versionCachingEnabled = true;
        versionCache = null;
        skipVersionAPI = false;
    }

    static {
        signalVersionAPIErrors = true;
    }
}

