/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;

public class ResourceUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)ResourceUtil.class.getName());

    public static void checkResourceExists(URL url, boolean useAuthenticationProvider) throws IOException {
        ResourceUtil.checkResourceExists(url, useAuthenticationProvider, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkResourceExists(URL url, boolean useAuthenticationProvider, int timeout) throws IOException {
        if ("file".equals(url.getProtocol())) {
            File file = URLUtil.getCanonicalFileFromFileUrl(url);
            if (!file.isFile()) {
                if (file.isDirectory()) {
                    throw new FileNotFoundException("Resource is a folder: " + file.getAbsolutePath());
                }
                throw new FileNotFoundException("File does not exist: " + file.getAbsolutePath());
            }
        } else {
            InputStream is = null;
            URLConnection openConnection = null;
            try {
                openConnection = url.openConnection();
                if (timeout != -1) {
                    openConnection.setConnectTimeout(timeout);
                }
                boolean useStream = true;
                if (openConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpCon = (HttpURLConnection)openConnection;
                    useStream = false;
                    try {
                        httpCon.setRequestMethod("HEAD");
                        int status = httpCon.getResponseCode();
                        if (status == 403 || status == 204 || status == 503 || status == 405 || status == -1) {
                            useStream = true;
                        } else if (status != 200) {
                            StringBuilder message = new StringBuilder();
                            message.append(status);
                            message.append(' ');
                            message.append(httpCon.getResponseMessage());
                            message.append(" for: ").append(URLUtil.clearUserInfo(url));
                            throw new IOException(message.toString());
                        }
                    }
                    finally {
                        httpCon.disconnect();
                    }
                }
                if (useStream) {
                    is = openConnection.getInputStream();
                    byte[] buffer = new byte[1];
                    is.read(buffer);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (openConnection != null) {
                    URLUtil.disconnect(openConnection);
                }
            }
        }
    }

    public static URL getDuplicateDestinationURL(URL sourceURL) throws MalformedURLException {
        URL toReturn = null;
        String[] pathAndFilename = URLUtil.extractPathAndFileName(sourceURL);
        if (pathAndFilename != null) {
            String path = pathAndFilename[0];
            String name = pathAndFilename[1];
            int index = name.lastIndexOf(46);
            String extension = "";
            if (index != -1) {
                extension = name.substring(index);
                name = name.substring(0, index);
            }
            Object newName = "";
            Object newURL = "";
            int count = 0;
            boolean exists = true;
            while (exists) {
                Object countStr = "";
                if (++count > 1) {
                    countStr = " (" + count + ")";
                }
                newName = name + " - Copy" + (String)countStr + extension;
                newURL = path + (String)newName;
                toReturn = new URL(URLUtil.correct(URLUtil.uncorrect((String)newURL), false));
                try {
                    exists = false;
                    ResourceUtil.checkResourceExists(toReturn, false);
                    exists = true;
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return toReturn;
    }
}

