/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml.transformer.xproc.calabash;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Step;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.type.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DPIDetailedExceptionUtil;
import ro.sync.document.DocumentPositionedInfo;

public final class XProcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)XProcUtils.class.getName());
    private static final QName CODE = new QName("code");

    private XProcUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static URL processErrorCode(QName errorCode) {
        String error;
        if (errorCode != null && ((error = errorCode.toString()).startsWith("XC") || error.startsWith("XD") || error.startsWith("XS") && !"XS0100".equals(error))) {
            try {
                return new URL("http://www.w3.org/TR/xproc/#err." + error.substring(1));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static DocumentPositionedInfo processException(Throwable t, XProcRuntime runtime, String pipelineURI, boolean asWarning) {
        Object e;
        LOGGER.debug(t.getMessage(), t);
        DPIInfo info = new DPIInfo();
        info.systemID = pipelineURI;
        boolean otherXProcException = false;
        while (t.getCause() != null) {
            if (t instanceof XProcException && !otherXProcException) {
                e = (XProcException)t;
                Step s = e.getStep();
                XProcUtils.addXProcExceptionMessage((XProcException)e, otherXProcException, runtime, info.message);
                if (s != null && s.xplFile() != null) {
                    info.systemID = s.xplFile();
                    info.line = s.xplLine();
                }
                otherXProcException = true;
            }
            t = t.getCause();
        }
        if (t instanceof XProcException) {
            e = (XProcException)t;
            XProcUtils.addXProcExceptionMessage((XProcException)e, otherXProcException, runtime, info.message);
            info.sourceLocator = e.getLocator();
            info.additionalInfoURL = XProcUtils.processErrorCode(e.getErrorCode());
        } else if (t instanceof TransformerException) {
            TransformerException tce = (TransformerException)t;
            info.sourceLocator = tce.getLocator();
            info.message.append(' ').append(tce.getMessage());
        } else if (t instanceof SaxonApiException) {
            SaxonApiException sae = (SaxonApiException)t;
            if (sae.getCause() instanceof TransformerException) {
                TransformerException tce = (TransformerException)sae.getCause();
                info.sourceLocator = tce.getLocator();
            }
            info.message.append(' ').append(t.getMessage());
        } else if (t instanceof ValidationException) {
            ValidationException vex = (ValidationException)t;
            info.message.append(' ').append(t.getMessage());
            info.sourceLocator = vex.getLocator();
        } else if (t instanceof SAXParseException) {
            e = (SAXParseException)t;
            info.message.append(' ').append(t.getMessage());
            info.line = ((SAXParseException)e).getLineNumber();
            info.column = ((SAXParseException)e).getColumnNumber();
            if (((SAXParseException)e).getSystemId() != null) {
                info.systemID = ((SAXParseException)e).getSystemId();
            }
        } else if (t instanceof ClassNotFoundException) {
            info.message.append("java.lang.ClassNotFoundException: ").append(t.getMessage());
        } else {
            info.message.append(' ').append(t.getMessage());
        }
        info.updateInfoBasedOnSourceLocator();
        DocumentPositionedInfo dpi = new DocumentPositionedInfo(asWarning ? 1 : 2, info.message.toString(), info.systemID, info.line, info.column);
        dpi.setAdditionalInfo(info.additionalInfoURL);
        dpi.setDetailedExceptionInfo(DPIDetailedExceptionUtil.getDetailedExceptionStackTrace((Throwable)t));
        return dpi;
    }

    private static void addXProcExceptionMessage(XProcException e, boolean bypassErrorCode, XProcRuntime runtime, StringBuilder msgBuffer) {
        if (bypassErrorCode || e.getErrorCode() == null) {
            msgBuffer.append(e.getMessage());
        } else {
            String error;
            msgBuffer.append(e.getErrorCode()).append(" : ");
            if (e.getMessage() != null) {
                msgBuffer.append(e.getMessage());
            }
            if ((error = XProcUtils.errorMessage(e.getErrorCode(), runtime)) != null) {
                msgBuffer.append(' ').append(error);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String errorMessage(QName code, XProcRuntime runtime) {
        try (InputStream instream = XProcUtils.class.getResourceAsStream("/etc/error-list.xml");){
            XdmNode error;
            if (instream == null) return null;
            DocumentBuilder builder = runtime.getProcessor().newDocumentBuilder();
            XdmNode doc = builder.build((Source)new SAXSource(new InputSource(instream)));
            XdmSequenceIterator iter = doc.axisIterator(Axis.DESCENDANT, new QName("", "http://www.w3.org/ns/xproc-error", "error"));
            do {
                if (!iter.hasNext()) return null;
                error = (XdmNode)iter.next();
            } while (!code.getLocalName().equals(error.getAttributeValue(CODE)));
            String string = error.getStringValue();
            return string;
        }
        catch (SaxonApiException sae) {
            LOGGER.debug(sae.getMessage(), (Throwable)sae);
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static List<DocumentPositionedInfo> processErrors(String messages, String pipelineURI) {
        ArrayList<DocumentPositionedInfo> errors = new ArrayList<DocumentPositionedInfo>();
        int index = messages.indexOf("Error near");
        while (index != -1) {
            int nextIndex = messages.indexOf("Error near", index + 1);
            int errorEnd = nextIndex == -1 ? messages.length() : nextIndex;
            String errorBody = messages.substring(index, errorEnd).trim();
            errors.add(XProcUtils.getError(errorBody, pipelineURI));
            index = nextIndex;
        }
        return errors.isEmpty() ? null : errors;
    }

    private static DocumentPositionedInfo getError(String errorBody, String pipelineURI) {
        DocumentPositionedInfo dpi = new DocumentPositionedInfo(2, errorBody, pipelineURI);
        int index = errorBody.indexOf(" on line ");
        if (index != -1) {
            int lineIndex = index + " on line ".length();
            int lineEnd = errorBody.indexOf(" ", lineIndex);
            if (lineEnd != -1) {
                int line = Integer.valueOf(errorBody.substring(lineIndex, lineEnd));
                dpi.setLine(line);
            }
            if ((index = errorBody.indexOf(" column ", lineIndex)) != -1) {
                int uriIndex;
                int uriEnd;
                int columnIndex = index + " column ".length();
                int columnEnd = errorBody.indexOf(" ", columnIndex);
                if (columnEnd != -1) {
                    int column = Integer.valueOf(errorBody.substring(columnIndex, columnEnd));
                    dpi.setColumn(column);
                }
                if ((index = errorBody.indexOf(" of ", columnIndex)) != -1 && (uriEnd = errorBody.indexOf(":", uriIndex = index + " of ".length())) != -1) {
                    String uri = errorBody.substring(uriIndex, uriEnd);
                    try {
                        dpi.setSystemID(URLUtil.correct((URL)new URL(new URL(pipelineURI), uri)).toExternalForm());
                    }
                    catch (MalformedURLException e) {
                        dpi.setSystemID(uri);
                    }
                }
            }
        }
        return dpi;
    }

    private static class DPIInfo {
        StringBuilder message = new StringBuilder();
        SourceLocator sourceLocator;
        String systemID;
        int line = -1;
        int column = -1;
        URL additionalInfoURL;

        private DPIInfo() {
        }

        void updateInfoBasedOnSourceLocator() {
            if (this.sourceLocator != null) {
                String locatorSysID = this.sourceLocator.getSystemId();
                if (locatorSysID != null) {
                    String originalSystemID = this.systemID;
                    this.systemID = locatorSysID;
                    if (!locatorSysID.contains(":")) {
                        locatorSysID = locatorSysID.replace('\\', '/');
                        File locatorFile = new File(locatorSysID);
                        for (locatorFile = locatorFile.getParentFile(); locatorFile != null; locatorFile = locatorFile.getParentFile()) {
                            String stepRelativePath = locatorFile.getPath();
                            if (!originalSystemID.contains(stepRelativePath)) continue;
                            this.systemID = originalSystemID.substring(0, originalSystemID.indexOf(stepRelativePath)) + locatorSysID;
                            break;
                        }
                    }
                }
                this.line = this.sourceLocator.getLineNumber();
                this.column = this.sourceLocator.getColumnNumber();
            }
        }
    }
}

