/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml.transformer.xproc.calabash;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.LogOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.document.DocumentPositionedInfoUtil;
import ro.sync.exml.editor.results.iterator.ResultItem;
import ro.sync.exml.editor.xmleditor.ErrorListException;
import ro.sync.xml.transformer.xproc.api.XProcInputPort;
import ro.sync.xml.transformer.xproc.api.XProcOption;
import ro.sync.xml.transformer.xproc.api.XProcOutputPort;
import ro.sync.xml.transformer.xproc.api.XProcParametersPort;
import ro.sync.xml.transformer.xproc.api.XProcSaxonConfigurationCustomizer;
import ro.sync.xml.transformer.xproc.api.XProcTransformerInterface;
import ro.sync.xml.transformer.xproc.calabash.XProcErrorListener;
import ro.sync.xml.transformer.xproc.calabash.XProcPipelineUtil;
import ro.sync.xml.transformer.xproc.calabash.XProcUtils;

public class XProcTransformerImpl
implements XProcTransformerInterface {
    protected String pipelineURI;
    private String uriResolverClass;
    private String entityResolverClass;
    private final Set<DocumentPositionedInfo> transformationMessages = new LinkedHashSet<DocumentPositionedInfo>();
    private String jarFolder;
    private XProcSaxonConfigurationCustomizer saxonConfigurationCustomizer;

    public XProcTransformerImpl() {
        URL classURL = this.getClass().getResource("/ro/sync/xml/transformer/xproc/calabash/XProcTransformerImpl.class");
        if (classURL != null) {
            String classURLString = classURL.toExternalForm();
            try {
                URL u = new URL(classURLString.substring("jar:".length(), classURLString.indexOf(33)));
                File f = URLUtil.getAbsoluteFileFromFileUrl((URL)u);
                if (f != null) {
                    this.jarFolder = f.getParent();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void setSaxonConfigurationCustomizer(XProcSaxonConfigurationCustomizer customizer) {
        this.saxonConfigurationCustomizer = customizer;
    }

    public List<DocumentPositionedInfo> validate() {
        if (this.pipelineURI == null) {
            return null;
        }
        final LinkedHashSet<DocumentPositionedInfo> dpis = new LinkedHashSet<DocumentPositionedInfo>();
        final XProcRuntime runtime = this.prepareRuntime(true, dpis);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    runtime.load(new Input(XProcTransformerImpl.this.pipelineURI));
                }
                catch (Exception t) {
                    if (dpis.isEmpty() && !(t instanceof XProcException)) {
                        dpis.add(XProcUtils.processException(t, runtime, XProcTransformerImpl.this.pipelineURI, false));
                    }
                }
                finally {
                    runtime.close();
                }
                return null;
            }
        });
        return new ArrayList<DocumentPositionedInfo>(dpis);
    }

    private XProcRuntime prepareRuntime(boolean forValidation, final Set<DocumentPositionedInfo> dpis) {
        final File saxonConfig = this.getSaxonConfigFile();
        final XProcConfiguration config = AccessController.doPrivileged(new PrivilegedAction<XProcConfiguration>(){

            @Override
            public XProcConfiguration run() {
                String saxonConfigProp = "com.xmlcalabash.saxon-configuration";
                if (saxonConfig != null) {
                    System.setProperty("com.xmlcalabash.saxon-configuration", saxonConfig.toString());
                } else {
                    System.getProperties().remove("com.xmlcalabash.saxon-configuration");
                }
                return saxonConfig != null ? new XProcConfiguration(new Input(saxonConfig.toURI().toASCIIString(), Input.Type.XML)) : new XProcConfiguration(true);
            }
        });
        boolean configured = this.loadCalabashConfigFile(config);
        if (forValidation) {
            config.logOpt = LogOptions.OFF;
        }
        if (!configured || config.uriResolver == null) {
            config.uriResolver = this.uriResolverClass;
        }
        if (!configured || config.entityResolver == null) {
            config.entityResolver = this.entityResolverClass;
        }
        return AccessController.doPrivileged(new PrivilegedAction<XProcRuntime>(){

            @Override
            public XProcRuntime run() {
                XProcRuntime runtime = new XProcRuntime(config);
                XProcErrorListener errListener = new XProcErrorListener(dpis, runtime, XProcTransformerImpl.this.pipelineURI);
                runtime.setMessageListener((XProcMessageListener)errListener);
                return runtime;
            }
        });
    }

    private boolean loadCalabashConfigFile(XProcConfiguration config) {
        boolean configured = false;
        File calabashConfig = this.getCalabashConfigFile();
        if (calabashConfig != null) {
            try {
                String cfgURI = URLUtil.correct((File)calabashConfig).toString();
                SAXSource source = new SAXSource(new InputSource(cfgURI));
                DocumentBuilder builder = config.getProcessor().newDocumentBuilder();
                XdmNode doc = builder.build((Source)source);
                config.parse(doc);
                configured = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return configured;
    }

    private File getCalabashConfigFile() {
        File f;
        if (this.jarFolder != null && (f = new File(this.jarFolder, "calabash.config")).exists()) {
            return f;
        }
        return null;
    }

    private File getSaxonConfigFile() {
        File f;
        File cfgFile = null;
        if (this.jarFolder != null && (f = new File(this.jarFolder, "saxon.config")).exists()) {
            cfgFile = f;
        }
        return cfgFile;
    }

    public Map<String, List<ResultItem>> transform(XProcInputPort[] inputPortsMapping, XProcOutputPort[] outputPortsMapping, XProcOption[] options, XProcParametersPort[] parameters) throws Exception {
        this.transformationMessages.clear();
        if (this.pipelineURI == null) {
            throw new IllegalArgumentException("Pipeline not specified.");
        }
        XProcRuntime runtime = this.prepareRuntime(false, this.transformationMessages);
        TreeMap<String, List<ResultItem>> portsAndResults = new TreeMap<String, List<ResultItem>>();
        boolean throwList = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XPipeline pipeline = runtime.load(new Input(this.pipelineURI, Input.Type.XML));
            Configuration saxonConfiguration = runtime.getConfiguration().getProcessor().getUnderlyingConfiguration();
            saxonConfiguration.setStandardErrorOutput(new PrintStream(baos));
            if (this.saxonConfigurationCustomizer != null) {
                this.saxonConfigurationCustomizer.customizeSaxonConfiguration(saxonConfiguration);
            }
            if (!DocumentPositionedInfoUtil.hasErrorsOrHigher(new ArrayList<DocumentPositionedInfo>(this.transformationMessages))) {
                Set initialInputPorts = pipeline.getInputs();
                XProcPipelineUtil.setPortParametersToPipeline(parameters, pipeline);
                XProcPipelineUtil.setOptionsToPipeline(options, pipeline);
                XProcPipelineUtil.setInputPortsMappingToPipeline(inputPortsMapping, pipeline, initialInputPorts, runtime);
                pipeline.run();
                Set<String> outputNames = XProcPipelineUtil.setOutputPortsMappingToPipeline(outputPortsMapping, pipeline, runtime, portsAndResults);
                XProcPipelineUtil.defaultProcessOutputPorts(outputNames, pipeline, runtime, portsAndResults);
            } else {
                throwList = true;
            }
        }
        catch (Exception t) {
            String messages;
            if (baos.size() > 0 && (messages = baos.toString()).contains("Error near")) {
                this.transformationMessages.addAll(XProcUtils.processErrors(messages, this.pipelineURI));
            }
            DocumentPositionedInfo dpi = XProcUtils.processException(t, runtime, this.pipelineURI, false);
            this.transformationMessages.add(dpi);
            throw new ErrorListException(new ArrayList<DocumentPositionedInfo>(this.transformationMessages), null, (Throwable)t);
        }
        finally {
            runtime.close();
            if (baos.size() > 0) {
                System.err.println(baos.toString());
            }
        }
        if (throwList) {
            throw new ErrorListException(new ArrayList<DocumentPositionedInfo>(this.transformationMessages));
        }
        return portsAndResults;
    }

    public List<DocumentPositionedInfo> getLastTransformationMessages() {
        return new ArrayList<DocumentPositionedInfo>(this.transformationMessages);
    }

    public void initialize(String pipelineURI, String uriResolverClassName, String entityResolverClassName) {
        this.pipelineURI = pipelineURI;
        this.uriResolverClass = uriResolverClassName;
        this.entityResolverClass = entityResolverClassName;
    }

    public boolean supportsValidation() {
        return true;
    }
}

