/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.PropertySelectionController;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class SAPropertyPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SAPropertyPanel.class.getName());
    private TableProperty tableProperty;
    private final List<JComponent> valuesComponent = new ArrayList<JComponent>();
    private String currentlySelectedValue;

    public SAPropertyPanel(JPanel parentContainer, GridBagConstraints constr, TableProperty tableProperty, AuthorResourceBundle authorResourceBundle, final PropertySelectionController controller, int firstChildTopInset, boolean firstChild) {
        Object propertyLabelName;
        this.tableProperty = tableProperty;
        this.currentlySelectedValue = tableProperty.getCurrentValue();
        String propertyName = tableProperty.getAttributeName();
        String propertyRenderString = tableProperty.getAttributeRenderString();
        GuiElements guiElement = tableProperty.getGuiType();
        List<String> values = tableProperty.getValues();
        constr.gridx = 0;
        constr.insets = new Insets(1, 5, 1, 1);
        constr.gridy = firstChild ? 0 : ++constr.gridy;
        constr.gridwidth = 1;
        Object object = propertyLabelName = propertyRenderString != null ? authorResourceBundle.getMessage(propertyRenderString) : propertyName;
        if (GuiElements.COMBOBOX == guiElement) {
            constr.fill = 0;
            constr.anchor = 17;
            constr.weightx = 0.0;
            propertyLabelName = (String)propertyLabelName + ":";
            JLabel nameLabel = new JLabel((String)propertyLabelName);
            parentContainer.add((Component)nameLabel, constr);
            ++constr.gridx;
            constr.fill = 2;
            constr.weightx = 1.0;
            JComboBox comboBox = new JComboBox(values.toArray(new String[0])){

                @Override
                public void setSelectedItem(Object anObject) {
                    String oldSel = (String)this.dataModel.getSelectedItem();
                    super.setSelectedItem(anObject);
                    if (oldSel.equals(anObject)) {
                        this.selectedItemChanged();
                    }
                }
            };
            nameLabel.setLabelFor(comboBox);
            final ListCellRenderer defaultComboRenderer = comboBox.getRenderer();
            comboBox.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel listCellRendererComponent = (JLabel)defaultComboRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if ("<preserve>".equals(value) || "<not set>".equals(value)) {
                        Font font = listCellRendererComponent.getFont();
                        Font derivedFont = font.deriveFont(2);
                        listCellRendererComponent.setFont(derivedFont);
                    }
                    return listCellRendererComponent;
                }
            });
            comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        SAPropertyPanel.this.currentlySelectedValue = (String)e.getItem();
                        try {
                            controller.selectionChanged(SAPropertyPanel.this.tableProperty, SAPropertyPanel.this.currentlySelectedValue);
                        }
                        catch (AuthorOperationException e1) {
                            LOGGER.debug(e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            });
            if (tableProperty.getCurrentValue() != null) {
                comboBox.setSelectedItem(tableProperty.getCurrentValue());
            }
            comboBox.setEnabled(this.tableProperty.isActive());
            parentContainer.add((Component)comboBox, constr);
            ++constr.gridy;
            this.valuesComponent.add(comboBox);
        } else if (GuiElements.RADIO_BUTTONS == guiElement) {
            constr.gridwidth = 2;
            constr.fill = 2;
            constr.weightx = 1.0;
            ButtonGroup valuesGroup = new ButtonGroup();
            for (int i = 0; i < values.size(); ++i) {
                constr.insets.top = i == 0 ? (constr.insets.top += 4) : 3;
                JRadioButton radioButton = new JRadioButton(values.get(i));
                radioButton.setOpaque(false);
                this.valuesComponent.add(radioButton);
                radioButton.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            JRadioButton selRadioButton = (JRadioButton)e.getItem();
                            SAPropertyPanel.this.currentlySelectedValue = selRadioButton.getText();
                            try {
                                controller.selectionChanged(SAPropertyPanel.this.tableProperty, SAPropertyPanel.this.currentlySelectedValue);
                            }
                            catch (AuthorOperationException e1) {
                                LOGGER.debug(e1.getMessage(), (Throwable)e1);
                            }
                        }
                    }
                });
                if (this.tableProperty.getCurrentValue() != null && values.get(i).equals(this.tableProperty.getCurrentValue())) {
                    radioButton.setSelected(true);
                }
                radioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                valuesGroup.add(radioButton);
                if ("<preserve>".equals(values.get(i)) || "<not set>".equals(values.get(i))) {
                    Font font = radioButton.getFont();
                    Font derivedFont = font.deriveFont(2);
                    radioButton.setFont(derivedFont);
                }
                radioButton.setEnabled(this.tableProperty.isActive());
                parentContainer.add((Component)radioButton, constr);
                ++constr.gridy;
            }
        }
    }

    public TableProperty getModifiedProperty() {
        TableProperty modifiedProperty = null;
        String currentSelectedValue = this.tableProperty.getCurrentValue();
        if (this.tableProperty.getGuiType() == GuiElements.COMBOBOX) {
            currentSelectedValue = (String)((JComboBox)this.valuesComponent.get(0)).getSelectedItem();
        } else if (this.tableProperty.getGuiType() == GuiElements.RADIO_BUTTONS) {
            for (int i = 0; i < this.valuesComponent.size(); ++i) {
                JRadioButton radioButton = (JRadioButton)this.valuesComponent.get(i);
                boolean isSelected = radioButton.isSelected();
                if (!isSelected) continue;
                currentSelectedValue = radioButton.getText();
                break;
            }
        }
        if (this.tableProperty.getCurrentValue() == null || this.tableProperty.getCurrentValue() != null && !this.tableProperty.getCurrentValue().equals(currentSelectedValue)) {
            modifiedProperty = new TableProperty(this.tableProperty.getAttributeName(), this.tableProperty.getAttributeRenderString(), this.tableProperty.getValues(), currentSelectedValue, this.tableProperty.isAttribute());
            modifiedProperty.setOldValue(this.tableProperty.getCurrentValue());
        }
        return modifiedProperty;
    }

    public String getCurrentlySelectedValue() {
        return this.currentlySelectedValue;
    }

    public TableProperty getTableProperty() {
        return this.tableProperty;
    }
}

