/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.ECPropertyComposite;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.PropertySelectionController;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.exml.workspace.api.util.ColorThemeUtilities;
import ro.sync.util.Resource;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECPropertiesComposite
extends Composite
implements PropertySelectionController {
    private static final Logger logger = LoggerFactory.getLogger((String)ECPropertiesComposite.class.getName());
    private final List<ECPropertyComposite> propertyPanels = new ArrayList<ECPropertyComposite>();
    private final Map<String, PreviewGroup> previewsList = new HashMap<String, PreviewGroup>();
    private final Map<String, Composite> groupsList = new HashMap<String, Composite>();
    private final Map<URL, Image> images = new HashMap<URL, Image>();
    private final AuthorResourceBundle authorResourceBundle;
    private ColorThemeUtilities colorThemeUtilities;

    public ECPropertiesComposite(TabFolder parent, List<TableProperty> properties, String contextInfo, AuthorResourceBundle authorResourceBundle, ColorThemeUtilities colorThemeUtilities) {
        super((Composite)parent, 0);
        this.authorResourceBundle = authorResourceBundle;
        this.colorThemeUtilities = colorThemeUtilities;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 8;
        this.setLayout((Layout)gridLayout);
        this.setBackgroundMode(2);
        if (!colorThemeUtilities.getColorTheme().isHighContrastTheme()) {
            this.setBackground(Display.getDefault().getSystemColor(1));
        }
        GridData gd = new GridData(4, 4, true, true);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 340;
        this.setLayoutData(gd);
        LinkedHashMap<String, ArrayList<TableProperty>> groups = new LinkedHashMap<String, ArrayList<TableProperty>>();
        for (int i = 0; i < properties.size(); ++i) {
            TableProperty property = properties.get(i);
            String currentGroup = property.getParentGroup();
            ArrayList<TableProperty> list = (ArrayList<TableProperty>)groups.get(currentGroup);
            if (list == null) {
                list = new ArrayList<TableProperty>();
            }
            list.add(property);
            groups.put(currentGroup, list);
        }
        Set keySet = groups.keySet();
        for (String string : keySet) {
            if (((List)groups.get(string)).size() == 1 && ((TableProperty)((List)groups.get(string)).get(0)).getGuiType() == GuiElements.COMBOBOX) {
                this.groupsList.put(string, new Composite((Composite)this, 0));
            } else {
                this.groupsList.put(string, (Composite)new Group((Composite)this, 16));
            }
            this.previewsList.put(string, new PreviewGroup(this, 16, colorThemeUtilities));
        }
        Set groupSet = groups.keySet();
        for (String key : groupSet) {
            List props = (List)groups.get(key);
            this.addGroup(key, props);
        }
        if (contextInfo != null) {
            Label contextInfoLabel = new Label((Composite)this, 16384);
            gd = new GridData(4, 0, true, false);
            gd.horizontalIndent = 8;
            gd.verticalIndent = 8;
            contextInfoLabel.setLayoutData((Object)gd);
            contextInfoLabel.setText(contextInfo);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Image img : ECPropertiesComposite.this.images.values()) {
                    img.dispose();
                }
                ECPropertiesComposite.this.images.clear();
            }
        });
    }

    public List<TableProperty> getModifiedProperties() {
        ArrayList<TableProperty> properties = new ArrayList<TableProperty>();
        for (int i = 0; i < this.propertyPanels.size(); ++i) {
            TableProperty modifiedProperty = this.propertyPanels.get(i).getModifiedProperty();
            if (modifiedProperty == null) continue;
            properties.add(modifiedProperty);
        }
        return properties;
    }

    private void addGroup(String keyTitle, List<TableProperty> properties) {
        Composite group = this.groupsList.get(keyTitle);
        if (group instanceof Group) {
            ((Group)group).setText(this.authorResourceBundle.getMessage(keyTitle));
        }
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gridLayoutData = new GridData(4, 4, true, false);
        if (!(group instanceof Group)) {
            gridLayoutData.horizontalIndent = 3;
        }
        group.setLayoutData((Object)gridLayoutData);
        int columnsNumber = 1;
        for (int i = 0; i < properties.size(); ++i) {
            if (properties.get(i).getGuiType() == GuiElements.COMBOBOX) {
                columnsNumber = 2;
            }
            layout.numColumns = columnsNumber;
            ECPropertyComposite p = new ECPropertyComposite(group, properties.get(i), this.authorResourceBundle, this, i == 0);
            this.propertyPanels.add(p);
        }
        group.pack(true);
        gridLayoutData = new GridData(0, 0, false, false);
        gridLayoutData.widthHint = 150;
        gridLayoutData.horizontalAlignment = 64;
        gridLayoutData.verticalAlignment = 4;
        this.previewsList.get(keyTitle).setLayoutData(gridLayoutData);
    }

    @Override
    public void selectionChanged(TableProperty property, String newValue) throws AuthorOperationException {
        StringBuilder iconRelativePath = new StringBuilder();
        String group = property.getParentGroup();
        if ("colsep".equalsIgnoreCase(property.getAttributeName()) || "rowsep".equalsIgnoreCase(property.getAttributeName())) {
            String colsepVal = "<not set>";
            String rowsepVal = "<not set>";
            boolean checkRowsep = true;
            if ("colsep".equalsIgnoreCase(property.getAttributeName())) {
                colsepVal = newValue;
            } else {
                rowsepVal = newValue;
                checkRowsep = false;
            }
            for (int i = 0; i < this.propertyPanels.size(); ++i) {
                ECPropertyComposite tableProperty = this.propertyPanels.get(i);
                if (checkRowsep && "rowsep".equalsIgnoreCase(tableProperty.getTableProperty().getAttributeName())) {
                    rowsepVal = tableProperty.getCurrentlySelectedValue();
                    continue;
                }
                if (checkRowsep || !"colsep".equalsIgnoreCase(tableProperty.getTableProperty().getAttributeName())) continue;
                colsepVal = tableProperty.getCurrentlySelectedValue();
            }
            if ("1".equals(colsepVal) && "1".equals(rowsepVal)) {
                iconRelativePath.append("/images/table-properties/ColRowSep.png");
            } else if ("1".equals(colsepVal)) {
                iconRelativePath.append("/images/table-properties/ColSep.png");
            } else if ("1".equals(rowsepVal)) {
                iconRelativePath.append("/images/table-properties/RowSep.png");
            } else {
                iconRelativePath.append("/images/table-properties/EmptyIcon.png");
            }
        } else {
            String iconPath = null;
            iconPath = property.getIcons().get(newValue);
            if (iconPath != null) {
                iconRelativePath.append(iconPath);
            } else {
                iconRelativePath.append("/images/table-properties/EmptyIcon.png");
            }
        }
        PreviewGroup previewGroup = this.previewsList.get(group);
        if (previewGroup != null) {
            URL imageURL = Resource.getResource((String)iconRelativePath.toString());
            Image imageIcon = this.images.get(imageURL);
            if (imageIcon == null) {
                boolean fallback = true;
                if (this.colorThemeUtilities.getColorTheme().isHighContrastTheme() && !this.colorThemeUtilities.getColorTheme().isHighContrastWhiteTheme()) {
                    try {
                        ImageDescriptor loadedImage = (ImageDescriptor)this.colorThemeUtilities.getImageInverter().loadImage(imageURL);
                        loadedImage = (ImageDescriptor)this.colorThemeUtilities.getImageInverter().invertImage((Object)loadedImage);
                        imageIcon = loadedImage.createImage();
                        fallback = false;
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
                if (fallback) {
                    ImageDescriptor currentImageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
                    imageIcon = currentImageDescriptor.createImage();
                }
                this.images.put(imageURL, imageIcon);
            }
            previewGroup.setPreviewImage(imageIcon);
            previewGroup.redraw();
        }
    }

    class PreviewGroup
    extends Group {
        Label previewLabel;

        public PreviewGroup(Composite parent, int style, ColorThemeUtilities colorThemeUtilities) {
            super(parent, style);
            this.previewLabel = null;
            this.setText(ECPropertiesComposite.this.authorResourceBundle.getMessage("Preview"));
            GridLayout previewLayout = new GridLayout();
            previewLayout.numColumns = 1;
            this.setLayout((Layout)previewLayout);
            this.previewLabel = new Label((Composite)this, 0x1000000);
            this.previewLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            URL imageURL = Resource.getResource((String)"/images/table-properties/EmptyIcon.png");
            Image imageIcon = null;
            boolean fallback = true;
            if (colorThemeUtilities.getColorTheme().isHighContrastTheme() && !colorThemeUtilities.getColorTheme().isHighContrastWhiteTheme()) {
                try {
                    Object loadedImage = colorThemeUtilities.getImageInverter().loadImage(imageURL);
                    ImageDescriptor currentImageDescriptor = (ImageDescriptor)colorThemeUtilities.getImageInverter().invertImage(loadedImage);
                    imageIcon = currentImageDescriptor.createImage();
                    fallback = false;
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            if (fallback) {
                ImageDescriptor currentImageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
                imageIcon = currentImageDescriptor.createImage();
            }
            ECPropertiesComposite.this.images.put(imageURL, imageIcon);
            this.previewLabel.setImage(imageIcon);
        }

        public Label getPreviewLabel() {
            return this.previewLabel;
        }

        public void setPreviewImage(Image image) {
            this.previewLabel.setImage(image);
        }

        protected void checkSubclass() {
        }
    }
}

