/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.xhtml;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLConstants;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLDocumentTypeHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertColumnOperation
extends InsertColumnOperationBase
implements XHTMLConstants {
    private static final String ELEMENT_NAME_COLSPEC = "col";
    private static final String ELEMENT_NAME_THEAD = "thead";
    private static final String ELEMENT_NAME_TBODY = "tbody";
    private static final String ELEMENT_NAME_COLGROUP = "colgroup";

    public InsertColumnOperation() {
        this(new XHTMLDocumentTypeHelper());
    }

    protected InsertColumnOperation(AuthorTableHelper documentTypeHelper) {
        super(documentTypeHelper);
    }

    @Override
    protected String getCellElementName(AuthorElement rowElement, int newColumnIndex) {
        String elemName = "td";
        String name = InsertColumnOperation.getLocalName(rowElement.getParent().getName());
        if (ELEMENT_NAME_THEAD.equals(name)) {
            elemName = "th";
        }
        return elemName;
    }

    private static String getLocalName(String qName) {
        int idx;
        String local = qName;
        if (qName != null && (idx = qName.lastIndexOf(58)) != -1) {
            local = qName.substring(idx + 1);
        }
        return local;
    }

    @Override
    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSupport, AuthorElement tableElem, int newColumnIndex, TableColumnSpecificationInformation columnSpecification, String namespace, int noOfColumnsToBeInserted) throws AuthorOperationException {
        super.updateColumnCellsSpan(authorAccess, tableSupport, tableElem, newColumnIndex, columnSpecification, namespace, noOfColumnsToBeInserted);
        int referenceInsertionOffset = tableElem.getEndOffset();
        List tableChildren = tableElem.getContentNodes();
        int noOfEncounteredCols = 0;
        boolean foundColspecs = false;
        if (tableChildren != null) {
            block0: for (int i = 0; i < tableChildren.size(); ++i) {
                AuthorNode child = (AuthorNode)tableChildren.get(i);
                if (child.getType() != 0) continue;
                AuthorElement elem = (AuthorElement)child;
                String localName = elem.getLocalName();
                if (ELEMENT_NAME_THEAD.equals(localName) || ELEMENT_NAME_TBODY.equals(localName)) {
                    referenceInsertionOffset = elem.getStartOffset();
                    break;
                }
                if (ELEMENT_NAME_COLGROUP.equals(localName)) {
                    foundColspecs = true;
                    List colgroupChildren = elem.getContentNodes();
                    if (colgroupChildren != null) {
                        for (int j = 0; j < colgroupChildren.size(); ++j) {
                            AuthorElement cgElem;
                            AuthorNode cgCH = (AuthorNode)colgroupChildren.get(j);
                            if (cgCH.getType() != 0 || !ELEMENT_NAME_COLSPEC.equals((cgElem = (AuthorElement)cgCH).getLocalName())) continue;
                            if (noOfEncounteredCols == newColumnIndex) {
                                referenceInsertionOffset = cgElem.getStartOffset();
                                break block0;
                            }
                            ++noOfEncounteredCols;
                        }
                    }
                    if (noOfEncounteredCols == newColumnIndex) {
                        referenceInsertionOffset = elem.getEndOffset();
                        break;
                    }
                    ++noOfEncounteredCols;
                    continue;
                }
                if (!ELEMENT_NAME_COLSPEC.equals(localName)) continue;
                foundColspecs = true;
                if (noOfEncounteredCols == newColumnIndex) {
                    referenceInsertionOffset = elem.getStartOffset();
                    break;
                }
                ++noOfEncounteredCols;
            }
        }
        if (referenceInsertionOffset != -1 && foundColspecs) {
            StringBuilder newColSpecFragment = new StringBuilder();
            for (int i = 0; i < noOfColumnsToBeInserted; ++i) {
                newColSpecFragment.append("<").append(ELEMENT_NAME_COLSPEC);
                if (namespace != null) {
                    newColSpecFragment.append(" xmlns=\"").append(namespace).append("\"");
                }
                newColSpecFragment.append("/>");
            }
            authorAccess.getDocumentController().insertXMLFragment(newColSpecFragment.toString(), referenceInsertionOffset);
        }
    }
}

