/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SplitLeftRightOperationBase
extends AbstractTableOperation {
    private static final String SPLIT_LEFT = "Left";
    private static final String SPLIT_RIGHT = "Right";
    private static final String ARGUMENT_NAME = "Split point";

    public SplitLeftRightOperationBase(AuthorTableHelper tableHelper) {
        super(tableHelper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        try {
            AuthorTableCellSpanProvider tableSupport;
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            AuthorElement cell = this.getElementAncestor(nodeAtCaret, 0);
            if (cell != null) {
                int cellColSpan;
                AuthorElement tableElem = this.getElementAncestor(nodeAtCaret, 2);
                if (tableElem == null) throw new AuthorOperationException("The table cell must be inside a table element.");
                tableSupport = this.tableHelper.getTableCellSpanProvider(tableElem);
                this.tableHelper.checkTableColSpanIsDefined(authorAccess, tableSupport, cell);
                Integer cellColSpanInteger = tableSupport.getColSpan(cell);
                int n = cellColSpan = cellColSpanInteger != null ? cellColSpanInteger : 1;
                if (cellColSpan <= 1) {
                    AuthorOperationException ex = new AuthorOperationException("The cell you are trying to split does not span over multiple columns.");
                    ex.setOperationRejectedOnPurpose(true);
                    throw ex;
                }
            } else {
                AuthorOperationException ex = new AuthorOperationException("The caret must be inside a table cell.");
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            boolean splitLeft = SPLIT_LEFT.equals(args.getArgumentValue(ARGUMENT_NAME));
            AuthorDocumentController controller = authorAccess.getDocumentController();
            AuthorDocumentFragment emptyCellFragment = this.createEmptyCell(authorAccess, cell, this.getAttributesSkippedAtCopy());
            int insertOffset = -1;
            insertOffset = splitLeft ? cell.getStartOffset() : cell.getEndOffset() + 1;
            this.decreaseColSpan(authorAccess, tableSupport, cell, splitLeft);
            controller.insertFragment(insertOffset, emptyCellFragment);
            authorAccess.getEditorAccess().setCaretPosition(insertOffset + 1);
            return;
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ARGUMENT_NAME, 3, "The location relative to the source cell for the newly split cell.", new String[]{SPLIT_LEFT, SPLIT_RIGHT}, SPLIT_LEFT)};
    }

    public String getDescription() {
        return "This operation splits the content of a table cell that spans over multiple columns.";
    }

    private void decreaseColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSupport, AuthorElement cell, boolean left) throws AuthorOperationException {
        int[] cellColSpanIndices = authorAccess.getTableAccess().getTableColSpanIndices(cell);
        int startColumn = cellColSpanIndices[0] + 1;
        int endColumn = cellColSpanIndices[1] + 1;
        if (left) {
            this.tableHelper.updateTableColSpan(authorAccess, tableSupport, cell, startColumn + 1, endColumn);
        } else {
            this.tableHelper.updateTableColSpan(authorAccess, tableSupport, cell, startColumn, endColumn - 1);
        }
    }

    protected abstract String[] getAttributesSkippedAtCopy();
}

