/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class MoveCaretOperation
implements AuthorOperation {
    private static final String XPATH_LOCATION = "xpathLocation";
    private static final String POSITION = "position";
    private static final String SELECTION = "selection";
    private static final ArgumentDescriptor XPATH_LOCATION_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("xpathLocation", 2, "An XPath expression identifying the node relative to which the caret will be moved. If the expression identifies more than one node, only the first one will be taken into account.", ".");
    private static final ArgumentDescriptor POSITION_DESCRIPTOR = new ArgumentDescriptor("position", 3, "The position relative to the node obtained from the XPath expression where the caret will be moved. When also choosing to perform a selection, \"Before\" and \"Inside, at the beginning\" will both place the caret at the beginning of the selection. In the same way, \"After\" and \"Inside, at the end\" will place the caret at the end of the selection.", new String[]{"Before", "After", "Inside, at the beginning", "Inside, at the end"}, "Inside, at the beginning");
    private static final ArgumentDescriptor SELECTION_DESCRIPTOR = new ArgumentDescriptor("selection", 3, "This argument specifies if the operation should select the node obtained from the XPath expression, its content or nothing at all.", new String[]{"None", "Content", "Element"}, "None");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{XPATH_LOCATION_ARGUMENT_DESCRIPTOR, POSITION_DESCRIPTOR, SELECTION_DESCRIPTOR};

    public String getDescription() {
        return "Author operation capable of moving the caret relative to an XML node identified by an XPath expression. The operation can also select an XML element or its content.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        String xpath = (String)args.getArgumentValue(XPATH_LOCATION);
        String position = (String)args.getArgumentValue(POSITION);
        String selection = (String)args.getArgumentValue(SELECTION);
        AuthorDocumentController ctrl = authorAccess.getDocumentController();
        AuthorNode[] xpathResult = ctrl.findNodesByXPath(xpath, true, true, false);
        if (xpathResult.length != 0) {
            AuthorNode node = xpathResult[0];
            if (selection.equals("None")) {
                if (position.equals("Before")) {
                    authorAccess.getEditorAccess().setCaretPosition(node.getStartOffset());
                } else if (position.equals("After")) {
                    authorAccess.getEditorAccess().setCaretPosition(node.getEndOffset() + 1);
                } else if (position.equals("Inside, at the beginning")) {
                    authorAccess.getEditorAccess().setCaretPosition(node.getStartOffset() + 1);
                } else if (position.equals("Inside, at the end")) {
                    authorAccess.getEditorAccess().setCaretPosition(node.getEndOffset());
                }
            } else if (selection.equals("Content")) {
                if (position.equals("Before") || position.equals("Inside, at the beginning")) {
                    authorAccess.getEditorAccess().select(node.getEndOffset(), node.getStartOffset() + 1);
                } else {
                    authorAccess.getEditorAccess().select(node.getStartOffset() + 1, node.getEndOffset());
                }
            } else if (selection.equals("Element")) {
                if (position.equals("Before") || position.equals("Inside, at the beginning")) {
                    authorAccess.getEditorAccess().select(node.getEndOffset() + 1, node.getStartOffset());
                } else {
                    authorAccess.getEditorAccess().select(node.getStartOffset(), node.getEndOffset() + 1);
                }
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }
}

