/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.yaml.converter;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.oxygen.JSONUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;
import ro.sync.basic.io.IOUtil;
import ro.sync.yaml.validator.YAMLValidator;
import ro.sync.yaml.validator.YAMLWellformedException;

public class YamlJsonConverter {
    public String convertYamlToJson(String yaml, int indentSize, boolean useTabs) throws YAMLWellformedException {
        return this.convertYamlDocumentToJson(YAMLValidator.loadYaml(new StringReader(yaml)).get(0), indentSize, useTabs);
    }

    public List<File> convertYamlFileToJson(URL yamlFileURL, File outputJsonFile, int indentSize, boolean useTabs) throws IOException, YAMLWellformedException {
        String yamlContent = IOUtil.readURL((URL)yamlFileURL, (String)"UTF-8");
        StringReader yamlReader = new StringReader(yamlContent);
        List<Object> yamlDocuments = YAMLValidator.loadYaml(yamlReader);
        if (!outputJsonFile.exists()) {
            outputJsonFile.getParentFile().mkdirs();
        }
        return this.convertYamlDocumentsToJson(yamlDocuments, outputJsonFile, indentSize, useTabs);
    }

    public List<File> convertYamlDocumentsToJson(List<Object> yamlDocuments, File outputJsonFile, int indentSize, boolean useTabs) throws IOException {
        File outputFolder = outputJsonFile.getParentFile();
        int documentNo = 0;
        String numberingFormat = outputJsonFile.getName().replace(".json", "") + "%d.json";
        ArrayList<File> convertedFiles = new ArrayList<File>();
        for (Object yamlDocument : yamlDocuments) {
            String jsonResult = this.convertYamlDocumentToJson(yamlDocument, indentSize, useTabs);
            String jsonFileName = yamlDocuments.size() == 1 ? outputJsonFile.getName() : String.format(numberingFormat, ++documentNo);
            outputJsonFile = new File(outputFolder, jsonFileName);
            IOUtil.saveInURLWithUTF8((URL)outputJsonFile.toURI().toURL(), (String)jsonResult);
            convertedFiles.add(outputJsonFile);
        }
        return convertedFiles;
    }

    private String convertYamlDocumentToJson(Object yamlDocument, int indentSize, boolean useTabs) {
        String jsonResult = "";
        jsonResult = yamlDocument instanceof Map ? new JSONObject((Map)yamlDocument).toString(indentSize, false, useTabs) : (yamlDocument instanceof List ? new JSONArray((Collection)((List)yamlDocument)).toString(indentSize, false, useTabs) : String.valueOf(yamlDocument));
        return jsonResult;
    }

    public String convertJsonToYaml(String json) throws IOException {
        try {
            json = this.escapeTabChar(json);
            JSONUtil.createJsonInstance((String)json);
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setExplicitStart(true);
            dumperOptions.setWidth(100);
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            LoaderOptions loaderOptions = new LoaderOptions();
            loaderOptions.setCodePointLimit(524288000);
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(loaderOptions), new Representer(dumperOptions), dumperOptions, loaderOptions);
            return yaml.dump(yaml.load(json)).trim();
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public File convertJsonFileToYaml(URL jsonFileURL, File outputYamlFile) throws IOException {
        String jsonContent = IOUtil.readURL((URL)jsonFileURL, (String)"UTF-8");
        String yamlResult = this.convertJsonToYaml(jsonContent);
        if (!outputYamlFile.exists()) {
            outputYamlFile.getParentFile().mkdirs();
        }
        IOUtil.saveInURLWithUTF8((URL)outputYamlFile.toURI().toURL(), (String)yamlResult);
        return outputYamlFile;
    }

    private String escapeTabChar(String json) {
        if (json != null && json.contains("\t")) {
            json = json.replace('\t', ' ');
        }
        return json;
    }
}

