/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.renderx.xep.FOTarget;
import com.renderx.xep.FormatterImpl;
import com.renderx.xep.lib.ConfigurationException;
import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class FoXEP
implements FoProcessor {
    private Logger logger = LoggerFactory.getLogger(FoXEP.class);
    XProcRuntime runtime = null;
    FormatterImpl xep = null;
    XStep step = null;

    public void initialize(XProcRuntime runtime, XStep step, Properties options) {
        this.runtime = runtime;
        this.step = step;
        try {
            this.xep = new FormatterImpl(options, (com.renderx.xep.lib.Logger)new FoLogger());
        }
        catch (ConfigurationException ce) {
            throw new XProcException("Failed to initialize XEP", (Throwable)ce);
        }
    }

    public void format(XdmNode doc, OutputStream out, String contentType) {
        String outputFormat = null;
        if (contentType == null || "application/pdf".equals(contentType)) {
            outputFormat = "PDF";
        } else if ("application/PostScript".equals(contentType)) {
            outputFormat = "PostScript";
        } else if ("application/afp".equals(contentType)) {
            outputFormat = "AFP";
        } else {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:xsl-formatter: " + contentType);
        }
        try {
            InputSource fodoc = S9apiUtils.xdmToInputSource((XProcRuntime)this.runtime, (XdmNode)doc);
            SAXSource source = new SAXSource(fodoc);
            this.xep.render((Source)source, new FOTarget(out, outputFormat));
        }
        catch (Exception e) {
            throw new XProcException(this.step.getNode(), "Failed to process FO document with XEP", (Throwable)e);
        }
        finally {
            this.xep.cleanup();
        }
    }

    private class FoLogger
    implements com.renderx.xep.lib.Logger {
        private FoLogger() {
        }

        public void openDocument() {
            FoXEP.this.step.info(FoXEP.this.step.getNode(), "p:xsl-formatter document processing starts");
        }

        public void closeDocument() {
            FoXEP.this.step.info(FoXEP.this.step.getNode(), "p:xsl-formatter document processing ends");
        }

        public void event(String name, String message) {
            FoXEP.this.logger.trace(MessageFormatter.nodeMessage((XdmNode)FoXEP.this.step.getNode(), (String)("p:xsl-formatter processing " + name + ": " + message)));
        }

        public void openState(String state) {
            FoXEP.this.logger.trace(MessageFormatter.nodeMessage((XdmNode)FoXEP.this.step.getNode(), (String)("p:xsl-formatter process start: " + state)));
        }

        public void closeState(String state) {
            FoXEP.this.logger.trace(MessageFormatter.nodeMessage((XdmNode)FoXEP.this.step.getNode(), (String)("p:xsl-formatter process end: " + state)));
        }

        public void info(String message) {
            FoXEP.this.step.info(FoXEP.this.step.getNode(), message);
        }

        public void warning(String message) {
            FoXEP.this.step.warning(FoXEP.this.step.getNode(), message);
        }

        public void error(String message) {
            FoXEP.this.step.error(FoXEP.this.step.getNode(), message, XProcConstants.stepError((int)1));
        }

        public void exception(String message, Exception exception) {
            throw new XProcException(message, (Throwable)exception);
        }
    }
}

