/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.princexml.Prince;
import com.princexml.PrinceEvents;
import com.xmlcalabash.config.CssProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssPrince
implements CssProcessor {
    private Logger logger = LoggerFactory.getLogger(CssPrince.class);
    private static final QName _content_type = new QName("content-type");
    private static final QName _encoding = new QName("", "encoding");
    XProcRuntime runtime = null;
    Properties options = null;
    String primarySS = null;
    Vector<String> userSS = new Vector();
    XStep step = null;
    Prince prince = null;

    public void initialize(XProcRuntime runtime, XStep step, Properties options) {
        Integer keyBits;
        Boolean b;
        this.runtime = runtime;
        this.step = step;
        this.options = options;
        String exePath = this.getStringProp("exePath");
        if (exePath == null) {
            exePath = System.getProperty("com.xmlcalabash.css.prince.exepath");
        }
        if (exePath == null || "".equals(exePath)) {
            throw new XProcException("Attempt to use Prince as CSS formater but no Prince exePath specified");
        }
        this.prince = new Prince(exePath, (PrinceEvents)new PrinceMessages());
        String s = this.getStringProp("baseURL");
        if (s != null) {
            this.prince.setBaseURL(s);
        }
        if ((b = this.getBooleanProp("compress")) != null) {
            this.prince.setCompress(b.booleanValue());
        }
        if ((b = this.getBooleanProp("debug")) != null) {
            this.prince.setDebug(b.booleanValue());
        }
        if ((b = this.getBooleanProp("embedFonts")) != null) {
            this.prince.setEmbedFonts(b.booleanValue());
        }
        if ((b = this.getBooleanProp("encrypt")) != null) {
            this.prince.setEncrypt(b.booleanValue());
        }
        if ((keyBits = this.getIntProp("keyBits")) != null) {
            String up = this.getStringProp("userPassword");
            String op = this.getStringProp("ownerPassword");
            b = this.getBooleanProp("disallowPrint");
            boolean dp = b == null ? false : b;
            b = this.getBooleanProp("disallowModify");
            boolean dm = b == null ? false : b;
            b = this.getBooleanProp("disallowCopy");
            boolean dc = b == null ? false : b;
            b = this.getBooleanProp("disallowAnnotate");
            boolean da = b == null ? false : b;
            this.prince.setEncryptInfo(keyBits.intValue(), up, op, dp, dm, dc, da);
        }
        if ((s = this.getStringProp("fileRoot")) != null) {
            this.prince.setFileRoot(s);
        }
        if ((b = this.getBooleanProp("html")) != null) {
            this.prince.setHTML(b.booleanValue());
        }
        if ((s = this.getStringProp("httpPassword")) != null) {
            this.prince.setHttpPassword(s);
        }
        if ((s = this.getStringProp("httpUsername")) != null) {
            this.prince.setHttpUsername(s);
        }
        if ((s = this.getStringProp("httpProxy")) != null) {
            this.prince.setHttpProxy(s);
        }
        if ((s = this.getStringProp("inputType")) != null) {
            this.prince.setInputType(s);
        }
        if ((b = this.getBooleanProp("javascript")) != null) {
            this.prince.setJavaScript(b.booleanValue());
        }
        if ((s = this.getStringProp("log")) != null) {
            this.prince.setLog(s);
        }
        if ((b = this.getBooleanProp("network")) != null) {
            this.prince.setNetwork(b.booleanValue());
        }
        if ((b = this.getBooleanProp("subsetFonts")) != null) {
            this.prince.setSubsetFonts(b.booleanValue());
        }
        if ((b = this.getBooleanProp("verbose")) != null) {
            this.prince.setVerbose(b.booleanValue());
        }
        if ((b = this.getBooleanProp("XInclude")) != null) {
            this.prince.setXInclude(b.booleanValue());
        }
        if ((s = this.getStringProp("scripts")) != null) {
            for (String js : s.split("\\s+")) {
                this.prince.addScript(js);
            }
        }
    }

    public void addStylesheet(String uri) {
        if (this.primarySS == null) {
            this.primarySS = uri;
        } else {
            this.userSS.add(uri);
        }
    }

    public void addStylesheet(XdmNode doc) {
        File temp;
        doc = S9apiUtils.getDocumentElement((XdmNode)doc);
        String stylesheet = null;
        if (XProcConstants.c_data.equals((Object)doc.getNodeName()) && "application/octet-stream".equals(doc.getAttributeValue(_content_type)) || "base64".equals(doc.getAttributeValue(_encoding))) {
            byte[] decoded = Base64.decode((String)doc.getStringValue());
            stylesheet = new String(decoded);
        } else {
            stylesheet = doc.getStringValue();
        }
        String prefix = "temp";
        String suffix = ".css";
        try {
            temp = File.createTempFile(prefix, suffix);
        }
        catch (IOException ioe) {
            throw new XProcException(this.step.getNode(), "Failed to create temporary file for CSS");
        }
        temp.deleteOnExit();
        try {
            PrintStream cssout = new PrintStream(temp);
            cssout.print(stylesheet);
            cssout.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new XProcException(this.step.getNode(), "Failed to write to temporary CSS file");
        }
        if (this.primarySS == null) {
            this.primarySS = temp.toURI().toASCIIString();
        } else {
            this.userSS.add(temp.toURI().toASCIIString());
        }
    }

    public void format(XdmNode doc, OutputStream out, String contentType) {
        if (contentType != null && !"application/pdf".equals(contentType)) {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:css-formatter: " + contentType);
        }
        try {
            if (this.primarySS != null) {
                this.prince.addStyleSheet(this.primarySS);
            }
            for (String uri : this.userSS) {
                this.prince.addStyleSheet(uri);
            }
            Serializer serializer = this.runtime.getProcessor().newSerializer();
            serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                serializer.setOutputStream((OutputStream)baos);
                S9apiUtils.serialize((XProcRuntime)this.runtime, (XdmNode)doc, (Serializer)serializer);
            }
            catch (SaxonApiException sae) {
                throw new XProcException((Throwable)sae);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            this.prince.convert((InputStream)bis, out);
        }
        catch (IOException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            throw new XProcException((Throwable)e);
        }
    }

    private String getStringProp(String name) {
        return this.options.getProperty(name);
    }

    private Integer getIntProp(String name) {
        String s = this.getStringProp(name);
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                return i;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    private Boolean getBooleanProp(String name) {
        String s = this.options.getProperty(name);
        if (s != null) {
            return "true".equals(s);
        }
        return null;
    }

    private class PrinceMessages
    implements PrinceEvents {
        private PrinceMessages() {
        }

        public void onMessage(String msgType, String msgLoc, String msgText) {
            if ("inf".equals(msgType)) {
                CssPrince.this.step.info(CssPrince.this.step.getNode(), msgText);
            } else if ("wrn".equals(msgType)) {
                CssPrince.this.step.warning(CssPrince.this.step.getNode(), msgText);
            } else {
                CssPrince.this.step.error(CssPrince.this.step.getNode(), msgText, new QName("http://xproc.org/ns/errors", "prince"));
            }
        }
    }
}

