/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import java.net.URL;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.docbook.DocBookImageInfo;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.ImageFileChooser;
import ro.sync.ecss.extensions.commons.MediaObjectsUtil;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.docbook.Docbook4InsertMediaDataOperation;
import ro.sync.ecss.extensions.docbook.InsertGraphicOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class Docbook4ExternalObjectInsertionHandler
extends AuthorExternalObjectInsertionHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)Docbook4ExternalObjectInsertionHandler.class.getName());

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, int source) throws AuthorOperationException {
        if (!urls.isEmpty()) {
            URL base = Docbook4ExternalObjectInsertionHandler.getBaseURLAtCaretPosition((AuthorAccess)authorAccess);
            for (int i = 0; i < urls.size(); ++i) {
                Integer off;
                URL url = urls.get(i);
                String relativeLocation = authorAccess.getUtilAccess().makeRelative(base, url);
                int cp = authorAccess.getEditorAccess().getCaretOffset();
                SchemaAwareHandlerResult result = null;
                if (authorAccess.getUtilAccess().isSupportedImageURL(url)) {
                    DocBookImageInfo imageInfo = new DocBookImageInfo();
                    imageInfo.addProperty("href", ImageFileChooser.makeUrlRelative(authorAccess, relativeLocation));
                    boolean isInlineGraphicAccepted = false;
                    try {
                        isInlineGraphicAccepted = CommonsOperationsUtil.isAllowedElement("inlinegraphic", authorAccess.getEditorAccess().getCaretOffset(), authorAccess.getDocumentController().getAuthorSchemaManager());
                    }
                    catch (BadLocationException e) {
                        logger.warn((Object)e, (Throwable)e);
                    }
                    result = InsertGraphicOperation.insertImageRef(authorAccess, imageInfo, isInlineGraphicAccepted);
                } else {
                    result = MediaObjectsUtil.isMediaReference(url) ? new Docbook4InsertMediaDataOperation().insertMediaRef(authorAccess, relativeLocation) : authorAccess.getDocumentController().insertXMLFragmentSchemaAware("<ulink url=\"" + authorAccess.getXMLUtilAccess().escapeAttributeValue(relativeLocation) + "\"/>", cp, true);
                }
                if (result == null || i >= urls.size() - 1 || (off = (Integer)result.getResult("result.id.handle.insert.fragment.offset")) == null) continue;
                try {
                    authorAccess.getEditorAccess().setCaretPosition(authorAccess.getDocumentController().getNodeAtOffset(off + 1).getEndOffset() + 1);
                    continue;
                }
                catch (BadLocationException e) {
                    logger.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected String getImporterStylesheetFileName(AuthorAccess authorAccess) {
        return "xhtml2db4Driver.xsl";
    }
}

