/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.SchemaManagerFilter;
import ro.sync.ecss.docbook.DocbookAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorActionEventHandler;
import ro.sync.ecss.extensions.api.AuthorImageDecorator;
import ro.sync.ecss.extensions.api.AuthorTableCellSepProvider;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProvider;
import ro.sync.ecss.extensions.api.DocbookAuthorActionEventHandler;
import ro.sync.ecss.extensions.api.EditPropertiesHandler;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.link.LinkTextResolver;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.spell.SpellCheckerHelper;
import ro.sync.ecss.extensions.commons.table.support.CALSandHTMLTableCellInfoProvider;
import ro.sync.ecss.extensions.docbook.DocbookAuthorImageDecorator;
import ro.sync.ecss.extensions.docbook.DocbookNodeRendererCustomizer;
import ro.sync.ecss.extensions.docbook.DocbookSchemaManagerFilter;
import ro.sync.ecss.extensions.docbook.EditImageMapOperation;
import ro.sync.ecss.extensions.docbook.link.DocbookLinkTextResolver;
import ro.sync.ecss.extensions.docbook.table.DocbookTableCellSepInfoProvider;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class DocBookExtensionsBundleBase
extends ExtensionsBundle {
    private static final Logger logger = LoggerFactory.getLogger((String)DocBookExtensionsBundleBase.class.getName());
    private static final String IMAGEDATA = "imagedata";
    private static final String IMAGEOBJECTCO = "imageobjectco";
    private static final String IMAGEOBJECT = "imageobject";
    private AuthorActionEventHandler handler;
    private DocbookAuthorImageDecorator decorator;

    public AuthorTableCellSpanProvider createAuthorTableCellSpanProvider() {
        return new CALSandHTMLTableCellInfoProvider();
    }

    public AuthorTableColumnWidthProvider createAuthorTableColumnWidthProvider() {
        return new CALSandHTMLTableCellInfoProvider();
    }

    public AuthorTableCellSepProvider createAuthorTableCellSepProvider() {
        return new DocbookTableCellSepInfoProvider();
    }

    protected abstract String getDocumentNamespace();

    public SchemaManagerFilter createSchemaManagerFilter() {
        return new DocbookSchemaManagerFilter(this.getDocumentTypeName());
    }

    public XMLNodeRendererCustomizer createXMLNodeCustomizer() {
        return new DocbookNodeRendererCustomizer();
    }

    public LinkTextResolver createLinkTextResolver() {
        return new DocbookLinkTextResolver();
    }

    public URL resolveCustomHref(URL currentEditorURL, AuthorNode contextNode, String linkHref, AuthorAccess authorAccess) throws IOException {
        return DocbookAccess.resolveCustomHrefToMasterFile((URL)currentEditorURL, (String)linkHref, (AuthorAccess)authorAccess);
    }

    public AuthorActionEventHandler getAuthorActionEventHandler() {
        if (this.handler == null) {
            this.handler = new DocbookAuthorActionEventHandler();
        }
        return this.handler;
    }

    public AuthorImageDecorator getAuthorImageDecorator() {
        if (this.decorator == null) {
            this.decorator = new DocbookAuthorImageDecorator();
        }
        return this.decorator;
    }

    public EditPropertiesHandler createEditPropertiesHandler() {
        return new EditPropertiesHandler(){

            public String getDescription() {
                return "Handles imagemap editing";
            }

            public void editProperties(AuthorNode authorNode, AuthorAccess authorAccess) {
                try {
                    new EditImageMapOperation().doOperation(authorAccess, null);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }

            public boolean canEditProperties(AuthorNode authorNode) {
                boolean isHandled = false;
                if (authorNode.getType() == 0) {
                    AuthorElement parent;
                    AuthorElement element = (AuthorElement)authorNode;
                    if (DocBookExtensionsBundleBase.IMAGEOBJECTCO.equals(element.getLocalName())) {
                        isHandled = true;
                    } else if (DocBookExtensionsBundleBase.IMAGEOBJECT.equals(element.getLocalName())) {
                        AuthorElement parent2 = (AuthorElement)element.getParentElement();
                        isHandled = parent2 != null && DocBookExtensionsBundleBase.IMAGEOBJECTCO.equals(parent2.getLocalName());
                    } else if (DocBookExtensionsBundleBase.IMAGEDATA.equals(element.getLocalName()) && (parent = (AuthorElement)element.getParentElement()) != null && DocBookExtensionsBundleBase.IMAGEOBJECT.equals(parent.getLocalName())) {
                        AuthorElement granpa = (AuthorElement)parent.getParentElement();
                        isHandled = granpa != null && DocBookExtensionsBundleBase.IMAGEOBJECTCO.equals(granpa.getLocalName());
                    }
                }
                return isHandled;
            }
        };
    }

    public SpellCheckerHelper getSpellCheckerHelper() {
        return new SpellCheckerHelper(){

            public boolean isInlineNodeTransparentForSpellChecking(AuthorNode node) {
                return true;
            }
        };
    }
}

