/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSepProvider;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpanSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.errorscanner.CALSAndHTMLTableLayoutProblem;
import ro.sync.ecss.extensions.commons.table.support.errorscanner.TableLayoutErrorsListener;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSTableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider,
CALSConstants,
AuthorTableCellSepProvider {
    public static final WidthRepresentation DEFAULT_WIDTH_REPRESENTATION = new WidthRepresentation(0.0f, null, 1.0f, false){

        public boolean isSpecified() {
            return false;
        }
    };
    private static final String CALS_DOCBOOK_CELL_NAME = "entry";
    private Map<CALSColSpec, AuthorElement> colspecInfosMap = new TreeMap<CALSColSpec, AuthorElement>(new ColspecComparator());
    protected List<CALSColSpanSpec> spanspecInfos = new ArrayList<CALSColSpanSpec>();
    private AuthorElement tableElement;
    private static final String COLSPEC_NAME_PREFIX = "c";
    private boolean colsepAndRowSepAreVisibleByDefault = false;

    public CALSTableCellInfoProvider(boolean colsepAndRowSepAreVisibleByDefault) {
        this(colsepAndRowSepAreVisibleByDefault, null);
    }

    public CALSTableCellInfoProvider() {
        this(false, null);
    }

    public CALSTableCellInfoProvider(boolean colsepAndRowSepAreVisibleByDefault, TableLayoutErrorsListener errorsListener) {
        super(errorsListener);
        this.colsepAndRowSepAreVisibleByDefault = colsepAndRowSepAreVisibleByDefault;
    }

    public Integer getColSpan(AuthorElement cellElem) {
        int[] interval;
        Integer colspan = null;
        String startColumnName = null;
        String endColumnName = null;
        String attrValue = CALSTableCellInfoProvider.getAttributeValue(cellElem, "spanname");
        if (attrValue != null) {
            CALSColSpanSpec spanSpec = this.getSpanSpec(attrValue);
            if (spanSpec != null) {
                startColumnName = spanSpec.getStartColumnName();
                endColumnName = spanSpec.getEndColumnName();
            }
        } else {
            String namestValue = CALSTableCellInfoProvider.getAttributeValue(cellElem, "namest");
            String nameendValue = CALSTableCellInfoProvider.getAttributeValue(cellElem, "nameend");
            if (namestValue != null && nameendValue != null) {
                startColumnName = namestValue;
                endColumnName = nameendValue;
            }
        }
        if (startColumnName != null && endColumnName != null && (interval = this.getColSpan(startColumnName, endColumnName, cellElem)) != null) {
            colspan = Math.abs(interval[1] - interval[0]) + 1;
        }
        return colspan;
    }

    public int[] getColSpanInterval(AuthorElement cellElem) {
        int[] interval = null;
        String startColumnName = null;
        String endColumnName = null;
        String attrValue = CALSTableCellInfoProvider.getAttributeValue(cellElem, "spanname");
        if (attrValue != null) {
            CALSColSpanSpec spanSpec = this.getSpanSpec(attrValue);
            if (spanSpec != null) {
                startColumnName = spanSpec.getStartColumnName();
                endColumnName = spanSpec.getEndColumnName();
            }
        } else {
            String namestValue = CALSTableCellInfoProvider.getAttributeValue(cellElem, "namest");
            String nameendValue = CALSTableCellInfoProvider.getAttributeValue(cellElem, "nameend");
            if (namestValue != null && nameendValue != null) {
                startColumnName = namestValue;
                endColumnName = nameendValue;
            }
        }
        if (startColumnName != null && endColumnName != null) {
            interval = this.getColSpan(startColumnName, endColumnName, cellElem);
        }
        return interval;
    }

    private int[] getColSpan(String namest, String nameend, AuthorElement cellElement) {
        int[] colspan = null;
        int startIndex = -1;
        int endIndex = -1;
        Set<CALSColSpec> colspecs = this.colspecInfosMap.keySet();
        for (CALSColSpec colspec : colspecs) {
            if (namest.equals(colspec.getColumnName())) {
                startIndex = colspec.getColumnNumber();
            }
            if (!nameend.equals(colspec.getColumnName())) continue;
            endIndex = colspec.getColumnNumber();
        }
        if (this.errorsListener != null) {
            if (startIndex == -1 || endIndex == -1) {
                if (startIndex == -1) {
                    this.errorsListener.add(cellElement, this.tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_NAME_INCORRECT, namest, "namest");
                }
                if (endIndex == -1) {
                    this.errorsListener.add(cellElement, this.tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_NAME_INCORRECT, nameend, "nameend");
                }
            } else if (endIndex < startIndex) {
                this.errorsListener.add(cellElement, this.tableElement, CALSAndHTMLTableLayoutProblem.NAMEST_LESS_THAN_NAMEEND, startIndex, endIndex);
            }
        }
        if (startIndex != -1 && endIndex != -1) {
            colspan = new int[]{startIndex, endIndex};
        }
        return colspan;
    }

    public Integer getRowSpan(AuthorElement cellElement) {
        Integer span = null;
        String cs = CALSTableCellInfoProvider.getAttributeValue(cellElement, "morerows");
        if (cs != null) {
            try {
                int intVal = NumberParserUtil.parseInt((String)cs);
                if (intVal >= 1) {
                    span = intVal + 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return span;
    }

    public void init(AuthorElement tableElement) {
        this.tableElement = tableElement;
        this.colspecInfosMap.clear();
        this.spanspecInfos.clear();
        int colspecIndex = 0;
        List children = tableElement.getContentNodes();
        int colSpecNumber = 0;
        for (AuthorNode node : children) {
            if (!(node instanceof AuthorElement)) continue;
            AuthorElement child = (AuthorElement)node;
            if (this.isColspec(child)) {
                int currentColIndex;
                String attrValue;
                boolean colNumberSpecified;
                block19: {
                    colNumberSpecified = false;
                    attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "colnum");
                    currentColIndex = -1;
                    if (attrValue != null) {
                        try {
                            currentColIndex = NumberParserUtil.parseInt((String)attrValue);
                        }
                        catch (NumberFormatException nfe) {
                            if (this.errorsListener == null) break block19;
                            this.errorsListener.add(child, tableElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, "colnum", attrValue);
                        }
                    }
                }
                if (currentColIndex != -1) {
                    colSpecNumber = currentColIndex;
                    colNumberSpecified = true;
                } else {
                    ++colSpecNumber;
                }
                attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "colname");
                String colspecName = null;
                if (attrValue != null) {
                    colspecName = attrValue;
                }
                attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "colwidth");
                String colWidth = null;
                if (attrValue != null) {
                    colWidth = attrValue;
                    if (this.errorsListener != null) {
                        StringTokenizer st = new StringTokenizer(colWidth, "-+", false);
                        while (st.hasMoreTokens()) {
                            String before;
                            String token = st.nextToken().trim();
                            if (token.endsWith("*") && !"*".equals(token)) {
                                before = token.substring(0, token.length() - 1);
                                this.reportInvalidFloat(tableElement, child, before, colWidth);
                                continue;
                            }
                            if (!token.endsWith("pt") && !token.endsWith("px")) continue;
                            before = token.substring(0, token.length() - 2);
                            this.reportInvalidFloat(tableElement, child, before, colWidth);
                        }
                    }
                }
                attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "align");
                String textAlign = null;
                if (attrValue != null) {
                    textAlign = attrValue;
                }
                attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "colsep");
                Boolean colsep = null;
                if (attrValue != null) {
                    colsep = "1".equals(attrValue);
                }
                attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "rowsep");
                Boolean rowsep = null;
                if (attrValue != null) {
                    rowsep = "1".equals(attrValue);
                }
                CALSColSpec cs = new CALSColSpec(colspecIndex, colSpecNumber, colNumberSpecified, colspecName, colWidth, colsep, rowsep);
                cs.setAlign(textAlign);
                if (this.colspecInfosMap.containsKey(cs) && this.errorsListener != null) {
                    this.errorsListener.add(child, tableElement, CALSAndHTMLTableLayoutProblem.DUPLICATE_COLSPEC_NUMBER, cs.getColumnNumber());
                }
                this.colspecInfosMap.put(cs, child);
                ++colspecIndex;
                continue;
            }
            if (!"spanspec".equalsIgnoreCase(child.getLocalName())) continue;
            String spanName = null;
            String namest = null;
            String nameend = null;
            String attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "spanname");
            if (attrValue != null) {
                spanName = attrValue;
            }
            if ((attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "namest")) != null) {
                namest = attrValue;
            }
            if ((attrValue = CALSTableCellInfoProvider.getAttributeValue(child, "nameend")) != null) {
                nameend = attrValue;
            }
            if (spanName == null || namest == null || nameend == null) continue;
            this.spanspecInfos.add(new CALSColSpanSpec(spanName, namest, nameend));
        }
    }

    private void reportInvalidFloat(AuthorElement tableElement, AuthorElement child, String value, String originalValue) {
        boolean success = false;
        try {
            NumberParserUtil.parseFloat((String)value);
            success = true;
        }
        catch (NumberFormatException e) {
            success = false;
        }
        if (!success && this.errorsListener != null) {
            this.errorsListener.add(child, tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_WIDTH_VALUE_INCORRECT, originalValue);
        }
    }

    protected boolean isColspec(AuthorElement child) {
        return "colspec".equalsIgnoreCase(child.getLocalName());
    }

    public String getDescription() {
        return "Provides information about the cells for a DocBook or DITA table.";
    }

    private CALSColSpanSpec getSpanSpec(String spanSpecName) {
        CALSColSpanSpec spanSpec = null;
        for (CALSColSpanSpec currentSpanSpec : this.spanspecInfos) {
            if (!spanSpecName.equals(currentSpanSpec.getSpanName())) continue;
            spanSpec = currentSpanSpec;
            break;
        }
        return spanSpec;
    }

    public CALSColSpanSpec getCellSpanSpec(AuthorAccess authorAccess, AuthorElement cellElement) {
        CALSColSpanSpec spanSpec = null;
        String spanSpecAttr = CALSTableCellInfoProvider.getAttributeValue(cellElement, "spanname");
        if (spanSpecAttr != null) {
            spanSpec = this.getSpanSpec(spanSpecAttr);
        } else {
            String startColAttr = CALSTableCellInfoProvider.getAttributeValue(cellElement, "namest");
            String endColAttr = CALSTableCellInfoProvider.getAttributeValue(cellElement, "nameend");
            if (startColAttr != null && endColAttr != null) {
                spanSpec = new CALSColSpanSpec(null, startColAttr, endColAttr);
            } else {
                CALSColSpec colSpec = this.getColumnSpec(authorAccess, cellElement);
                if (colSpec != null) {
                    spanSpec = new CALSColSpanSpec(null, colSpec.getColumnName(), colSpec.getColumnName());
                }
            }
        }
        return spanSpec;
    }

    CALSColSpec getColumnSpec(AuthorAccess authorAccess, AuthorElement cellElement) {
        CALSColSpec colSpec = null;
        String attrValue = CALSTableCellInfoProvider.getAttributeValue(cellElement, "colname");
        if (attrValue != null) {
            colSpec = this.getColSpec(attrValue);
            if (this.errorsListener != null && colSpec == null) {
                this.errorsListener.add(cellElement, this.tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_NAME_INCORRECT, attrValue, "colname");
            }
        } else {
            int[] cellIndex = authorAccess.getTableAccess().getTableCellIndex(cellElement);
            if (cellIndex != null) {
                colSpec = this.getColSpec(cellIndex[1] + 1);
            }
        }
        return colSpec;
    }

    private CALSColSpec getColumnSpec(AuthorElement cellElement, int columnIndex) {
        CALSColSpec colSpec = null;
        String attrValue = CALSTableCellInfoProvider.getAttributeValue(cellElement, "colname");
        if (attrValue != null) {
            colSpec = this.getColSpec(attrValue);
            if (this.errorsListener != null && colSpec == null) {
                this.errorsListener.add(cellElement, this.tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_NAME_INCORRECT, attrValue, "colname");
            }
        } else {
            colSpec = this.getColSpec(columnIndex);
        }
        return colSpec;
    }

    public CALSColSpec getColSpec(String colSpecName) {
        CALSColSpec colSpec = null;
        Set<CALSColSpec> colspecs = this.colspecInfosMap.keySet();
        for (CALSColSpec currentColSpec : colspecs) {
            if (colSpecName == null || !colSpecName.equals(currentColSpec.getColumnName())) continue;
            colSpec = currentColSpec;
            break;
        }
        return colSpec;
    }

    public CALSColSpec getColSpec(int columnNumber) {
        CALSColSpec colSpec = null;
        Set<CALSColSpec> colspecs = this.colspecInfosMap.keySet();
        for (CALSColSpec currentColSpec : colspecs) {
            if (columnNumber != currentColSpec.getColumnNumber()) continue;
            colSpec = currentColSpec;
            break;
        }
        return colSpec;
    }

    public AuthorElement getColSpecElement(CALSColSpec colspec) {
        return this.colspecInfosMap.get(colspec);
    }

    public Set<CALSColSpec> getColSpecs() {
        return this.colspecInfosMap.keySet();
    }

    public boolean hasColumnSpecifications(AuthorElement tableElement) {
        return !this.colspecInfosMap.isEmpty();
    }

    public List<WidthRepresentation> getCellWidth(AuthorElement cellElement, int colNumberStart, int colSpan) {
        ArrayList<WidthRepresentation> toReturn;
        block13: {
            Set<CALSColSpec> colspecs;
            block14: {
                toReturn = null;
                String attrValue = CALSTableCellInfoProvider.getAttributeValue(cellElement, "spanname");
                String startColumnName = null;
                String endColumnName = null;
                if (attrValue != null) {
                    CALSColSpanSpec spanSpec = this.getSpanSpec(attrValue);
                    if (spanSpec != null) {
                        startColumnName = spanSpec.getStartColumnName();
                        endColumnName = spanSpec.getEndColumnName();
                    }
                } else {
                    String namestValue = CALSTableCellInfoProvider.getAttributeValue(cellElement, "namest");
                    String nameendValue = CALSTableCellInfoProvider.getAttributeValue(cellElement, "nameend");
                    if (namestValue != null && nameendValue != null) {
                        startColumnName = namestValue;
                        endColumnName = nameendValue;
                    }
                }
                if (startColumnName == null && endColumnName == null && (attrValue = CALSTableCellInfoProvider.getAttributeValue(cellElement, "colname")) != null) {
                    startColumnName = endColumnName = attrValue;
                }
                if (startColumnName == null || endColumnName == null) break block14;
                boolean start = false;
                colspecs = this.colspecInfosMap.keySet();
                for (CALSColSpec colspec : colspecs) {
                    if (startColumnName.equals(colspec.getColumnName())) {
                        start = true;
                    }
                    if (start) {
                        WidthRepresentation colWidth = colspec.getColWidth();
                        WidthRepresentation widthRepresentation = colWidth = colWidth == null ? DEFAULT_WIDTH_REPRESENTATION : colWidth;
                        if (colspec.getAlign() != null && colWidth == DEFAULT_WIDTH_REPRESENTATION) {
                            colWidth = new WidthRepresentation(0.0f, null, 1.0f, false){

                                public boolean isSpecified() {
                                    return false;
                                }
                            };
                            colWidth.setAlign(colspec.getAlign());
                        }
                        if (toReturn == null) {
                            toReturn = new ArrayList();
                        }
                        toReturn.add(colWidth);
                    }
                    if (!endColumnName.equals(colspec.getColumnName())) continue;
                    break block13;
                }
                break block13;
            }
            if (colNumberStart < 0) break block13;
            int columnNumber = colNumberStart + 1;
            colspecs = this.colspecInfosMap.keySet();
            for (CALSColSpec colspec : colspecs) {
                if (colspec.getColumnNumber() != columnNumber) continue;
                WidthRepresentation colWidth = colspec.getColWidth();
                WidthRepresentation widthRepresentation = colWidth = colWidth == null ? DEFAULT_WIDTH_REPRESENTATION : colWidth;
                if (colspec.getAlign() != null && colWidth == DEFAULT_WIDTH_REPRESENTATION) {
                    colWidth = new WidthRepresentation(0.0f, null, 1.0f, false){

                        public boolean isSpecified() {
                            return false;
                        }
                    };
                    colWidth.setAlign(colspec.getAlign());
                }
                if (toReturn == null) {
                    toReturn = new ArrayList<WidthRepresentation>();
                }
                toReturn.add(colWidth);
            }
        }
        return toReturn;
    }

    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] colWidths, String tableCellsTagName) throws AuthorOperationException {
        if (this.isTableCell(tableCellsTagName) && colWidths != null && authorDocumentController != null && this.tableElement != null) {
            int currentOffset = this.tableElement.getStartOffset() + 1;
            try {
                for (int i = 0; i < colWidths.length; ++i) {
                    WidthRepresentation colWidth = colWidths[i];
                    int colNumber = i + 1;
                    CALSColSpec colSpec = this.getColSpec(colNumber);
                    AuthorElement currentElem = null;
                    if (colSpec == null) {
                        String colname = this.getUniqueColumnName(colNumber);
                        colSpec = new CALSColSpec(i, colNumber, true, colname, colWidth);
                        String xmlFragment = colSpec.createXMLFragment(this.tableElement.getNamespace());
                        authorDocumentController.insertXMLFragment(xmlFragment, currentOffset);
                        currentElem = (AuthorElement)authorDocumentController.getNodeAtOffset(currentOffset + 1);
                        this.colspecInfosMap.put(colSpec, currentElem);
                    } else {
                        colSpec.setColWidth(colWidth);
                        String strRepresentation = colWidth.getWidthRepresentation();
                        AttrValue val = null;
                        if (strRepresentation != null) {
                            val = new AttrValue(colWidth.getWidthRepresentation());
                        }
                        currentElem = this.colspecInfosMap.get(colSpec);
                        authorDocumentController.setAttribute("colwidth", val, currentElem);
                    }
                    currentOffset = currentElem.getEndOffset() + 1;
                }
            }
            catch (AuthorOperationException e) {
                throw e;
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected boolean isTableCell(String tableCellsTagName) {
        return CALS_DOCBOOK_CELL_NAME.equalsIgnoreCase(tableCellsTagName);
    }

    private String getUniqueColumnName(int colNumber) {
        Set<CALSColSpec> colSpecs = this.getColSpecs();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (CALSColSpec colSpec : colSpecs) {
            String columnName = colSpec.getColumnName();
            if (columnName == null) continue;
            columnNames.add(columnName);
        }
        StringBuilder columnName = new StringBuilder();
        columnName.append(COLSPEC_NAME_PREFIX).append(colNumber);
        boolean isUnique = false;
        while (!isUnique) {
            if (columnNames.contains(columnName.toString())) {
                columnName.append(colNumber);
                continue;
            }
            isUnique = true;
        }
        return columnName.toString();
    }

    private AuthorElement getTableElement() {
        AuthorElement tblElem = this.tableElement;
        if (tblElem != null) {
            while (!"table".equalsIgnoreCase(tblElem.getLocalName())) {
                AuthorNode parent = tblElem.getParent();
                if (parent instanceof AuthorElement) {
                    tblElem = (AuthorElement)parent;
                    continue;
                }
                tblElem = null;
                break;
            }
        }
        return tblElem;
    }

    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int newTableWidth, String tableCellsTagName) throws AuthorOperationException {
        if (this.isTableCell(tableCellsTagName)) {
            AuthorElement tblElem = this.getTableElement();
            if (newTableWidth > 0 && authorDocumentController != null) {
                if (tblElem != null) {
                    String newWidth = String.valueOf(newTableWidth);
                    authorDocumentController.setAttribute("width", new AttrValue(newWidth), tblElem);
                } else {
                    throw new AuthorOperationException("Cannot find the element representing the table.");
                }
            }
        }
    }

    public WidthRepresentation getTableWidth(String tableCellsTagName) {
        WidthRepresentation toReturn = null;
        if (this.isTableCell(tableCellsTagName)) {
            toReturn = this.getTableWidth();
        }
        return toReturn;
    }

    public boolean isTableAcceptingWidth(String tableCellsTagName) {
        return false;
    }

    private WidthRepresentation getTableWidth() {
        String widthAttr;
        WidthRepresentation toReturn = null;
        AuthorElement tblElem = this.getTableElement();
        if (tblElem != null && (widthAttr = CALSTableCellInfoProvider.getAttributeValue(tblElem, "width")) != null) {
            toReturn = new WidthRepresentation(widthAttr, true);
        }
        return toReturn;
    }

    public boolean isTableAndColumnsResizable(String tableCellsTagName) {
        return this.isTableCell(tableCellsTagName);
    }

    public boolean isAcceptingFixedColumnWidths(String tableCellsTagName) {
        return this.isTableCell(tableCellsTagName);
    }

    public boolean isAcceptingPercentageColumnWidths(String tableCellsTagName) {
        return false;
    }

    public boolean isAcceptingProportionalColumnWidths(String tableCellsTagName) {
        return this.isTableCell(tableCellsTagName);
    }

    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        String colNumAttrVal;
        ArrayList<WidthRepresentation> toReturn = new ArrayList<WidthRepresentation>();
        for (CALSColSpec cs : this.colspecInfosMap.keySet()) {
            WidthRepresentation cw = cs.getColWidth();
            if (cw != null) {
                toReturn.add(cw);
                continue;
            }
            toReturn.add(new WidthRepresentation(0.0f, null, 1.0f, false));
        }
        AuthorElement tblElem = this.getTableElement();
        if (tblElem != null && (colNumAttrVal = CALSTableCellInfoProvider.getAttributeValue(tblElem, "colnum")) != null) {
            try {
                int colNum = NumberParserUtil.parseInt((String)colNumAttrVal);
                int delta = colNum - toReturn.size();
                if (delta > 0) {
                    for (int i = 0; i < delta; ++i) {
                        toReturn.add(new WidthRepresentation(0.0f, null, 1.0f, false));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return toReturn;
    }

    public boolean getColSep(AuthorElement cellElem, int columnIndex) {
        CALSColSpec colspec;
        Boolean[] desc = this.getColSepOrRowSepFromAttributes(cellElem, true);
        Boolean colsep = desc[0];
        Boolean colsepFromTable = desc[1];
        if ((colsep == null || colsepFromTable.booleanValue()) && (colspec = this.getColumnSpec(cellElem, columnIndex)) != null && colspec.getColSep() != null) {
            colsep = colspec.getColSep();
        }
        if (colsep == null) {
            colsep = this.colsepAndRowSepAreVisibleByDefault;
        }
        return colsep;
    }

    public boolean getRowSep(AuthorElement cellElem, int columnIndex) {
        CALSColSpec colspec;
        Boolean[] desc = this.getColSepOrRowSepFromAttributes(cellElem, false);
        Boolean rowsep = desc[0];
        Boolean rowsepFromTable = desc[1];
        if ((rowsep == null || rowsepFromTable.booleanValue()) && (colspec = this.getColumnSpec(cellElem, columnIndex)) != null && colspec.getRowSep() != null) {
            rowsep = colspec.getRowSep();
        }
        if (rowsep == null) {
            rowsep = this.colsepAndRowSepAreVisibleByDefault;
        }
        return rowsep;
    }

    private Boolean[] getColSepOrRowSepFromAttributes(AuthorElement cellElem, boolean needingColSep) {
        Boolean separator = null;
        boolean fromTable = false;
        AuthorElement current = cellElem;
        while (current instanceof AuthorElement) {
            AuthorElement element = current;
            boolean isTableElement = this.isTableElement(element);
            boolean isTgroupElement = this.isTgroupElement(element);
            String attr = needingColSep ? CALSTableCellInfoProvider.getAttributeValue(element, "colsep") : CALSTableCellInfoProvider.getAttributeValue(element, "rowsep");
            if (attr != null) {
                separator = "1".equals(attr);
                fromTable = isTableElement || isTgroupElement;
                break;
            }
            if (isTableElement) break;
            current = current.getParent();
        }
        return new Boolean[]{separator, fromTable};
    }

    protected boolean isTableElement(AuthorElement element) {
        return element == this.tableElement.getParent() || "table".equalsIgnoreCase(element.getLocalName());
    }

    protected boolean isTgroupElement(AuthorElement element) {
        return "tgroup".equalsIgnoreCase(element.getLocalName());
    }

    private static String getAttributeValue(AuthorElement elem, String attributeName) {
        String toRet = null;
        AttrValue valAttr = elem.getAttribute(attributeName);
        if (valAttr != null) {
            toRet = valAttr.getValue();
        } else {
            valAttr = elem.getAttribute(attributeName.toUpperCase());
            if (valAttr != null) {
                toRet = valAttr.getValue();
            }
        }
        return toRet;
    }

    private static class ColspecComparator
    implements Comparator {
        private ColspecComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            int compRes = -1;
            if (obj1 instanceof CALSColSpec && obj2 instanceof CALSColSpec) {
                CALSColSpec colSpec1 = (CALSColSpec)obj1;
                CALSColSpec colSpec2 = (CALSColSpec)obj2;
                compRes = colSpec1.getColumnNumber() - colSpec2.getColumnNumber();
            }
            return compRes;
        }
    }
}

