/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.WidthRepresentation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSColSpec {
    private int colNumber;
    private String colName;
    private WidthRepresentation colWidth;
    private final boolean colNumberSpecified;
    private final int indexInDocument;
    private String align;
    private Boolean colSep;
    private Boolean rowSep;

    public Boolean getColSep() {
        return this.colSep;
    }

    public Boolean getRowSep() {
        return this.rowSep;
    }

    public CALSColSpec(int indexInDocument, int colNumber, boolean colNumberSpecified, String colName, String colWidth, Boolean colSep, Boolean rowSep) {
        this.indexInDocument = indexInDocument;
        this.colNumber = colNumber;
        this.colNumberSpecified = colNumberSpecified;
        this.colName = colName;
        if (colWidth != null) {
            this.colWidth = new WidthRepresentation(colWidth, false);
        }
        this.colSep = colSep;
        this.rowSep = rowSep;
    }

    public CALSColSpec(int indexInDocument, int colNumber, boolean colNumberSpecified, String colName, WidthRepresentation colWidth) {
        this.indexInDocument = indexInDocument;
        this.colNumber = colNumber;
        this.colNumberSpecified = colNumberSpecified;
        this.colName = colName;
        this.colWidth = colWidth;
    }

    public boolean isColNumberSpecified() {
        return this.colNumberSpecified;
    }

    public int getIndexInDocument() {
        return this.indexInDocument;
    }

    public int getColumnNumber() {
        return this.colNumber;
    }

    public String getColumnName() {
        return this.colName;
    }

    public WidthRepresentation getColWidth() {
        return this.colWidth;
    }

    public String toString() {
        String width = this.colWidth != null ? " width: " + this.colWidth : "";
        return this.getColumnName() + " at index: " + this.getColumnNumber() + width;
    }

    public String createXMLFragment(String ns) {
        StringBuilder fragment = new StringBuilder("<colspec");
        if (this.colNumber > 0) {
            fragment.append(" colnum=\"").append(this.colNumber).append('\"');
        }
        CALSColSpec.appendAttrWithValue(fragment, "colname", this.colName, true);
        if (this.colWidth != null) {
            String colWidthRepresentation = this.colWidth.getWidthRepresentation();
            CALSColSpec.appendAttrWithValue(fragment, "colwidth", colWidthRepresentation, true);
        }
        CALSColSpec.appendAttrWithValue(fragment, "xmlns", ns, false);
        fragment.append("/>");
        return fragment.toString();
    }

    private static void appendAttrWithValue(StringBuilder buffer, String attrName, String attrValue, boolean allowEmptyValue) {
        if (attrValue != null && (allowEmptyValue || !attrValue.isEmpty())) {
            buffer.append(' ').append(attrName).append("=\"").append(attrValue).append('\"');
        }
    }

    public void setColWidth(WidthRepresentation colWidth) {
        this.colWidth = colWidth;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
        if (this.colWidth != null) {
            this.colWidth.setAlign(align);
        }
    }
}

