/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class JoinRowCellsOperationBase
extends AbstractTableOperation {
    public JoinRowCellsOperationBase(AuthorTableHelper tableHelper) {
        super(tableHelper);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        block14: {
            try {
                AuthorElement firstCell = null;
                AuthorElement lastCell = null;
                if (authorAccess.getEditorAccess().hasSelection()) {
                    int start = authorAccess.getEditorAccess().getSelectionStart();
                    int end = authorAccess.getEditorAccess().getSelectionEnd();
                    AuthorNode fullySelectedNode = authorAccess.getEditorAccess().getFullySelectedNode();
                    if (fullySelectedNode != null && fullySelectedNode.getStartOffset() < fullySelectedNode.getEndOffset() && this.tableHelper.isTableRow(fullySelectedNode)) {
                        ++start;
                        --end;
                    }
                    firstCell = this.getCell(authorAccess, start, true);
                    lastCell = this.getCell(authorAccess, end, false);
                } else {
                    AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
                    if (this.tableHelper.isTableRow(nodeAtCaret)) {
                        AuthorNode nodeAfterCaret;
                        AuthorNode nodeBeforeCaret = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() - 1);
                        if (this.tableHelper.isTableCell(nodeBeforeCaret)) {
                            firstCell = (AuthorElement)nodeBeforeCaret;
                        }
                        if (this.tableHelper.isTableCell(nodeAfterCaret = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() + 1))) {
                            lastCell = (AuthorElement)nodeAfterCaret;
                        }
                    }
                }
                if (firstCell != null && lastCell != null && firstCell != lastCell) {
                    AuthorElement endSelTableRow;
                    AuthorElement startSelTableRow = (AuthorElement)firstCell.getParent();
                    if (startSelTableRow == (endSelTableRow = (AuthorElement)lastCell.getParent())) {
                        AuthorElement tgroupElement = this.getElementAncestor((AuthorNode)startSelTableRow, 2);
                        if (tgroupElement != null) {
                            AuthorTableCellSpanProvider tableSupport = this.tableHelper.getTableCellSpanProvider(tgroupElement);
                            if (!tableSupport.hasColumnSpecifications(tgroupElement) && authorAccess.getWorkspaceAccess().showConfirmDialog("Column specifications", "Join cells operation requires column specifications. Do you want to generate them?", new String[]{"Yes", "No"}, new int[]{1, 0}) == 1) {
                                this.generateColumnSpecifications(authorAccess, tableSupport, tgroupElement);
                            }
                            this.tableHelper.checkTableColSpanIsDefined(authorAccess, tableSupport, firstCell);
                            this.tableHelper.checkTableColSpanIsDefined(authorAccess, tableSupport, lastCell);
                            List sourceCells = this.getCellsBetweenOffsets(startSelTableRow, firstCell.getEndOffset() + 1, lastCell.getEndOffset());
                            AuthorElement destinationTableCell = firstCell;
                            this.checkForSameRowSpan(tableSupport, destinationTableCell, sourceCells);
                            this.updateColSpanForMergedCell(authorAccess, tableSupport, destinationTableCell, sourceCells);
                            int nodesCount = sourceCells.size();
                            for (int i = 0; i < nodesCount; ++i) {
                                AuthorElement cell = (AuthorElement)sourceCells.get(i);
                                AuthorDocumentFragment fragmentToMove = null;
                                if (cell.getEndOffset() - cell.getStartOffset() > 1) {
                                    fragmentToMove = authorAccess.getDocumentController().createDocumentFragment(cell.getStartOffset() + 1, cell.getEndOffset() - 1);
                                }
                                authorAccess.getDocumentController().deleteNode((AuthorNode)cell);
                                if (fragmentToMove == null) continue;
                                authorAccess.getDocumentController().insertFragment(destinationTableCell.getEndOffset(), fragmentToMove);
                            }
                            authorAccess.getEditorAccess().setCaretPosition(destinationTableCell.getEndOffset());
                        }
                        break block14;
                    }
                    AuthorOperationException ex = new AuthorOperationException("The selected cells must be from the same table row.");
                    ex.setOperationRejectedOnPurpose(true);
                    throw ex;
                }
                AuthorOperationException ex = new AuthorOperationException("The operation is enabled only when there is a selection that contains at least two cells from the same row of a table or when the caret is positioned between two horizontally adjacent cells.");
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("Operation failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkForSameRowSpan(AuthorTableCellSpanProvider tableSupport, AuthorElement destinationCell, List sourceCells) throws AuthorOperationException {
        Integer rowSpan = tableSupport.getRowSpan(destinationCell);
        int rSpan = rowSpan != null ? rowSpan : 1;
        for (AuthorElement currentCell : sourceCells) {
            Integer currentRowSpan = tableSupport.getRowSpan(currentCell);
            int currentRSpan = currentRowSpan != null ? currentRowSpan : 1;
            if (rSpan == currentRSpan) continue;
            AuthorOperationException ex = new AuthorOperationException("Join operation is possible only for cells with the same row span.");
            ex.setOperationRejectedOnPurpose(true);
            throw ex;
        }
    }

    protected AuthorElement getCell(AuthorAccess authorAccess, int selectionOffset, boolean start) throws BadLocationException {
        AuthorElement cellElement = null;
        AuthorNode endSelNode = authorAccess.getDocumentController().getNodeAtOffset(selectionOffset);
        if (this.tableHelper.isTableRow(endSelNode)) {
            AuthorNode node = authorAccess.getDocumentController().getNodeAtOffset(start ? selectionOffset + 1 : selectionOffset - 1);
            if (this.tableHelper.isTableCell(node)) {
                cellElement = (AuthorElement)node;
            }
        } else {
            cellElement = this.getElementAncestor(endSelNode, 0);
        }
        return cellElement;
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Join the content of the selected cells. The operation is available only if the selected cells are from the same row and they have the same column span.";
    }

    private List getCellsBetweenOffsets(AuthorElement rowNode, int startOffset, int endOffset) {
        ArrayList<AuthorNode> cells = new ArrayList<AuthorNode>();
        List contentNodes = rowNode.getContentNodes();
        for (AuthorNode node : contentNodes) {
            if (!(node.getStartOffset() <= startOffset && node.getEndOffset() >= startOffset || node.getStartOffset() > startOffset && node.getEndOffset() < endOffset) && (node.getStartOffset() > endOffset || node.getEndOffset() < endOffset) || !this.tableHelper.isTableCell(node)) continue;
            cells.add(node);
        }
        return cells;
    }

    private void updateColSpanForMergedCell(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableCellSpanProvider, AuthorElement destCellElement, List sourceCells) throws AuthorOperationException {
        int[] destCellColSpanIndices = authorAccess.getTableAccess().getTableColSpanIndices(destCellElement);
        AuthorElement lastElem = (AuthorElement)sourceCells.get(sourceCells.size() - 1);
        int[] endCellColSpanIndices = authorAccess.getTableAccess().getTableColSpanIndices(lastElem);
        this.tableHelper.updateTableColSpan(authorAccess, tableCellSpanProvider, destCellElement, destCellColSpanIndices[0] + 1, endCellColSpanIndices[1] + 1);
    }

    protected abstract void generateColumnSpecifications(AuthorAccess var1, AuthorTableCellSpanProvider var2, AuthorElement var3) throws AuthorOperationException;
}

