/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.AuthorBlockMover;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class MoveBlockAuthorOperation
implements AuthorOperation {
    private static final String DIRECTION = "direction";
    private static final Logger logger = LoggerFactory.getLogger((String)MoveBlockAuthorOperation.class.getName());

    public String getDescription() {
        return "Move the current block element containing the caret offset or the current selected block elements up or down.";
    }

    private boolean isMoveUp(ArgumentsMap args) {
        String dir = (String)args.getArgumentValue(DIRECTION);
        return "up".equalsIgnoreCase(dir);
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        AuthorBlockMover blockMover = new AuthorBlockMover(authorAccess);
        try {
            blockMover.moveBlock(this.isMoveUp(args));
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor(DIRECTION, 3, "Move direction can have values \"up\" or \"down\"", new String[]{"up", "down"}, "up")};
    }
}

