/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.AuthorUtilAccess;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class ObjectChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ObjectChooser.class.getName());
    public static final String[] ALLOWED_IMAGE_EXTENSIONS = new String[]{"gif", "jpg", "jpeg", "bmp", "png", "svg", "svgz", "wmf", "mathml", "mml", "cgm", "tif", "tiff", "eps", "ai", "pdf", "psd"};

    public static String makeUrlRelative(AuthorAccess authorAccess, String url) {
        String filePath;
        AuthorUtilAccess util = authorAccess.getUtilAccess();
        try {
            URL baseURL = ObjectChooser.getBaseURL(authorAccess);
            filePath = authorAccess.getXMLUtilAccess().escapeAttributeValue(util.makeRelative(baseURL, util.removeUserCredentials(new URL(url))));
        }
        catch (MalformedURLException e1) {
            filePath = url;
        }
        return filePath;
    }

    private static URL getBaseURL(AuthorAccess authorAccess) {
        URL baseURL = authorAccess.getEditorAccess().getEditorLocation();
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        try {
            AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            if (nodeAtOffset != null) {
                baseURL = nodeAtOffset.getXMLBaseURL();
            }
        }
        catch (BadLocationException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return baseURL;
    }
}

