/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.link.ElementLocator;
import ro.sync.ecss.extensions.api.link.ElementLocatorException;
import ro.sync.ecss.extensions.api.link.ElementLocatorProvider;
import ro.sync.ecss.extensions.api.link.IDTypeVerifier;
import ro.sync.ecss.extensions.commons.IDElementLocator;
import ro.sync.ecss.extensions.commons.XPointerElementLocator;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DefaultElementLocatorProvider
implements ElementLocatorProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)DefaultElementLocatorProvider.class.getName());

    public ElementLocator getElementLocator(IDTypeVerifier idVerifier, String link) {
        ElementLocator elementLocator = null;
        try {
            elementLocator = link.startsWith("element(") ? new XPointerElementLocator(idVerifier, link) : new IDElementLocator(idVerifier, link);
        }
        catch (ElementLocatorException e) {
            logger.warn("Exception when create element locator for link: " + link + ". Cause: " + e, (Throwable)e);
        }
        return elementLocator;
    }

    public String getDescription() {
        return "Default implementation for locating elements based on a given link.\nThe following cases are covered: XInclude element scheme and ID based links.";
    }
}

