/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.ErrorExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeListExpression;
import com.icl.saxon.expr.SortedSelection;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.StyleSheetFunctionCall;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.GeneralOutputter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.NoNodeTest;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.style.ExpressionContext;
import com.icl.saxon.style.LocatorProxy;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleException;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.style.TerminationException;
import com.icl.saxon.style.XSLAttributeSet;
import com.icl.saxon.style.XSLFallback;
import com.icl.saxon.style.XSLSort;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ElementWithAttributes;
import com.icl.saxon.tree.NodeImpl;
import java.lang.invoke.CallSite;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.xml.sax.Locator;

public abstract class StyleElement
extends ElementWithAttributes
implements Locator {
    protected Vector attributeSets = null;
    protected short[] extensionNamespaces = null;
    private short[] excludedNamespaces = null;
    protected String version = null;
    protected StaticContext staticContext = null;
    protected TransformerConfigurationException validationError = null;
    protected int reportingCircumstances = 1;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;

    public void substituteFor(StyleElement temp) {
        this.parent = temp.parent;
        this.attributeList = temp.attributeList;
        this.namespaceList = temp.namespaceList;
        this.nameCode = temp.nameCode;
        this.sequence = temp.sequence;
        this.attributeSets = temp.attributeSets;
        this.extensionNamespaces = temp.extensionNamespaces;
        this.excludedNamespaces = temp.excludedNamespaces;
        this.version = temp.version;
        this.root = temp.root;
        this.staticContext = temp.staticContext;
        this.validationError = temp.validationError;
        this.reportingCircumstances = temp.reportingCircumstances;
    }

    protected void setValidationError(TransformerException reason, int circumstances) {
        this.validationError = reason instanceof TransformerConfigurationException ? (TransformerConfigurationException)reason : new TransformerConfigurationException(reason);
        this.reportingCircumstances = circumstances;
    }

    public boolean isInstruction() {
        return false;
    }

    public boolean doesPostProcessing() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return false;
    }

    public XSLStyleSheet getContainingStyleSheet() {
        NodeImpl next = this;
        while (!(next instanceof XSLStyleSheet)) {
            next = (NodeImpl)next.getParent();
        }
        return (XSLStyleSheet)next;
    }

    public int getPrecedence() {
        return this.getContainingStyleSheet().getPrecedence();
    }

    public final StandardNames getStandardNames() {
        DocumentImpl root = (DocumentImpl)this.getDocumentRoot();
        return ((StyleNodeFactory)root.getNodeFactory()).getStandardNames();
    }

    public void processAllAttributes() throws TransformerConfigurationException {
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        for (NodeImpl child = (NodeImpl)this.getFirstChild(); child != null; child = (NodeImpl)child.getNextSibling()) {
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).processAllAttributes();
        }
    }

    public final void processAttributes() throws TransformerConfigurationException {
        try {
            this.prepareAttributes();
        }
        catch (TransformerConfigurationException err) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.setValidationError(err, 2);
            }
            this.compileError(err);
        }
    }

    protected void checkUnknownAttribute(int nc) throws TransformerConfigurationException {
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        String attributeURI = this.getNamePool().getURI(nc);
        String elementURI = this.getURI();
        int attributeFingerprint = nc & 0xFFFFF;
        StandardNames sn = this.getStandardNames();
        if (this.isInstruction() && attributeURI.equals("http://www.w3.org/1999/XSL/Transform") && !elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (attributeFingerprint == sn.XSL_EXTENSION_ELEMENT_PREFIXES || attributeFingerprint == sn.XSL_EXCLUDE_RESULT_PREFIXES || attributeFingerprint == sn.XSL_VERSION)) {
            return;
        }
        if (attributeURI.equals("") || attributeURI.equals("http://www.w3.org/1999/XSL/Transform")) {
            this.compileError("Attribute " + this.getNamePool().getDisplayName(nc) + " is not allowed on this element");
        }
    }

    public abstract void prepareAttributes() throws TransformerConfigurationException;

    public Expression makeExpression(String expression) throws TransformerConfigurationException {
        try {
            return Expression.make(expression, this.staticContext);
        }
        catch (XPathException err) {
            this.compileError(err);
            return new ErrorExpression(err);
        }
    }

    public Pattern makePattern(String pattern) throws TransformerConfigurationException {
        try {
            return Pattern.make(pattern, this.staticContext);
        }
        catch (XPathException err) {
            this.compileError(err);
            return NoNodeTest.getInstance();
        }
    }

    public Expression makeAttributeValueTemplate(String expression) throws TransformerConfigurationException {
        try {
            return AttributeValueTemplate.make(expression, this.staticContext);
        }
        catch (XPathException err) {
            this.compileError(err);
            return new StringValue(expression);
        }
    }

    protected void processExtensionElementAttribute(int nc) throws TransformerConfigurationException {
        String ext = this.getAttributeValue(nc & 0xFFFFF);
        if (ext != null) {
            int count = 0;
            StringTokenizer st1 = new StringTokenizer(ext);
            while (st1.hasMoreTokens()) {
                st1.nextToken();
                ++count;
            }
            this.extensionNamespaces = new short[count];
            count = 0;
            StringTokenizer st2 = new StringTokenizer(ext);
            while (st2.hasMoreTokens()) {
                String s = st2.nextToken();
                if (s.equals("#default")) {
                    s = "";
                }
                try {
                    short uriCode = this.getURICodeForPrefix(s);
                    this.extensionNamespaces[count++] = uriCode;
                }
                catch (NamespaceException err) {
                    this.extensionNamespaces = null;
                    this.compileError(err.getMessage());
                }
            }
        }
    }

    protected void processExcludedNamespaces(int nc) throws TransformerConfigurationException {
        String ext = this.getAttributeValue(nc & 0xFFFFF);
        if (ext != null) {
            int count = 0;
            StringTokenizer st1 = new StringTokenizer(ext);
            while (st1.hasMoreTokens()) {
                st1.nextToken();
                ++count;
            }
            this.excludedNamespaces = new short[count];
            count = 0;
            StringTokenizer st2 = new StringTokenizer(ext);
            while (st2.hasMoreTokens()) {
                String s = st2.nextToken();
                if (s.equals("#default")) {
                    s = "";
                }
                try {
                    short uriCode = this.getURICodeForPrefix(s);
                    this.excludedNamespaces[count++] = uriCode;
                }
                catch (NamespaceException err) {
                    this.excludedNamespaces = null;
                    this.compileError(err.getMessage());
                }
            }
        }
    }

    protected void processVersionAttribute(int nc) {
        this.version = this.getAttributeValue(nc & 0xFFFFF);
    }

    public String getVersion() {
        if (this.version == null) {
            NodeInfo node = (NodeInfo)((Object)this.getParentNode());
            this.version = node instanceof StyleElement ? ((StyleElement)node).getVersion() : "1.0";
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return !this.getVersion().equals("1.0");
    }

    protected boolean definesExtensionElement(short uriCode) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.extensionNamespaces.length; ++i) {
            if (this.extensionNamespaces[i] != uriCode) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(short uriCode) {
        NodeImpl anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExtensionElement(uriCode)) {
                return true;
            }
            anc = (NodeImpl)anc.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(short uriCode) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.excludedNamespaces.length; ++i) {
            if (this.excludedNamespaces[i] != uriCode) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(short uriCode) {
        if (uriCode == 2) {
            return true;
        }
        if (this.isExtensionNamespace(uriCode)) {
            return true;
        }
        NodeImpl anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExcludedNamespace(uriCode)) {
                return true;
            }
            anc = (NodeImpl)anc.getParent();
        }
        return false;
    }

    public void validate() throws TransformerConfigurationException {
    }

    public void preprocess() throws TransformerConfigurationException {
    }

    public void validateSubtree() throws TransformerConfigurationException {
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            }
        } else {
            try {
                this.validate();
            }
            catch (TransformerConfigurationException err) {
                if (this.forwardsCompatibleModeIsEnabled()) {
                    this.setValidationError(err, 3);
                }
                this.compileError(err);
            }
            this.validateChildren();
        }
    }

    protected void validateChildren() throws TransformerConfigurationException {
        for (NodeImpl child = (NodeImpl)this.getFirstChild(); child != null; child = (NodeImpl)child.getNextSibling()) {
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).validateSubtree();
        }
    }

    protected XSLStyleSheet getPrincipalStyleSheet() {
        XSLStyleSheet sheet = this.getContainingStyleSheet();
        XSLStyleSheet next;
        while ((next = sheet.getImporter()) != null) {
            sheet = next;
        }
        return sheet;
    }

    public PreparedStyleSheet getPreparedStyleSheet() {
        return this.getPrincipalStyleSheet().getPreparedStyleSheet();
    }

    public void checkWithinTemplate() throws TransformerConfigurationException {
        StyleElement parent = (StyleElement)this.getParentNode();
        if (!parent.mayContainTemplateBody()) {
            this.compileError("Element must only be used within a template body");
        }
    }

    public void checkTopLevel() throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof XSLStyleSheet)) {
            this.compileError("Element must only be used at top level of stylesheet");
        }
    }

    public void checkNotTopLevel() throws TransformerConfigurationException {
        if (this.getParentNode() instanceof XSLStyleSheet) {
            this.compileError("Element must not be used at top level of stylesheet");
        }
    }

    public void checkEmpty() throws TransformerConfigurationException {
        if (this.getFirstChild() != null) {
            this.compileError("Element must be empty");
        }
    }

    public void reportAbsence(String attribute) throws TransformerConfigurationException {
        this.compileError("Element must have a \"" + attribute + "\" attribute");
    }

    public abstract void process(Context var1) throws TransformerException;

    public void processChildren(Context context) throws TransformerException {
        if (context.getController().isTracing()) {
            TraceListener tracelistener = context.getController().getTraceListener();
            for (NodeImpl nodeimpl1 = (NodeImpl)this.getFirstChild(); nodeimpl1 != null; nodeimpl1 = (NodeImpl)nodeimpl1.getNextSibling()) {
                tracelistener.enter(nodeimpl1, context);
                if (nodeimpl1.getNodeType() == 3) {
                    Outputter outputter = context.getOutputter();
                    if (outputter != null && outputter instanceof GeneralOutputter) {
                        ((GeneralOutputter)outputter).setCurrentLocator(new LocatorProxy(nodeimpl1));
                    }
                    nodeimpl1.copy(context.getOutputter());
                } else if (nodeimpl1 instanceof StyleElement) {
                    StyleElement styleelement1 = (StyleElement)nodeimpl1;
                    if (styleelement1.validationError != null) {
                        this.fallbackProcessing(styleelement1, context);
                    } else {
                        try {
                            context.setStaticContext(styleelement1.staticContext);
                            Outputter outputter = context.getOutputter();
                            if (outputter != null && outputter instanceof GeneralOutputter) {
                                ((GeneralOutputter)outputter).setCurrentLocator(new LocatorProxy(styleelement1));
                            }
                            styleelement1.process(context);
                        }
                        catch (TransformerException transformerexception1) {
                            throw styleelement1.styleError(transformerexception1);
                        }
                    }
                }
                tracelistener.leave(nodeimpl1, context);
            }
        } else {
            for (NodeImpl nodeimpl = (NodeImpl)this.getFirstChild(); nodeimpl != null; nodeimpl = (NodeImpl)nodeimpl.getNextSibling()) {
                if (nodeimpl.getNodeType() == 3) {
                    nodeimpl.copy(context.getOutputter());
                    continue;
                }
                if (!(nodeimpl instanceof StyleElement)) continue;
                StyleElement styleelement = (StyleElement)nodeimpl;
                if (styleelement.validationError != null) {
                    this.fallbackProcessing(styleelement, context);
                    continue;
                }
                try {
                    context.setStaticContext(styleelement.staticContext);
                    styleelement.process(context);
                    continue;
                }
                catch (TransformerException transformerexception) {
                    throw styleelement.styleError(transformerexception);
                }
            }
        }
    }

    protected void fallbackProcessing(StyleElement instruction, Context context) throws TransformerException {
        Node child;
        XSLFallback fallback = null;
        for (child = instruction.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XSLFallback)) continue;
            fallback = (XSLFallback)child;
            break;
        }
        if (fallback == null) {
            throw instruction.styleError(instruction.validationError);
        }
        boolean tracing = context.getController().isTracing();
        while (child != null) {
            if (child instanceof XSLFallback) {
                XSLFallback f = (XSLFallback)child;
                if (tracing) {
                    TraceListener listener = context.getController().getTraceListener();
                    listener.enter(f, context);
                    f.process(context);
                    listener.leave(f, context);
                } else {
                    f.process(context);
                }
            }
            child = child.getNextSibling();
        }
    }

    protected Expression handleSortKeys(Expression select) {
        Node child;
        int numberOfSortKeys = 0;
        for (child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XSLSort)) continue;
            ++numberOfSortKeys;
        }
        if (numberOfSortKeys > 0) {
            SortedSelection sortExpression = new SortedSelection(select, numberOfSortKeys);
            int k = 0;
            for (child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof XSLSort)) continue;
                sortExpression.setSortKey(((XSLSort)child).getSortKeyDefinition(), k++);
            }
            return sortExpression;
        }
        return new NodeListExpression(select);
    }

    protected void findAttributeSets(String use) throws TransformerConfigurationException {
        this.attributeSets = new Vector();
        XSLStyleSheet stylesheet = this.getPrincipalStyleSheet();
        Vector toplevel = stylesheet.getTopLevel();
        StringTokenizer st = new StringTokenizer(use);
        while (st.hasMoreTokens()) {
            int fprint;
            String asetname = st.nextToken();
            try {
                fprint = this.makeNameCode(asetname, false) & 0xFFFFF;
            }
            catch (NamespaceException err) {
                this.compileError(err.getMessage());
                fprint = -1;
            }
            boolean found = false;
            for (int i = 0; i < toplevel.size(); ++i) {
                XSLAttributeSet t;
                if (!(toplevel.elementAt(i) instanceof XSLAttributeSet) || (t = (XSLAttributeSet)toplevel.elementAt(i)).getAttributeSetFingerprint() != fprint) continue;
                this.attributeSets.addElement(t);
                found = true;
            }
            if (found) continue;
            this.compileError("No attribute-set exists named " + asetname);
        }
    }

    protected void processAttributeSets(Context context) throws TransformerException {
        if (this.attributeSets == null) {
            return;
        }
        Controller c = context.getController();
        for (int i = 0; i < this.attributeSets.size(); ++i) {
            XSLAttributeSet aset = (XSLAttributeSet)this.attributeSets.elementAt(i);
            Object isBeingExpanded = c.getUserData(aset, "is-being-expanded");
            if (isBeingExpanded != null) {
                throw this.styleError("Circular reference to attribute set");
            }
            c.setUserData(aset, "is-being-expanded", "is-being-expanded");
            aset.expand(context);
            c.setUserData(aset, "is-being-expanded", null);
        }
    }

    protected TransformerException styleError(TransformerException error) {
        if (error instanceof StyleException) {
            return error;
        }
        if (error instanceof TerminationException) {
            return error;
        }
        if (error.getLocator() == null) {
            return new TransformerException(error.getMessage(), this, error.getException());
        }
        return error;
    }

    protected TransformerException styleError(String message) {
        return new TransformerException(message, this);
    }

    protected void compileError(TransformerException error) throws TransformerConfigurationException {
        if (error.getLocator() == null) {
            error.setLocator(this);
        }
        PreparedStyleSheet pss = this.getPreparedStyleSheet();
        try {
            if (pss == null) {
                throw error;
            }
            pss.reportError(error);
        }
        catch (TransformerException err2) {
            if (err2 instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)err2;
            }
            if (err2.getException() instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)err2.getException();
            }
            TransformerConfigurationException tce = new TransformerConfigurationException(error);
            tce.setLocator(this);
            throw tce;
        }
    }

    protected void compileError(String message) throws TransformerConfigurationException {
        TransformerConfigurationException tce = new TransformerConfigurationException(message);
        tce.setLocator(this);
        this.compileError(tce);
    }

    public boolean isTopLevel() {
        return this.getParentNode() instanceof XSLStyleSheet;
    }

    public Binding bindVariable(int fingerprint) throws XPathException {
        Binding binding = this.getVariableBinding(fingerprint);
        if (binding == null) {
            throw new XPathException("Variable " + this.getNamePool().getDisplayName(fingerprint) + " has not been declared");
        }
        return binding;
    }

    public Binding getVariableBinding(int fprint) {
        block4: {
            NodeImpl curr = this;
            NodeImpl prev = this;
            if (!this.isTopLevel()) {
                int var;
                do {
                    for (curr = (NodeImpl)curr.getPreviousSibling(); curr == null; curr = (NodeImpl)curr.getPreviousSibling()) {
                        curr = (NodeImpl)prev.getParent();
                        prev = curr;
                        if (curr.getParent() instanceof XSLStyleSheet) break;
                    }
                    if (curr.getParent() instanceof XSLStyleSheet) break block4;
                } while (!(curr instanceof Binding) || (var = ((Binding)((Object)curr)).getVariableFingerprint()) != fprint);
                return (Binding)((Object)curr);
            }
        }
        XSLStyleSheet root = this.getPrincipalStyleSheet();
        Vector toplevel = root.getTopLevel();
        for (int i = toplevel.size() - 1; i >= 0; --i) {
            int var;
            Object child = toplevel.elementAt(i);
            if (!(child instanceof Binding) || child == this || (var = ((Binding)child).getVariableFingerprint()) != fprint) continue;
            return (Binding)child;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Enumeration[] getVariableNames() {
        local = new Hashtable<CallSite, CallSite>();
        global = new Hashtable<CallSite, CallSite>();
        curr = this;
        prev /* !! */  = this;
        pool = this.getNamePool();
        if (!this.isTopLevel()) {
            while (true) {
                for (curr = (NodeImpl)curr.getPreviousSibling(); curr == null; curr = (NodeImpl)curr.getPreviousSibling()) {
                    curr = (NodeImpl)prev /* !! */ .getParent();
                    prev /* !! */  = curr;
                    if (curr.getParent() instanceof XSLStyleSheet) break;
                }
                if (curr.getParentNode() instanceof XSLStyleSheet) break;
                if (!(curr instanceof Binding) || local.get(varname = (uri = pool.getURI(fprint = ((Binding)curr).getVariableFingerprint())) + "^" + (lname = pool.getLocalName(fprint))) != null) ** continue;
                local.put((CallSite)varname, (CallSite)varname);
            }
        }
        root = this.getPrincipalStyleSheet();
        toplevel = root.getTopLevel();
        for (i = 0; i < toplevel.size(); ++i) {
            child = toplevel.elementAt(i);
            if (!(child instanceof Binding) || child == this || local.get(varname = (uri = pool.getURI(fprint = ((Binding)child).getVariableFingerprint())) + "^" + (lname = pool.getLocalName(fprint))) != null) continue;
            global.put((CallSite)varname, (CallSite)varname);
        }
        info = new Enumeration[]{global.keys(), local.keys()};
        return info;
    }

    public Function getStyleSheetFunction(int fingerprint) {
        XSLStyleSheet root = this.getPrincipalStyleSheet();
        Vector toplevel = root.getTopLevel();
        for (int i = toplevel.size() - 1; i >= 0; --i) {
            Object child = toplevel.elementAt(i);
            if (!(child instanceof SAXONFunction) || ((SAXONFunction)child).getFunctionFingerprint() != fingerprint) continue;
            StyleSheetFunctionCall fc = new StyleSheetFunctionCall();
            fc.setFunction((SAXONFunction)child);
            return fc;
        }
        return null;
    }
}

