/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.oxygenxml.md.URLUtil;
import com.oxygenxml.md.backmapping.BackmappingDataContentHandler;
import com.oxygenxml.md.backmapping.ConversionContextProvider;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.AttributeImpl;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.HtmlAppendableBase;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.TagRange;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import nu.validator.htmlparser.sax.HtmlParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlWriter
extends HtmlAppendableBase<HtmlWriter> {
    @Nullable
    private NodeRendererContext context;
    @Nullable
    private AttributablePart useAttributes;
    private static final Logger logger = LoggerFactory.getLogger((String)HtmlWriter.class.getName());
    private static final String DATA_OXY_ELEMENT_LINE = "data-oxy-elementLine";
    private static final String DATA_OXY_ELEMENT_COLUMN = "data-oxy-elementColumn";
    private static final String DATA_OXY_ELEMENT_URI = "data-oxy-elementURI";

    public HtmlWriter(int indentSize, int formatOptions) {
        super(indentSize, formatOptions);
    }

    public HtmlWriter(HtmlWriter other, boolean inheritIndent) {
        super((LineAppendable)other, inheritIndent);
        this.context = other.context;
    }

    public HtmlWriter(int indentSize, int formatOptions, boolean suppressOpenTagLine, boolean suppressCloseTagLine) {
        this(null, indentSize, formatOptions, suppressOpenTagLine, suppressCloseTagLine);
    }

    public HtmlWriter(@Nullable Appendable appendable, int indentSize, int formatOptions, boolean suppressOpenTagLine, boolean suppressCloseTagLine) {
        super(appendable, indentSize, formatOptions);
        this.setSuppressOpenTagLine(suppressOpenTagLine);
        this.setSuppressCloseTagLine(suppressCloseTagLine);
    }

    void setContext(@NotNull NodeRendererContext context) {
        this.context = context;
    }

    @NotNull
    public NodeRendererContext getContext() {
        assert (this.context != null);
        return this.context;
    }

    @NotNull
    public HtmlWriter srcPos() {
        return this.context == null ? this : this.srcPos(this.context.getCurrentNode().getChars());
    }

    @NotNull
    public HtmlWriter srcPosWithEOL() {
        return this.context == null ? this : this.srcPosWithEOL(this.context.getCurrentNode().getChars());
    }

    @NotNull
    public HtmlWriter srcPosWithTrailingEOL() {
        return this.context == null ? this : this.srcPosWithTrailingEOL(this.context.getCurrentNode().getChars());
    }

    @NotNull
    public HtmlWriter srcPos(@NotNull BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            BasedSequence trimmed = (BasedSequence)sourceText.trimEOL();
            return this.srcPos(trimmed.getStartOffset(), trimmed.getEndOffset());
        }
        return this;
    }

    @NotNull
    public HtmlWriter srcPosWithEOL(@NotNull BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            return this.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset());
        }
        return this;
    }

    @NotNull
    public HtmlWriter srcPosWithTrailingEOL(@NotNull BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            char c;
            int endOffset;
            BasedSequence base = sourceText.getBaseSequence();
            for (endOffset = sourceText.getEndOffset(); endOffset < base.length() && ((c = base.charAt(endOffset)) == ' ' || c == '\t'); ++endOffset) {
            }
            if (endOffset < base.length() && base.charAt(endOffset) == '\r') {
                ++endOffset;
            }
            if (endOffset < base.length() && base.charAt(endOffset) == '\n') {
                ++endOffset;
            }
            return this.srcPos(sourceText.getStartOffset(), endOffset);
        }
        return this;
    }

    @NotNull
    public HtmlWriter srcPos(int startOffset, int endOffset) {
        if (startOffset <= endOffset && this.context != null && !this.context.getHtmlOptions().sourcePositionAttribute.isEmpty()) {
            super.attr((CharSequence)this.context.getHtmlOptions().sourcePositionAttribute, (CharSequence)(startOffset + "-" + endOffset));
        }
        return this;
    }

    @NotNull
    public HtmlWriter withAttr() {
        return this.withAttr(AttributablePart.NODE);
    }

    @NotNull
    public HtmlWriter withAttr(@NotNull AttributablePart part) {
        super.withAttr();
        this.useAttributes = part;
        return this;
    }

    @NotNull
    public HtmlWriter withAttr(@NotNull LinkStatus status) {
        this.attr("Link Status", status.getName());
        return this.withAttr(AttributablePart.LINK);
    }

    @NotNull
    public HtmlWriter withAttr(@NotNull ResolvedLink resolvedLink) {
        return this.withAttr(resolvedLink.getStatus());
    }

    @NotNull
    public HtmlWriter tag(@NotNull CharSequence tagName, boolean voidElement) {
        if (this.useAttributes != null) {
            String attributeValue;
            Attributes attributes;
            if (this.context != null) {
                attributes = this.context.extendRenderingNodeAttributes(this.useAttributes, this.getAttributes());
                String sourcePositionAttribute = this.context.getHtmlOptions().sourcePositionAttribute;
                attributeValue = attributes.getValue((CharSequence)sourcePositionAttribute);
            } else {
                attributeValue = "";
                attributes = new Attributes();
            }
            if (!attributeValue.isEmpty()) {
                int pos = attributeValue.indexOf(45);
                int startOffset = -1;
                int endOffset = -1;
                if (pos != -1) {
                    try {
                        startOffset = Integer.parseInt(attributeValue.substring(0, pos));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        endOffset = Integer.parseInt(attributeValue.substring(pos + 1));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (startOffset >= 0 && startOffset < endOffset) {
                    ArrayList tagRanges = (ArrayList)HtmlRenderer.TAG_RANGES.get((DataHolder)this.context.getDocument());
                    tagRanges.add(new TagRange(tagName, startOffset, endOffset));
                }
            }
            this.setAttributes(attributes);
            this.useAttributes = null;
        }
        this.writeLocationAttributes();
        super.tag(tagName, voidElement);
        return this;
    }

    public HtmlWriter rawPre(CharSequence s) {
        ConversionContextProvider.ConversionContext genContext = ConversionContextProvider.getInstance().get();
        if (logger.isDebugEnabled()) {
            logger.debug("Generation context: " + genContext);
        }
        if (genContext != null && genContext.embedBackmappingData) {
            try {
                Node currentNode = this.context.getCurrentNode();
                if (currentNode instanceof HtmlBlock || currentNode instanceof HtmlInline) {
                    HtmlParser parser = new HtmlParser();
                    StringWriter writer = new StringWriter();
                    TransformerHandler transformerHandler = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
                    transformerHandler.getTransformer().setOutputProperty("omit-xml-declaration", "true");
                    transformerHandler.getTransformer().setOutputProperty("method", "html");
                    transformerHandler.setResult(new StreamResult(writer));
                    parser.setContentHandler((ContentHandler)new BackmappingDataContentHandler(transformerHandler, currentNode.getLineNumber(), BackmappingDataContentHandler.AttrType.HTML, true));
                    InputSource source = new InputSource(new StringReader(s.toString()));
                    source.setSystemId(genContext.systemID);
                    transformerHandler.startDocument();
                    parser.parseFragment(source, "body");
                    s = writer.toString();
                }
            }
            catch (IOException | TransformerConfigurationException | SAXException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return (HtmlWriter)super.rawPre(s);
    }

    private void writeLocationAttributes() {
        ConversionContextProvider.ConversionContext genContext = ConversionContextProvider.getInstance().get();
        if (logger.isDebugEnabled()) {
            logger.debug("Context " + genContext);
        }
        if (genContext != null && genContext.embedBackmappingData) {
            this.attr(new Attribute[]{AttributeImpl.of((CharSequence)DATA_OXY_ELEMENT_URI, (CharSequence)URLUtil.filterPasswords(genContext.systemID))});
            this.attr(new Attribute[]{AttributeImpl.of((CharSequence)DATA_OXY_ELEMENT_LINE, (CharSequence)("" + (this.context.getCurrentNode().getStartLineNumber() + 1)))});
            this.attr(new Attribute[]{AttributeImpl.of((CharSequence)DATA_OXY_ELEMENT_COLUMN, (CharSequence)"1")});
        }
    }

    public boolean shouldEmbedBackmappingData() {
        ConversionContextProvider.ConversionContext genContext = ConversionContextProvider.getInstance().get();
        if (logger.isDebugEnabled()) {
            logger.debug("Context " + genContext);
        }
        return genContext != null && genContext.embedBackmappingData;
    }
}

