/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.md.backmapping.dita;

import com.elovirta.dita.markdown.SaxWriter;
import com.oxygenxml.md.backmapping.BackmappingAttributesBuilder;
import com.oxygenxml.md.backmapping.CompoundAttributes;
import com.vladsch.flexmark.util.ast.Node;
import java.util.EmptyStackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BackmappingSaxWriter
extends SaxWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BackmappingSaxWriter.class.getName());
    private final String systemID;
    private int elemsDepth;

    public BackmappingSaxWriter(ContentHandler out, String systemID) {
        super(out);
        this.systemID = systemID;
    }

    @Override
    public void startElement(Node currentNode, String tag, Attributes atts) {
        int line = -1;
        int column = 1;
        if (currentNode != null) {
            line = currentNode.getLineNumber() + 1;
        }
        Attributes enrichedAttributes = atts;
        if (atts.getValue("class") != null && !(atts instanceof CompoundAttributes)) {
            enrichedAttributes = BackmappingAttributesBuilder.createXmlBackmappingAttributes(atts, this.systemID, line, column);
        }
        if (this.elemsDepth == 0) {
            try {
                this.getContentHandler().startPrefixMapping("oxy", "http://www.oxygenxml.com/schematron/validation");
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        super.startElement(currentNode, tag, enrichedAttributes);
        ++this.elemsDepth;
    }

    @Override
    public void endElement(String tag) {
        try {
            super.endElement(tag);
            --this.elemsDepth;
            if (this.elemsDepth == 0) {
                try {
                    this.getContentHandler().endPrefixMapping("oxy");
                }
                catch (SAXException sAXException) {}
            }
        }
        catch (EmptyStackException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    public String getMarkdownSourceSystemID() {
        return this.systemID;
    }
}

