/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.md.backmapping;

import com.oxygenxml.md.URLUtil;
import com.oxygenxml.md.backmapping.BackmappingAttributesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BackmappingDataContentHandler
implements ContentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BackmappingDataContentHandler.class.getName());
    private final ContentHandler wrapped;
    private Locator locator;
    private final int initialLine;
    private final AttrType attrType;
    private boolean excludeXhtmlNamespace;

    public BackmappingDataContentHandler(ContentHandler wrapped, int initialLine, AttrType attrType, boolean excludeXhtmlNamespace) {
        this.wrapped = wrapped;
        this.initialLine = initialLine;
        this.attrType = attrType;
        this.excludeXhtmlNamespace = excludeXhtmlNamespace;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.wrapped.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.wrapped.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.wrapped.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.wrapped.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.wrapped.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String systemID = "file://unknown.md";
        int line = this.initialLine;
        int column = 1;
        if (this.locator != null) {
            systemID = this.locator.getSystemId();
            if (this.locator.getLineNumber() > 1) {
                column = this.locator.getColumnNumber();
            }
            line += this.locator.getLineNumber();
        }
        if (this.excludeXhtmlNamespace && "http://www.w3.org/1999/xhtml".equals(uri)) {
            uri = "";
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Tag: {} line: {} column: {} sysid: {}", new Object[]{localName, line, column, URLUtil.filterPasswords(systemID)});
        }
        Attributes createHTMLBackmappingAttributes = this.attrType == AttrType.HTML ? BackmappingAttributesBuilder.createHTMLBackmappingAttributes(atts, systemID, line, column) : BackmappingAttributesBuilder.createXmlBackmappingAttributes(atts, systemID, line, column);
        this.wrapped.startElement(uri, localName, qName, createHTMLBackmappingAttributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.excludeXhtmlNamespace && "http://www.w3.org/1999/xhtml".equals(uri)) {
            uri = "";
        }
        this.wrapped.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.wrapped.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.wrapped.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.wrapped.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.wrapped.skippedEntity(name);
    }

    public static enum AttrType {
        XML,
        HTML;

    }
}

