/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.md.backmapping;

import com.oxygenxml.md.URLUtil;
import com.oxygenxml.md.backmapping.CompoundAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public final class BackmappingAttributesBuilder {
    private static final String OXY_ELEMENT_LINE_ATTR = "elementLine";
    private static final String OXY_ELEMENT_COLUMN_ATTR = "elementColumn";
    private static final String OXY_ELEMENT_URI_ATTR = "elementURI";
    public static final String LOCATION_ATTR_NS = "http://www.oxygenxml.com/schematron/validation";
    private static final String CDATA = "CDATA";
    public static final String OXY_PREFIX = "oxy";
    private static final String DATA_OXY_ELEMENT_LINE = "data-oxy-elementLine";
    private static final String DATA_OXY_ELEMENT_COLUMN = "data-oxy-elementColumn";
    private static final String DATA_OXY_ELEMENT_URI = "data-oxy-elementURI";

    private BackmappingAttributesBuilder() {
    }

    public static Attributes createXmlBackmappingAttributes(Attributes wrapped, String systemID, int line, int column) {
        Attributes toReturn = wrapped;
        if (systemID != null) {
            AttributesImpl locationAttrs = new AttributesImpl();
            locationAttrs.addAttribute(LOCATION_ATTR_NS, OXY_ELEMENT_URI_ATTR, "oxy:elementURI", CDATA, URLUtil.filterPasswords(systemID));
            locationAttrs.addAttribute(LOCATION_ATTR_NS, OXY_ELEMENT_LINE_ATTR, "oxy:elementLine", CDATA, String.valueOf(line));
            locationAttrs.addAttribute(LOCATION_ATTR_NS, OXY_ELEMENT_COLUMN_ATTR, "oxy:elementColumn", CDATA, String.valueOf(column));
            toReturn = new CompoundAttributes(wrapped, locationAttrs);
        }
        return toReturn;
    }

    public static Attributes createHTMLBackmappingAttributes(Attributes attributes, String systemID, int line, int column) {
        Attributes toReturn = attributes;
        if (systemID != null) {
            AttributesImpl locationAttrs = new AttributesImpl();
            locationAttrs.addAttribute("", DATA_OXY_ELEMENT_URI, DATA_OXY_ELEMENT_URI, CDATA, systemID);
            locationAttrs.addAttribute("", DATA_OXY_ELEMENT_LINE, DATA_OXY_ELEMENT_LINE, CDATA, String.valueOf(line));
            locationAttrs.addAttribute("", DATA_OXY_ELEMENT_COLUMN, DATA_OXY_ELEMENT_COLUMN, CDATA, String.valueOf(column));
            toReturn = new CompoundAttributes(attributes, locationAttrs);
        }
        return toReturn;
    }
}

