/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown.renderer;

import com.elovirta.dita.markdown.DitaRenderer;
import com.elovirta.dita.markdown.ParseException;
import com.elovirta.dita.markdown.SaxWriter;
import com.elovirta.dita.markdown.math.SimpleInlineMath;
import com.elovirta.dita.markdown.renderer.AbstractRenderer;
import com.elovirta.dita.markdown.renderer.EndElementHandler;
import com.elovirta.dita.markdown.renderer.Metadata;
import com.elovirta.dita.markdown.renderer.NamespaceFilter;
import com.elovirta.dita.markdown.renderer.NodeRendererContext;
import com.elovirta.dita.markdown.renderer.NodeRenderingHandler;
import com.elovirta.dita.markdown.renderer.StartElementHandler;
import com.elovirta.dita.markdown.renderer.Title;
import com.elovirta.dita.markdown.renderer.Utils;
import com.elovirta.dita.utils.FragmentContentHandler;
import com.oxygenxml.md.backmapping.BackmappingAttributesBuilder;
import com.oxygenxml.md.backmapping.BackmappingDataContentHandler;
import com.oxygenxml.md.backmapping.dita.BackmappingSaxWriter;
import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.CodeBlock;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.DefinitionTerm;
import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.typographic.TypographicQuotes;
import com.vladsch.flexmark.ext.yaml.front.matter.AbstractYamlFrontMatterVisitor;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.ContentNode;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.ReferenceNode;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.visitor.AstHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TopicRenderer
extends AbstractRenderer {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("com.elovirta.dita.messages");
    private static final String COLUMN_NAME_COL = "col";
    private static final String ATTRIBUTE_NAME_COLSPAN = "colspan";
    private static final Attributes TOPIC_ATTS = new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_TOPIC.toString()).add("http://dita.oasis-open.org/architecture/2005/", "DITAArchVersion", "ditaarch:DITAArchVersion", "CDATA", "2.0").build();
    public static final DitaClass TOPIC_FOREIGN = DitaClass.getInstance((String)"- topic/foreign ");
    private static final Attributes FOREIGN_ATTS = Utils.buildAtts((DitaClass)TOPIC_FOREIGN);
    private static final Attributes BODY_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_BODY);
    private static final Attributes NOTE_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_NOTE);
    private static final Attributes FN_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_FN);
    private static final Attributes LI_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_LI);
    private static final Attributes P_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_P);
    private static final Attributes DD_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_DD);
    private static final Attributes CODEBLOCK_ATTS = Utils.buildAtts((DitaClass)Constants.PR_D_CODEBLOCK);
    private static final Attributes PRE_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_PRE);
    private static final Attributes DT_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_DT);
    private static final Attributes DEL_ATTS = new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_PH.toString()).add("status", "deleted").build();
    private static final Attributes SHORTDESC_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_SHORTDESC);
    private static final Attributes PROLOG_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_PROLOG);
    private static final Attributes BLOCKQUOTE_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_LQ);
    private static final Attributes UL_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_UL);
    private static final Attributes DL_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_DL);
    private static final Attributes DLENTRY_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_DLENTRY);
    private static final Attributes OL_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_OL);
    private static final Attributes TABLE_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_TABLE);
    private static final Attributes TGROUP_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_TGROUP);
    private static final Attributes COLSPEC_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_COLSPEC);
    private static final Attributes TBODY_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_TBODY);
    private static final Attributes THEAD_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_THEAD);
    private static final Attributes TR_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_ROW);
    private static final Attributes SIMPLETABLE_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_SIMPLETABLE);
    private static final Attributes STHEAD_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_STHEAD);
    private static final Attributes STROW_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_STROW);
    private static final Attributes STENTRY_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_STENTRY);
    private static final Attributes XREF_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_XREF);
    private static final Attributes ENTRY_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_ENTRY);
    private static final Attributes FIG_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_FIG);
    private static final Attributes REQUIRED_CLEANUP_ATTS = Utils.buildAtts((DitaClass)Constants.TOPIC_REQUIRED_CLEANUP);
    public static final String TIGHT_LIST_P = "tight-list-p";
    private static final Map<String, DitaClass> sections = new HashMap<String, DitaClass>();
    private final Map<String, String> abbreviations = new HashMap<String, String>();
    private final boolean shortdescParagraph;
    private final boolean idFromYaml;
    private final boolean tightList;
    private int currentTableColumn;
    private boolean inSection = false;
    private final Set<String> footnotes = new HashSet<String>();
    private Map<String, Integer> footnoteCount;
    private String lastId;
    private int headerLevel = 0;
    private Stack<Integer> headerLevelsStack = new Stack();
    private int firstHeaderLevel = -1;
    private static final Map<String, Map.Entry<DitaClass, Attributes>> htmlToDita;
    private static final Map<String, Map.Entry<DitaClass, Attributes>> hditaToXdita;
    private static final Map<String, Map.Entry<DitaClass, Attributes>> ditaToDita;
    private boolean onlyImageChild = false;

    public TopicRenderer(DataHolder options) {
        super(options);
        this.shortdescParagraph = (Boolean)DitaRenderer.SHORTDESC_PARAGRAPH.get(options);
        this.idFromYaml = (Boolean)DitaRenderer.ID_FROM_YAML.get(options);
        this.tightList = (Boolean)DitaRenderer.TIGHT_LIST.get(options);
    }

    @Override
    public Map<Class<? extends Node>, NodeRenderingHandler<? extends Node>> getNodeRenderingHandlers() {
        ArrayList<NodeRenderingHandler<? extends Node>> res = new ArrayList<NodeRenderingHandler<? extends Node>>(super.getNodeRenderingHandlers().values());
        if (this.mditaCoreProfile || this.mditaExtendedProfile) {
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableBlock.class, this::renderSimpleTableBlock));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableCaption.class, this::renderSimpleTableCaption));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableBody.class, this::renderSimpleTableBody));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableHead.class, this::renderSimpleTableHead));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableRow.class, this::renderSimpleTableRow));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableCell.class, this::renderSimpleTableCell));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableSeparator.class, this::renderSimpleTableSeparator));
        } else {
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableBlock.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableCaption.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableBody.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableHead.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableRow.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableCell.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(TableSeparator.class, this::render));
        }
        if (!this.mditaCoreProfile) {
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(AttributesNode.class, (node, context, html) -> {}));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(DefinitionList.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(DefinitionTerm.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(DefinitionItem.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Footnote.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(FootnoteBlock.class, this::render));
        }
        if (!this.mditaCoreProfile && !this.mditaExtendedProfile) {
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Abbreviation.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(AbbreviationBlock.class, this::render));
            res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(AdmonitionBlock.class, this::render));
        }
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(AutoLink.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(YamlFrontMatterBlock.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(BlockQuote.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(BulletList.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(CodeBlock.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Document.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(FencedCodeBlock.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(HardLineBreak.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Heading.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(HtmlBlock.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(HtmlCommentBlock.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(HtmlInnerBlock.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(HtmlInnerBlockComment.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(HtmlInline.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Image.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(ImageRef.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(IndentedCodeBlock.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Link.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(LinkRef.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(BulletListItem.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(OrderedListItem.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(MailLink.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(OrderedList.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Paragraph.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Reference.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(SoftLineBreak.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(Text.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(ThematicBreak.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(JekyllTagBlock.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(JekyllTag.class, this::render));
        res.add((NodeRenderingHandler<? extends Node>)new NodeRenderingHandler(SimpleInlineMath.class, (node, context, html) -> this.render((SimpleInlineMath)node, context, html)));
        HashMap<Class<? extends Node>, NodeRenderingHandler<? extends Node>> map = new HashMap<Class<? extends Node>, NodeRenderingHandler<? extends Node>>(super.getNodeRenderingHandlers());
        map.putAll(res.stream().collect(Collectors.toMap(AstHandler::getNodeType, Function.identity())));
        return map;
    }

    private void render(Document node, NodeRendererContext context, SaxWriter html) {
        this.collectFootnotes(node);
        boolean isCompound = this.hasMultipleTopLevelHeaders(node);
        if (isCompound) {
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder().add("http://dita.oasis-open.org/architecture/2005/", "DITAArchVersion", "ditaarch:DITAArchVersion", "CDATA", "2.0");
            if (this.mditaCoreProfile || this.mditaExtendedProfile) {
                atts.add("specializations", "(topic hi-d)(topic em-d)");
            } else {
                atts.add("specializations", "@props/audience @props/deliveryTarget @props/otherprops @props/platform @props/product");
            }
            html.startElement((Node)node, "dita", atts.build());
        }
        context.renderChildren((Node)node);
        if (isCompound) {
            html.endElement();
        }
    }

    private void collectFootnotes(Document doc) {
        HashMap res = new HashMap();
        doc.getDescendants().forEach(node -> {
            if (node instanceof Footnote) {
                Footnote footnote = (Footnote)node;
                String callout = footnote.getText().toString().trim();
                res.compute(callout, (k, v) -> v == null ? 1 : v + 1);
            }
        });
        this.footnoteCount = Collections.unmodifiableMap(res);
    }

    private void render(Abbreviation node, NodeRendererContext context, SaxWriter html) {
        html.characters(node.getChars().toString());
    }

    private void render(AbbreviationBlock node, NodeRendererContext context, SaxWriter html) {
    }

    private void render(AdmonitionBlock node, NodeRendererContext context, SaxWriter html) {
        String type = node.getInfo().toString();
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(NOTE_ATTS);
        switch (type.toLowerCase()) {
            case "note": 
            case "tip": 
            case "fastpath": 
            case "restriction": 
            case "important": 
            case "remember": 
            case "attention": 
            case "caution": 
            case "notice": 
            case "danger": 
            case "warning": 
            case "trouble": {
                atts.add("type", type.toLowerCase());
                break;
            }
            default: {
                atts.add("type", "other").add("othertype", type);
            }
        }
        html.startElement((Node)node, Constants.TOPIC_NOTE, atts.build());
        if (!node.getTitle().isEmpty()) {
            html.startElement((Node)node, Constants.TOPIC_P, P_ATTS);
            html.characters(node.getTitle().toString());
            html.endElement();
        }
        context.renderChildren((Node)node);
        html.endElement();
    }

    private void render(JekyllTagBlock node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(SimpleInlineMath node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(FOREIGN_ATTS).add("outputclass", "embed-latex");
        html.startElement((Node)node, TOPIC_FOREIGN, atts.build());
        String text = node.getText().normalizeEOL();
        if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        html.characters(text);
        html.endElement();
    }

    private void render(JekyllTag node, NodeRendererContext context, SaxWriter html) {
        if (node.getTag().toString().equals("include")) {
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(REQUIRED_CLEANUP_ATTS).add("conref", node.getParameters().toString());
            html.startElement((Node)node, Constants.TOPIC_REQUIRED_CLEANUP, atts.build());
            html.endElement();
        }
    }

    private void render(AutoLink node, NodeRendererContext context, SaxWriter html) {
        if (node.getChars().charAt(0) == '<') {
            XMLUtils.AttributesBuilder atts = this.getLinkAttributes(node.getText().toString());
            html.startElement((Node)node, Constants.TOPIC_XREF, this.getInlineAttributes((Node)node, atts.build()));
            html.characters(node.getText().toString());
            html.endElement();
        } else {
            context.renderChildren((Node)node);
        }
    }

    private void render(Footnote node, NodeRendererContext context, SaxWriter html) {
        String callout = node.getText().toString().trim();
        String id = TopicRenderer.getId("fn_" + callout);
        int count = this.footnoteCount.getOrDefault(callout, 0);
        if (count == 1) {
            Attributes atts = new XMLUtils.AttributesBuilder(FN_ATTS).add("callout", callout).build();
            html.startElement((Node)node, Constants.TOPIC_FN, atts);
            for (Node child = node.getFootnoteBlock().getFirstChild(); child != null; child = child.getNext()) {
                context.renderChildren(child);
            }
            html.endElement();
        } else {
            Attributes atts;
            if (!this.footnotes.contains(id)) {
                atts = new XMLUtils.AttributesBuilder(FN_ATTS).add("callout", callout).add("id", id).build();
                html.startElement((Node)node, Constants.TOPIC_FN, atts);
                for (Node child = node.getFootnoteBlock().getFirstChild(); child != null; child = child.getNext()) {
                    context.renderChildren(child);
                }
                html.endElement();
                this.footnotes.add(id);
            }
            atts = new XMLUtils.AttributesBuilder(XREF_ATTS).add("type", "fn").add("href", String.format("#%s/%s", this.lastId, id)).build();
            html.startElement((Node)node, Constants.TOPIC_XREF, atts);
            html.endElement();
        }
    }

    private void render(FootnoteBlock node, NodeRendererContext context, SaxWriter html) {
    }

    private void render(BlockQuote node, NodeRendererContext context, SaxWriter html) {
        if (this.mditaCoreProfile || this.mditaExtendedProfile) {
            context.renderChildren((Node)node);
        } else {
            this.printTag((Node)node, context, html, Constants.TOPIC_LQ, this.getAttributesFromAttributesNode((Node)node, BLOCKQUOTE_ATTS));
        }
    }

    private void render(BulletList node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.TOPIC_UL, this.getAttributesFromAttributesNode((Node)node, UL_ATTS));
    }

    private void render(DefinitionList node, NodeRendererContext context, SaxWriter html) {
        html.startElement((Node)node, Constants.TOPIC_DL, this.getAttributesFromAttributesNode((Node)node, DL_ATTS));
        Object previous = null;
        context.renderChildren((Node)node);
        html.endElement();
    }

    private void render(DefinitionTerm node, NodeRendererContext context, SaxWriter html) {
        if (node.getPrevious() == null || !(node.getPrevious() instanceof DefinitionTerm)) {
            html.startElement((Node)node, Constants.TOPIC_DLENTRY, DLENTRY_ATTS);
        }
        html.startElement((Node)node, Constants.TOPIC_DT, DT_ATTS);
        Node child = node.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            context.renderChildren(child);
            child = next;
        }
        html.endElement();
    }

    private void render(DefinitionItem node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.TOPIC_DD, DD_ATTS);
        if (node.getNext() == null || !(node.getNext() instanceof DefinitionItem)) {
            html.endElement();
        }
    }

    private void render(Image node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(this.getInlineAttributes((Node)node, IMAGE_ATTS)).add("href", node.getUrl().toString());
        this.writeImage(node, node.getTitle().toString(), null, atts, context, html);
    }

    private void writeImage(Image node, String title, String alt, XMLUtils.AttributesBuilder atts, NodeRendererContext context, SaxWriter html) {
        if (!title.isEmpty()) {
            html.startElement((Node)node, Constants.TOPIC_FIG, FIG_ATTS);
            html.startElement((Node)node, Constants.TOPIC_TITLE, TITLE_ATTS);
            html.characters(title);
            html.endElement();
            html.startElement((Node)node, Constants.TOPIC_IMAGE, atts.build());
            if (node.hasChildren()) {
                html.startElement((Node)node, Constants.TOPIC_ALT, ALT_ATTS);
                if (alt != null) {
                    html.characters(alt);
                } else {
                    context.renderChildren((Node)node);
                }
                html.endElement();
            }
            html.endElement();
            html.endElement();
        } else {
            if (this.onlyImageChild) {
                atts.add("placement", "break");
            }
            html.startElement((Node)node, Constants.TOPIC_IMAGE, atts.build());
            if (node.hasChildren()) {
                html.startElement((Node)node, Constants.TOPIC_ALT, ALT_ATTS);
                if (alt != null) {
                    html.characters(alt);
                } else {
                    context.renderChildren((Node)node);
                }
                html.endElement();
            }
            html.endElement();
        }
    }

    private void writeImage(ImageRef node, String title, String alt, XMLUtils.AttributesBuilder atts, NodeRendererContext context, SaxWriter html) {
        if (!title.isEmpty()) {
            html.startElement((Node)node, Constants.TOPIC_FIG, FIG_ATTS);
            html.startElement((Node)node, Constants.TOPIC_TITLE, TITLE_ATTS);
            html.characters(title);
            html.endElement();
            html.startElement((Node)node, Constants.TOPIC_IMAGE, atts.build());
            if (node.hasChildren()) {
                html.startElement((Node)node, Constants.TOPIC_ALT, ALT_ATTS);
                if (alt != null) {
                    html.characters(alt);
                } else {
                    context.renderChildren((Node)node);
                }
                html.endElement();
            }
            html.endElement();
            html.endElement();
        } else {
            if (this.onlyImageChild) {
                atts.add("placement", "break");
            }
            html.startElement((Node)node, Constants.TOPIC_IMAGE, atts.build());
            if (node.hasChildren()) {
                html.startElement((Node)node, Constants.TOPIC_ALT, ALT_ATTS);
                if (alt != null) {
                    html.characters(alt);
                } else {
                    context.renderChildren((Node)node);
                }
                html.endElement();
            }
            html.endElement();
        }
    }

    private static <E> E containsSome(Collection<E> col, Collection<E> find) {
        for (E c : col) {
            if (!find.contains(c)) continue;
            return c;
        }
        return null;
    }

    private void render(Heading node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts;
        DitaClass cls;
        boolean isSection;
        int headerLevel = 0;
        if (!this.headerLevelsStack.isEmpty()) {
            headerLevel = this.headerLevelsStack.peek();
        }
        StringBuilder buf = new StringBuilder();
        node.getAstExtra(buf);
        Title header = null;
        if (!this.mditaCoreProfile) {
            header = node.getFirstChild() instanceof AnchorLink ? Title.getFromChildren((Node)node.getFirstChild()) : Title.getFromChildren((Node)node);
            header.id.ifPresent(arg_0 -> ((Heading)node).setAnchorRefId(arg_0));
        }
        if (this.inSection) {
            html.endElement();
            this.inSection = false;
        }
        if ((this.mditaCoreProfile || this.mditaExtendedProfile) && node.getLevel() == 2) {
            isSection = true;
            cls = Constants.TOPIC_SECTION;
        } else if (!this.mditaCoreProfile) {
            String sectionClassName = TopicRenderer.containsSome(header.classes, sections.keySet());
            if (sectionClassName != null) {
                isSection = true;
                cls = sections.get(sectionClassName);
            } else {
                isSection = false;
                cls = null;
            }
        } else {
            isSection = false;
            cls = null;
        }
        if (isSection) {
            if ((!this.shouldCorrectHeadingLevels || this.mditaCoreProfile || this.mditaExtendedProfile) && node.getLevel() <= headerLevel) {
                throw new ParseException(String.format("Level %d section title must be higher level than parent topic title %d", node.getLevel(), headerLevel));
            }
            atts = new XMLUtils.AttributesBuilder().add("class", cls.toString());
            String id = this.getSectionId(node, header);
            if (id != null) {
                atts.add("id", id);
            }
            if (!this.mditaCoreProfile) {
                ArrayList classes = new ArrayList(header.classes);
                classes.removeAll(sections.keySet());
                if (!classes.isEmpty()) {
                    atts.add("outputclass", String.join((CharSequence)" ", classes));
                }
            }
            html.startElement((Node)node, cls, atts.build());
            this.inSection = true;
            html.startElement((Node)node, Constants.TOPIC_TITLE, TITLE_ATTS);
            context.renderChildren((Node)node);
            html.endElement();
        } else {
            Node firstChild;
            if (headerLevel > 0) {
                html.endElement();
            }
            while (node.getLevel() <= headerLevel) {
                html.endElement();
                this.headerLevelsStack.pop();
                if (this.headerLevelsStack.isEmpty()) break;
                headerLevel = this.headerLevelsStack.peek();
            }
            this.headerLevelsStack.push(node.getLevel());
            if (this.firstHeaderLevel == -1) {
                this.firstHeaderLevel = node.getLevel();
            }
            atts = this.mditaCoreProfile || this.mditaExtendedProfile ? new XMLUtils.AttributesBuilder(TOPIC_ATTS).add("specializations", "(topic hi-d)(topic em-d)") : new XMLUtils.AttributesBuilder(TOPIC_ATTS).add("specializations", "@props/audience @props/deliveryTarget @props/otherprops @props/platform @props/product");
            String id = this.getTopicId(node, header);
            if (id != null) {
                this.lastId = id;
                atts.add("id", id);
            }
            if (!this.mditaCoreProfile) {
                if (!header.classes.isEmpty()) {
                    atts.add("outputclass", String.join((CharSequence)" ", header.classes));
                }
                for (Map.Entry attr : header.attributes.entrySet()) {
                    atts.add((String)attr.getKey(), (String)attr.getValue());
                }
            }
            html.startElement((Node)node, Constants.TOPIC_TOPIC, atts.build());
            html.startElement((Node)node, Constants.TOPIC_TITLE, TITLE_ATTS);
            context.renderChildren((Node)node);
            html.endElement();
            if (this.shortdescParagraph && node.getNext() instanceof Paragraph) {
                String systemId = null;
                if (html instanceof BackmappingSaxWriter) {
                    systemId = ((BackmappingSaxWriter)html).getMarkdownSourceSystemID();
                }
                Attributes attrs = BackmappingAttributesBuilder.createXmlBackmappingAttributes(SHORTDESC_ATTS, systemId, node.getNext().getLineNumber() + 1, 1);
                html.startElement(node.getNext(), Constants.TOPIC_SHORTDESC, attrs);
                context.renderChildren(node.getNext());
                html.endElement();
            }
            if (node.getLevel() <= this.firstHeaderLevel && (firstChild = node.getDocument().getFirstChild()) instanceof YamlFrontMatterBlock) {
                html.startElement(firstChild, Constants.TOPIC_PROLOG, PROLOG_ATTS);
                this.metadataSerializer.render((YamlFrontMatterBlock)firstChild, context, html);
                html.endElement();
            }
            html.startElement((Node)node, Constants.TOPIC_BODY, BODY_ATTS);
        }
    }

    private String getSectionId(Heading node, Title header) {
        if (header != null) {
            if (node.getAnchorRefId() != null) {
                return node.getAnchorRefId();
            }
            return null;
        }
        if (node.getAnchorRefId() != null) {
            return node.getAnchorRefId();
        }
        return TopicRenderer.getId(node.getText().toString());
    }

    private String getTopicId(Heading node, Title header) {
        if (this.idFromYaml && node.getLevel() == 1 && node.getDocument().getChildOfType(new Class[]{YamlFrontMatterBlock.class}) != null) {
            AbstractYamlFrontMatterVisitor v = new AbstractYamlFrontMatterVisitor();
            v.visit((Node)node.getDocument());
            Map metadata = v.getData();
            List ids = (List)metadata.get("id");
            if (ids != null && !ids.isEmpty()) {
                return (String)ids.get(0);
            }
        }
        return this.getSectionId(node, header);
    }

    private void render(YamlFrontMatterBlock node, NodeRendererContext context, SaxWriter html) {
    }

    private static String getId(String contents) {
        return contents.toLowerCase().replaceAll("[^\\w]", "").trim().replaceAll("\\s+", "_");
    }

    private void render(HtmlBlock node, NodeRendererContext context, SaxWriter html) {
        TransformerHandler h;
        String text = node.getChars().toString();
        FragmentContentHandler fragmentFilter = new FragmentContentHandler();
        fragmentFilter.setContentHandler((ContentHandler)html);
        try {
            h = ((SAXTransformerFactory)this.transformerFactorySupplier.get()).newTransformerHandler((Templates)this.templatesSupplier.get());
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Transformer transformer = h.getTransformer();
        transformer.setParameter("formats", String.join((CharSequence)",", this.formats));
        transformer.setParameter("raw-dita", this.rawDita);
        h.setResult(new SAXResult((ContentHandler)fragmentFilter));
        HtmlParser parser = new HtmlParser();
        parser.setNamePolicy(XmlViolationPolicy.ALLOW);
        NamespaceFilter filter = new NamespaceFilter((XMLReader)parser);
        filter.setContentHandler((ContentHandler)new BackmappingDataContentHandler(h, node.getLineNumber(), BackmappingDataContentHandler.AttrType.XML, false));
        try {
            html.setLocation((Node)node);
            filter.parse(TopicRenderer.createSource(html, new StringReader(text)));
        }
        catch (IOException | SAXException e) {
            throw new ParseException(String.format(MESSAGES.getString("error.html_parse_fail"), e.getMessage()), e);
        }
        html.setDocumentLocator();
    }

    private static InputSource createSource(SaxWriter html, Reader reader) {
        InputSource input = new InputSource(reader);
        String systemId = null;
        if (html instanceof BackmappingSaxWriter) {
            systemId = ((BackmappingSaxWriter)html).getMarkdownSourceSystemID();
        }
        input.setSystemId(systemId);
        return input;
    }

    private static Stream<Map.Entry<String, Map.Entry<DitaClass, Attributes>>> createHtmlToDita(Map.Entry<String, DitaClass> e) {
        AbstractMap.SimpleImmutableEntry<DitaClass, Attributes> value = new AbstractMap.SimpleImmutableEntry<DitaClass, Attributes>(e.getValue(), Utils.buildAtts((DitaClass)e.getValue()));
        return Stream.of(new AbstractMap.SimpleImmutableEntry<CallSite, AbstractMap.SimpleImmutableEntry<DitaClass, Attributes>>((CallSite)((Object)("<" + e.getKey() + ">")), value), new AbstractMap.SimpleImmutableEntry<CallSite, AbstractMap.SimpleImmutableEntry<DitaClass, Attributes>>((CallSite)((Object)("</" + e.getKey() + ">")), value));
    }

    private void render(HtmlInline node, NodeRendererContext context, SaxWriter html) {
        block22: {
            TransformerHandler h;
            String text = node.getChars().toString();
            Map.Entry<DitaClass, Attributes> entry = (this.mditaExtendedProfile ? hditaToXdita : htmlToDita).get(text);
            if (this.rawDita && entry == null) {
                entry = ditaToDita.get(text);
            }
            if (entry != null) {
                DitaClass cls = entry.getKey();
                html.setLocation((Node)node);
                if (text.startsWith("</")) {
                    html.endElement(cls);
                } else {
                    html.startElement((Node)node, cls, entry.getValue());
                }
                return;
            }
            try {
                h = ((SAXTransformerFactory)this.transformerFactorySupplier.get()).newTransformerHandler((Templates)this.templatesSupplier.get());
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            h.getTransformer().setParameter("formats", String.join((CharSequence)",", this.formats));
            HtmlParser parser = new HtmlParser(XmlViolationPolicy.ALLOW);
            parser.setContentHandler((ContentHandler)new BackmappingDataContentHandler(h, node.getLineNumber(), BackmappingDataContentHandler.AttrType.XML, false));
            html.setLocation((Node)node);
            if (text.startsWith("</")) {
                h.setResult(new SAXResult((ContentHandler)new EndElementHandler((ContentHandler)html)));
                String data = text.replaceAll("/", "") + text;
                try (StringReader in = new StringReader(data);){
                    parser.parse(TopicRenderer.createSource(html, in));
                    break block22;
                }
                catch (IOException | SAXException e) {
                    throw new ParseException(String.format(MESSAGES.getString("error.html_parse_fail"), e.getMessage()), e);
                }
            }
            h.setResult(new SAXResult((ContentHandler)new StartElementHandler((ContentHandler)html)));
            try (StringReader in = new StringReader(text);){
                parser.parse(TopicRenderer.createSource(html, in));
            }
            catch (IOException | SAXException e) {
                throw new ParseException(String.format(MESSAGES.getString("error.html_parse_fail"), e.getMessage()), e);
            }
            if (text.endsWith("/>")) {
                html.endElement();
            }
        }
        html.setDocumentLocator();
    }

    private void render(ListItem node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.TOPIC_LI, LI_ATTS);
    }

    private void render(MailLink node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = this.getLinkAttributes("mailto:" + node.getText());
        atts.add("format", "email");
        html.startElement((Node)node, Constants.TOPIC_XREF, this.getInlineAttributes((Node)node, atts.build()));
        context.renderChildren((Node)node);
        html.endElement();
    }

    private void render(OrderedList node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.TOPIC_OL, this.getAttributesFromAttributesNode((Node)node, OL_ATTS));
    }

    private boolean isAttributesParagraph(Node node) {
        if (node == null) {
            return false;
        }
        Node firstChild = node.getFirstChild();
        return firstChild instanceof AttributesNode && firstChild.getNext() == null;
    }

    private void render(Paragraph node, NodeRendererContext context, SaxWriter html) {
        if (!(this.isAttributesParagraph((Node)node) || this.shortdescParagraph && !this.inSection && node.getPrevious() instanceof Heading)) {
            if (this.containsImage((ContentNode)node)) {
                this.onlyImageChild = true;
                context.renderChildren((Node)node);
                this.onlyImageChild = false;
            } else {
                Attributes atts;
                Block parent = node.getParent();
                if (this.tightList && parent.isOrDescendantOfType(new Class[]{BulletListItem.class, OrderedListItem.class}) && !parent.isOrDescendantOfType(new Class[]{BlockQuote.class}) && ListItem.class.isAssignableFrom(parent.getClass()) && ((ListItem)parent).isTight()) {
                    html.startElement((Node)node, TIGHT_LIST_P, P_ATTS);
                    context.renderChildren((Node)node);
                    html.endElement();
                    return;
                }
                if (!this.mditaCoreProfile) {
                    Title header = Title.getFromChildren((Node)node);
                    XMLUtils.AttributesBuilder builder = new XMLUtils.AttributesBuilder(P_ATTS);
                    atts = this.readAttributes(header, builder).build();
                } else {
                    atts = P_ATTS;
                }
                this.printTag((Node)node, context, html, Constants.TOPIC_P, atts);
            }
        }
    }

    private boolean containsImage(ContentNode node) {
        Node first = node.getFirstChild();
        if (first instanceof Image || first instanceof ImageRef) {
            return first.getNextAnyNot(new Class[]{AttributesNode.class}) == null;
        }
        return false;
    }

    private void render(TypographicQuotes node, NodeRendererContext context, SaxWriter html) {
        html.characters('\u2018');
        context.renderChildren((Node)node);
        html.characters('\u2018');
    }

    private void render(ReferenceNode node, NodeRendererContext context, SaxWriter html) {
        throw new RuntimeException();
    }

    private void render(Reference node, NodeRendererContext context, SaxWriter html) {
    }

    private void render(ImageRef node, NodeRendererContext context, SaxWriter html) {
        String text = node.getText().toString();
        String key = node.getReference() != null ? node.getReference().toString() : text;
        Reference refNode = node.getReferenceNode(node.getDocument());
        if (refNode == null) {
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(IMAGE_ATTS).add("keyref", key);
            if (this.onlyImageChild) {
                atts.add("placement", "break");
            }
            html.startElement((Node)node, Constants.TOPIC_IMAGE, this.getInlineAttributes((Node)node, atts.build()));
            html.endElement();
        } else {
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(this.getInlineAttributes((Node)node, IMAGE_ATTS)).add("href", refNode.getUrl().toString());
            if (key != null) {
                atts.add("keyref", key);
            }
            this.writeImage(node, refNode.getTitle().toString(), text, atts, context, html);
        }
    }

    private void render(RefNode node, NodeRendererContext context, SaxWriter html) {
        String text = node.getText().toString();
        String key = node.getReference() != null ? node.getReference().toString() : text;
        Reference refNode = node.getReferenceNode(node.getDocument());
        if (refNode == null) {
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(XREF_ATTS).add("keyref", key);
            html.startElement((Node)node, Constants.TOPIC_XREF, atts.build());
            if (!node.getText().toString().isEmpty()) {
                html.characters(node.getText().toString());
            }
            html.endElement();
        } else {
            XMLUtils.AttributesBuilder atts = this.getLinkAttributes(refNode.getUrl().toString());
            html.startElement((Node)node, Constants.TOPIC_XREF, atts.build());
            if (!refNode.getTitle().toString().isEmpty()) {
                html.characters(refNode.getTitle().toString());
            } else {
                context.renderChildren((Node)node);
            }
            html.endElement();
        }
    }

    private void render(Link node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = this.getLinkAttributes(node.getUrl().toString());
        html.startElement((Node)node, Constants.TOPIC_XREF, this.getInlineAttributes((Node)node, atts.build()));
        context.renderChildren((Node)node);
        html.endElement();
    }

    private void render(TableBody node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.TOPIC_TBODY, TBODY_ATTS);
    }

    private void render(TableCaption node, NodeRendererContext context, SaxWriter html) {
    }

    private void render(TableCell node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(ENTRY_ATTS);
        if (node.getAlignment() != null) {
            atts.add("align", node.getAlignment().cellAlignment().name().toLowerCase());
        }
        if (node.getSpan() > 1) {
            atts.add("namest", COLUMN_NAME_COL + Integer.toString(this.currentTableColumn + 1));
            atts.add("nameend", COLUMN_NAME_COL + Integer.toString(this.currentTableColumn + node.getSpan()));
        }
        html.startElement((Node)node, Constants.TOPIC_ENTRY, atts.build());
        context.renderChildren((Node)node);
        html.endElement();
        this.currentTableColumn += node.getSpan();
    }

    private void render(TableHead node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.TOPIC_THEAD, THEAD_ATTS);
    }

    private void render(TableBlock node, NodeRendererContext context, SaxWriter html) {
        Attributes tableAtts;
        if (!this.mditaExtendedProfile && this.isAttributesParagraph(node.getNext())) {
            Title header = Title.getFromChildren((Node)node.getNext());
            XMLUtils.AttributesBuilder builder = new XMLUtils.AttributesBuilder(TABLE_ATTS);
            tableAtts = this.readAttributes(header, builder).build();
        } else {
            tableAtts = TABLE_ATTS;
        }
        html.startElement((Node)node, Constants.TOPIC_TABLE, tableAtts);
        Node caption = node.getChildOfType(new Class[]{TableCaption.class});
        if (caption != null) {
            html.startElement(caption, Constants.TOPIC_TITLE, TITLE_ATTS);
            context.renderChildren(caption);
            html.endElement();
        }
        int maxCols = this.findMaxCols(node);
        Attributes atts = new XMLUtils.AttributesBuilder(TGROUP_ATTS).add("cols", Integer.toString(maxCols)).build();
        html.startElement((Node)node, Constants.TOPIC_TGROUP, atts);
        for (int i = 0; i < maxCols; ++i) {
            XMLUtils.AttributesBuilder catts = new XMLUtils.AttributesBuilder(COLSPEC_ATTS).add("colname", COLUMN_NAME_COL + (i + 1));
            html.startElement((Node)node, Constants.TOPIC_COLSPEC, catts.build());
            html.endElement();
        }
        context.renderChildren((Node)node);
        html.endElement();
        html.endElement();
    }

    private int findMaxCols(TableBlock table) {
        int max = 0;
        for (Node body = table.getFirstChild(); body != null; body = body.getNext()) {
            if (!(body instanceof TableHead) && !(body instanceof TableBody)) continue;
            for (Node row = body.getFirstChild(); row != null; row = row.getNext()) {
                if (!(row instanceof TableRow)) continue;
                int colCount = 0;
                for (Node col = row.getFirstChild(); col != null; col = col.getNext()) {
                    if (!(col instanceof TableCell)) continue;
                    TableCell c = (TableCell)col;
                    colCount += c.getSpan();
                }
                max = Math.max(max, colCount);
            }
        }
        return max;
    }

    private void render(TableSeparator node, NodeRendererContext context, SaxWriter html) {
    }

    private void render(TableRow node, NodeRendererContext context, SaxWriter html) {
        this.currentTableColumn = 0;
        this.printTag((Node)node, context, html, Constants.TOPIC_ROW, TR_ATTS);
    }

    private void renderSimpleTableBlock(TableBlock node, NodeRendererContext context, SaxWriter html) {
        Attributes tableAtts;
        if (!this.mditaExtendedProfile && this.isAttributesParagraph(node.getNext())) {
            Title header = Title.getFromChildren((Node)node.getNext());
            XMLUtils.AttributesBuilder builder = new XMLUtils.AttributesBuilder(SIMPLETABLE_ATTS);
            tableAtts = this.readAttributes(header, builder).build();
        } else {
            tableAtts = SIMPLETABLE_ATTS;
        }
        html.startElement((Node)node, Constants.TOPIC_SIMPLETABLE, tableAtts);
        Node caption = node.getChildOfType(new Class[]{TableCaption.class});
        if (caption != null) {
            html.startElement(caption, Constants.TOPIC_TITLE, TITLE_ATTS);
            context.renderChildren(caption);
            html.endElement();
        }
        context.renderChildren((Node)node);
        html.endElement();
    }

    private void renderSimpleTableCaption(TableCaption node, NodeRendererContext context, SaxWriter html) {
    }

    private void renderSimpleTableHead(TableHead node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void renderSimpleTableBody(TableBody node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void renderSimpleTableSeparator(TableSeparator node, NodeRendererContext context, SaxWriter html) {
    }

    private void renderSimpleTableRow(TableRow node, NodeRendererContext context, SaxWriter html) {
        this.currentTableColumn = 0;
        if (node.getParent() instanceof TableHead) {
            this.printTag((Node)node, context, html, Constants.TOPIC_STHEAD, STHEAD_ATTS);
        } else {
            this.printTag((Node)node, context, html, Constants.TOPIC_STROW, STROW_ATTS);
        }
    }

    private void renderSimpleTableCell(TableCell node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(STENTRY_ATTS);
        if (node.getSpan() > 1) {
            atts.add(ATTRIBUTE_NAME_COLSPAN, Integer.toString(node.getSpan()));
        }
        html.startElement((Node)node, Constants.TOPIC_STENTRY, atts.build());
        if (this.isInline(node.getFirstChild())) {
            html.startElement((Node)node, Constants.TOPIC_P, P_ATTS);
            context.renderChildren((Node)node);
            html.endElement();
        } else {
            context.renderChildren((Node)node);
        }
        html.endElement();
        this.currentTableColumn += node.getSpan();
    }

    private boolean isInline(Node node) {
        return node instanceof Text || node instanceof Emphasis || node instanceof StrongEmphasis;
    }

    private void render(CodeBlock node, NodeRendererContext context, SaxWriter html) {
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(this.mditaExtendedProfile ? PRE_ATTS : CODEBLOCK_ATTS).add("http://www.w3.org/XML/1998/namespace", "space", "xml:space", "CDATA", "preserve");
        html.startElement((Node)node, this.mditaExtendedProfile ? Constants.TOPIC_PRE : Constants.PR_D_CODEBLOCK, atts.build());
        String text = node.getChars().toString();
        if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        html.characters(text);
        html.endElement();
    }

    private void render(IndentedCodeBlock node, NodeRendererContext context, SaxWriter html) {
        String text;
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(this.mditaExtendedProfile ? PRE_ATTS : CODEBLOCK_ATTS).add("http://www.w3.org/XML/1998/namespace", "space", "xml:space", "CDATA", "preserve");
        html.startElement((Node)node, this.mditaExtendedProfile ? Constants.TOPIC_PRE : Constants.PR_D_CODEBLOCK, atts.build());
        if (this.mditaExtendedProfile) {
            html.startElement((Node)node, Constants.HI_D_TT, TT_ATTS);
        }
        if ((text = node.getContentChars().toString()).endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        html.characters(text);
        if (this.mditaExtendedProfile) {
            html.endElement();
        }
        html.endElement();
    }

    private void render(FencedCodeBlock node, NodeRendererContext context, SaxWriter html) {
        String text;
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(this.mditaExtendedProfile ? PRE_ATTS : CODEBLOCK_ATTS).add("http://www.w3.org/XML/1998/namespace", "space", "xml:space", "CDATA", "preserve");
        BasedSequence info = node.getInfo();
        if (info.startsWith((CharSequence)"{") && info.endsWith((CharSequence)"}")) {
            Metadata metadata = Metadata.parse((String)info.subSequence(1, info.length() - 1).toString());
            if (!metadata.classes.isEmpty()) {
                atts.add("outputclass", String.join((CharSequence)" ", metadata.classes));
            }
            if (metadata.id != null) {
                atts.add("id", metadata.id);
            }
            for (Map.Entry entry : metadata.attrs.entrySet()) {
                atts.add((String)entry.getKey(), (String)entry.getValue());
            }
        } else if (info.isNotNull() && !info.isBlank()) {
            int space = info.indexOf(' ');
            BasedSequence language = space == -1 ? info : info.subSequence(0, space);
            atts.add("outputclass", context.getDitaOptions().languageClassPrefix + language.unescape());
        } else {
            String noLanguageClass = context.getDitaOptions().noLanguageClass.trim();
            if (!noLanguageClass.isEmpty()) {
                atts.add("outputclass", noLanguageClass);
            }
        }
        html.startElement((Node)node, this.mditaExtendedProfile ? Constants.TOPIC_PRE : Constants.PR_D_CODEBLOCK, atts.build());
        if (this.mditaExtendedProfile) {
            html.startElement((Node)node, Constants.HI_D_TT, TT_ATTS);
        }
        if ((text = node.getContentChars().normalizeEOL()).endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        html.characters(text);
        if (this.mditaExtendedProfile) {
            html.endElement();
        }
        html.endElement();
    }

    private void render(Text node, NodeRendererContext context, SaxWriter html) {
        if (this.abbreviations.isEmpty()) {
            if (node.getParent() instanceof Code) {
                html.characters(node.getChars().toString());
            } else {
                html.characters(node.getChars().unescapeNoEntities());
            }
        } else {
            this.printWithAbbreviations(node.getChars().toString(), html);
        }
    }

    private void render(ContentNode node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(SoftLineBreak node, NodeRendererContext context, SaxWriter html) {
        html.characters('\n');
    }

    private void render(HardLineBreak node, NodeRendererContext context, SaxWriter html) {
        html.processingInstruction("linebreak", null);
    }

    private void render(Node node, NodeRendererContext context, SaxWriter html) {
        throw new RuntimeException("No renderer configured for " + node.getNodeName() + " = " + node.getClass().getCanonicalName());
    }

    private Attributes getAttributesFromAttributesNode(Node node, Attributes base) {
        if (!this.mditaExtendedProfile && this.isAttributesParagraph(node.getNext())) {
            Title header = Title.getFromChildren((Node)node.getNext());
            XMLUtils.AttributesBuilder builder = new XMLUtils.AttributesBuilder(base);
            return this.readAttributes(header, builder).build();
        }
        return base;
    }

    @Override
    protected XMLUtils.AttributesBuilder getLinkAttributes(String href) {
        return this.getLinkAttributes(href, XREF_ATTS);
    }

    protected void printWithAbbreviations(String string, SaxWriter html) {
        TreeMap<Integer, Map.Entry<String, String>> expansions = null;
        for (Map.Entry<String, String> entry : this.abbreviations.entrySet()) {
            int sx;
            String abbr = entry.getKey();
            int ix = 0;
            while ((sx = string.indexOf(abbr, ix)) != -1) {
                ix = sx + abbr.length();
                if (sx > 0 && Character.isLetterOrDigit(string.charAt(sx - 1)) || ix < string.length() && Character.isLetterOrDigit(string.charAt(ix))) continue;
                if (expansions == null) {
                    expansions = new TreeMap<Integer, Map.Entry<String, String>>();
                }
                expansions.put(sx, entry);
            }
        }
        if (expansions != null) {
            int ix = 0;
            for (Map.Entry entry : expansions.entrySet()) {
                int sx = (Integer)entry.getKey();
                String abbr = (String)((Map.Entry)entry.getValue()).getKey();
                String expansion = (String)((Map.Entry)entry.getValue()).getValue();
                html.characters(string.substring(ix, sx));
                XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(PH_ATTS);
                if (expansion != null && !expansion.isEmpty()) {
                    atts.add("otherprops", expansion);
                }
                html.startElement(null, Constants.TOPIC_PH, atts.build());
                html.characters(abbr);
                html.endElement();
                ix = sx + abbr.length();
            }
            html.characters(string.substring(ix));
        } else {
            html.characters(string);
        }
    }

    static {
        sections.put(Constants.TOPIC_SECTION.localName, Constants.TOPIC_SECTION);
        sections.put(Constants.TOPIC_EXAMPLE.localName, Constants.TOPIC_EXAMPLE);
        htmlToDita = Stream.of(new AbstractMap.SimpleImmutableEntry<String, DitaClass>("span", Constants.TOPIC_PH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("code", Constants.PR_D_CODEPH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("s", Constants.HI_D_LINE_THROUGH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("tt", Constants.HI_D_TT), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("b", Constants.HI_D_B), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("strong", Constants.HI_D_B), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("i", Constants.HI_D_I), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("em", Constants.HI_D_I), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("sub", Constants.HI_D_SUB), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("sup", Constants.HI_D_SUP), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("u", Constants.HI_D_U)).flatMap(TopicRenderer::createHtmlToDita).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        hditaToXdita = Stream.of(new AbstractMap.SimpleImmutableEntry<String, DitaClass>("span", Constants.TOPIC_PH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("code", Constants.TOPIC_PH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("s", Constants.TOPIC_PH), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("tt", Constants.HI_D_TT), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("b", Constants.HI_D_B), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("strong", Constants.HI_D_B), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("i", Constants.HI_D_I), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("em", Constants.HI_D_I), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("sub", Constants.HI_D_SUB), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("sup", Constants.HI_D_SUP), new AbstractMap.SimpleImmutableEntry<String, DitaClass>("u", Constants.HI_D_U)).flatMap(TopicRenderer::createHtmlToDita).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        ditaToDita = Stream.of(DitaClass.getInstance((String)"+ topic/keyword learningInteractionBase-d/keyword learning-d/lcAreaShape "), DitaClass.getInstance((String)"+ topic/keyword learningInteractionBase2-d/keyword learning2-d/lcAreaShape2 "), DitaClass.getInstance((String)"+ topic/keyword markup-d/markupname "), DitaClass.getInstance((String)"+ topic/keyword markup-d/markupname xml-d/numcharref "), DitaClass.getInstance((String)"+ topic/keyword markup-d/markupname xml-d/parameterentity "), DitaClass.getInstance((String)"+ topic/keyword markup-d/markupname xml-d/textentity "), DitaClass.getInstance((String)"+ topic/keyword markup-d/markupname xml-d/xmlatt "), DitaClass.getInstance((String)"+ topic/keyword markup-d/markupname xml-d/xmlelement "), DitaClass.getInstance((String)"+ topic/keyword markup-d/markupname xml-d/xmlnsname "), DitaClass.getInstance((String)"+ topic/keyword markup-d/markupname xml-d/xmlpi "), DitaClass.getInstance((String)"+ topic/keyword pr-d/apiname "), DitaClass.getInstance((String)"+ topic/keyword pr-d/kwd "), DitaClass.getInstance((String)"+ topic/keyword pr-d/option "), DitaClass.getInstance((String)"+ topic/keyword pr-d/parmname "), DitaClass.getInstance((String)"+ topic/keyword sw-d/cmdname "), DitaClass.getInstance((String)"+ topic/keyword sw-d/msgnum "), DitaClass.getInstance((String)"+ topic/keyword sw-d/varname "), DitaClass.getInstance((String)"+ topic/keyword ui-d/shortcut "), DitaClass.getInstance((String)"+ topic/keyword ui-d/wintitle "), DitaClass.getInstance((String)"+ topic/keyword ut-d/shape "), DitaClass.getInstance((String)"+ topic/ph emphasis-d/em "), DitaClass.getInstance((String)"+ topic/ph emphasis-d/strong "), DitaClass.getInstance((String)"+ topic/ph equation-d/equation-inline "), DitaClass.getInstance((String)"+ topic/ph equation-d/equation-number "), DitaClass.getInstance((String)"+ topic/ph hi-d/b "), DitaClass.getInstance((String)"+ topic/ph hi-d/i "), DitaClass.getInstance((String)"+ topic/ph hi-d/line-through "), DitaClass.getInstance((String)"+ topic/ph hi-d/overline "), DitaClass.getInstance((String)"+ topic/ph hi-d/sub "), DitaClass.getInstance((String)"+ topic/ph hi-d/sup "), DitaClass.getInstance((String)"+ topic/ph hi-d/tt "), DitaClass.getInstance((String)"+ topic/ph hi-d/u "), DitaClass.getInstance((String)"+ topic/ph learningInteractionBase-d/ph learning-d/lcAreaCoords "), DitaClass.getInstance((String)"+ topic/ph learningInteractionBase2-d/ph learning2-d/lcAreaCoords2 "), DitaClass.getInstance((String)"+ topic/ph pr-d/codeph "), DitaClass.getInstance((String)"+ topic/ph pr-d/delim "), DitaClass.getInstance((String)"+ topic/ph pr-d/oper "), DitaClass.getInstance((String)"+ topic/ph pr-d/repsep "), DitaClass.getInstance((String)"+ topic/ph pr-d/sep "), DitaClass.getInstance((String)"+ topic/ph pr-d/synph "), DitaClass.getInstance((String)"+ topic/ph pr-d/var "), DitaClass.getInstance((String)"+ topic/ph sw-d/filepath "), DitaClass.getInstance((String)"+ topic/ph sw-d/msgph "), DitaClass.getInstance((String)"+ topic/ph sw-d/systemoutput "), DitaClass.getInstance((String)"+ topic/ph sw-d/userinput "), DitaClass.getInstance((String)"+ topic/ph ui-d/menucascade "), DitaClass.getInstance((String)"+ topic/ph ui-d/uicontrol "), DitaClass.getInstance((String)"+ topic/ph ut-d/coords "), DitaClass.getInstance((String)"+ topic/term abbrev-d/abbreviated-form "), DitaClass.getInstance((String)"+ topic/xref mathml-d/mathmlref "), DitaClass.getInstance((String)"+ topic/xref pr-d/coderef "), DitaClass.getInstance((String)"+ topic/xref pr-d/fragref "), DitaClass.getInstance((String)"+ topic/xref pr-d/synnoteref "), DitaClass.getInstance((String)"+ topic/xref svg-d/svgref "), DitaClass.getInstance((String)"- topic/boolean "), DitaClass.getInstance((String)"- topic/cite "), DitaClass.getInstance((String)"- topic/data learningBase/lcTime "), DitaClass.getInstance((String)"- topic/include "), DitaClass.getInstance((String)"- topic/indextermref "), DitaClass.getInstance((String)"- topic/itemgroup "), DitaClass.getInstance((String)"- topic/itemgroup task/info "), DitaClass.getInstance((String)"- topic/itemgroup task/stepresult "), DitaClass.getInstance((String)"- topic/itemgroup task/stepxmp "), DitaClass.getInstance((String)"- topic/itemgroup task/tutorialinfo "), DitaClass.getInstance((String)"- topic/keyword "), DitaClass.getInstance((String)"- topic/ph "), DitaClass.getInstance((String)"- topic/ph bookmap/booklibrary "), DitaClass.getInstance((String)"- topic/ph bookmap/booktitlealt "), DitaClass.getInstance((String)"- topic/ph bookmap/completed "), DitaClass.getInstance((String)"- topic/ph bookmap/day "), DitaClass.getInstance((String)"- topic/ph bookmap/mainbooktitle "), DitaClass.getInstance((String)"- topic/ph bookmap/month "), DitaClass.getInstance((String)"- topic/ph bookmap/revisionid "), DitaClass.getInstance((String)"- topic/ph bookmap/started "), DitaClass.getInstance((String)"- topic/ph bookmap/summary "), DitaClass.getInstance((String)"- topic/ph bookmap/year "), DitaClass.getInstance((String)"- topic/ph learningBase/lcObjectivesStem "), DitaClass.getInstance((String)"- topic/ph task/cmd "), DitaClass.getInstance((String)"- topic/q "), DitaClass.getInstance((String)"- topic/state "), DitaClass.getInstance((String)"- topic/term "), DitaClass.getInstance((String)"- topic/text "), DitaClass.getInstance((String)"- topic/tm "), DitaClass.getInstance((String)"- topic/xref "), DitaClass.getInstance((String)"- topic/xref concept/xref glossentry/glossAlternateFor ")).map(cls -> Map.entry(cls.localName, cls)).flatMap(TopicRenderer::createHtmlToDita).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

