/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown.math;

import com.elovirta.dita.markdown.math.SimpleInlineMath;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLatexInlineParser
implements InlineParserExtension {
    private Pattern[] MATH_PATTERNS = new Pattern[]{Pattern.compile("\\$\\$((?:.|\n)*?)\\$\\$"), Pattern.compile("\\$`((?:.)*?)`\\$"), Pattern.compile("\\$((?:.)*?)\\$")};

    public SimpleLatexInlineParser(LightInlineParser inlineParser) {
    }

    public void finalizeDocument(@NotNull InlineParser inlineParser) {
    }

    public void finalizeBlock(@NotNull InlineParser inlineParser) {
    }

    public boolean parse(@NotNull LightInlineParser inlineParser) {
        BasedSequence input = inlineParser.getInput();
        if (inlineParser.peek(0) == '$') {
            for (int i = 0; i < this.MATH_PATTERNS.length; ++i) {
                Matcher matcher = inlineParser.matcher(this.MATH_PATTERNS[i]);
                if (matcher == null) continue;
                inlineParser.flushTextNode();
                BasedSequence mathOpen = input.subSequence(matcher.start(), matcher.start(1));
                BasedSequence mathClosed = input.subSequence(matcher.end(1), matcher.end());
                SimpleInlineMath inlineMath = new SimpleInlineMath(mathOpen, mathOpen.baseSubSequence(mathOpen.getEndOffset(), mathClosed.getStartOffset()), mathClosed);
                inlineParser.getBlock().appendChild((Node)inlineMath);
                return true;
            }
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @NotNull
        public CharSequence getCharacters() {
            return "$";
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @NotNull
        public InlineParserExtension apply(@NotNull LightInlineParser lightInlineParser) {
            return new SimpleLatexInlineParser(lightInlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

