/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util.accessibility;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class AccessibilityUtil {
    public static boolean isJavaAccessBridgeEnabled() {
        String accessibility = System.getProperty("javax.accessibility.assistive_technologies");
        return accessibility != null && accessibility.trim().length() > 0;
    }

    public static void collectAccessibleNameFromLabelsAndTextComponents(Component component, StringBuilder accesibleName) {
        JTextComponent textComponent;
        String text;
        JLabel label;
        String labelAccessibleName;
        if (component instanceof JLabel && (labelAccessibleName = (label = (JLabel)component).getAccessibleContext().getAccessibleName()) != null) {
            if (accesibleName.length() > 0) {
                accesibleName.append(" ");
            }
            accesibleName.append(labelAccessibleName);
        }
        if (component instanceof JTextComponent && (text = (textComponent = (JTextComponent)component).getText()) != null) {
            if (accesibleName.length() > 0) {
                accesibleName.append(" ");
            }
            accesibleName.append(text);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component child = container.getComponent(i);
                AccessibilityUtil.collectAccessibleNameFromLabelsAndTextComponents(child, accesibleName);
            }
        }
    }

    public static void collectAccessibleDescriptionFromLabelsAndTextComponents(Component component, StringBuilder accesibleDescription) {
        JComponent label;
        String accessibleDescription;
        if ((component instanceof JLabel || component instanceof JTextComponent) && (accessibleDescription = (label = (JComponent)component).getAccessibleContext().getAccessibleDescription()) != null) {
            if (accesibleDescription.length() > 0) {
                accesibleDescription.append(" ");
            }
            accesibleDescription.append(accessibleDescription);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component child = container.getComponent(i);
                AccessibilityUtil.collectAccessibleDescriptionFromLabelsAndTextComponents(child, accesibleDescription);
            }
        }
    }
}

