/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTextUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)BasicTextUtil.class.getName());

    public static String getSomeText(String str, int maxLen) {
        Object toReturn = str;
        if (str != null && str.length() > maxLen) {
            toReturn = ((String)toReturn).substring(0, maxLen - 4) + " ...";
        }
        return toReturn;
    }

    public static String getSomeTextFromBothBeginningAndEnd(String str, int maxLen) {
        if (str != null && str.length() > maxLen) {
            StringBuilder sb = new StringBuilder();
            String threeDots = "...";
            int minLength = threeDots.length();
            if (maxLen >= minLength + 2) {
                int maxCharsFromStart = (maxLen - minLength) / 2;
                int maxCharsFromEnd = maxLen - maxCharsFromStart - minLength;
                sb.append(str.substring(0, maxCharsFromStart));
                sb.append(threeDots);
                sb.append(str.substring(str.length() - maxCharsFromEnd));
            } else {
                sb.append(threeDots);
            }
            return sb.toString();
        }
        return str;
    }

    public static String getSomeTextAtEnd(String str, int maxLen) {
        int strLen;
        int n = strLen = str != null ? ((String)str).length() : 0;
        if (str != null && strLen > maxLen && ((String)(str = ((String)str).substring(strLen - maxLen, strLen))).length() > 3) {
            str = "..." + ((String)str).substring(3);
        }
        return str;
    }

    public static String truncateName(String name, int maxLength) {
        return BasicTextUtil.truncateName(name, maxLength, false);
    }

    public static String truncateName(String name, int maxLength, boolean showOnlyName) {
        if (name == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (name.length() < maxLength) {
            buf.append(name);
        } else {
            String separator = "/";
            if (name.indexOf(92) != -1) {
                separator = "\\";
            }
            boolean startsWithSeparator = name.indexOf(separator) == 0;
            StringTokenizer stk = new StringTokenizer(name, separator, false);
            Vector<String> tokens = new Vector<String>();
            while (stk.hasMoreTokens()) {
                tokens.add(stk.nextToken());
            }
            int maxTokens = tokens.size();
            if (maxTokens <= 2) {
                if (showOnlyName) {
                    buf.append(BasicTextUtil.getSomeText((String)tokens.get(maxTokens - 1), maxLength));
                } else {
                    buf.append(name);
                }
            } else {
                if (startsWithSeparator) {
                    buf.append(separator);
                }
                buf.append((String)tokens.get(0));
                buf.append(separator);
                buf.append("...");
                StringBuilder secondBuf = new StringBuilder();
                for (int i = maxTokens - 1; i >= 2; --i) {
                    String token = (String)tokens.get(i);
                    if (buf.length() + secondBuf.length() + token.length() + 1 >= maxLength) break;
                    secondBuf.insert(0, token);
                    secondBuf.insert(0, separator);
                }
                if (secondBuf.length() == 0) {
                    buf.append(separator);
                    buf.append(BasicTextUtil.getSomeTextAtEnd((String)tokens.get(maxTokens - 1), Math.max(maxLength - buf.length(), 0)));
                } else {
                    buf.append((CharSequence)secondBuf);
                }
            }
        }
        return buf.toString();
    }

    public static final boolean isWhitespace(String text) {
        int offset;
        int len = text.length();
        for (offset = 0; offset < len && text.charAt(offset) <= ' '; ++offset) {
        }
        return offset == len;
    }

    public static final boolean isWhitespace(char[] text, int offset, int len) {
        int endOffset = len + offset;
        while (offset < endOffset && text[offset] <= ' ') {
            ++offset;
        }
        return offset == endOffset;
    }

    public static int getNumberOfLines(String message) {
        int numberOfLines = 1;
        int len = message.length();
        for (int i = 0; i < len; ++i) {
            if (message.charAt(i) != '\n') continue;
            ++numberOfLines;
        }
        return numberOfLines;
    }

    public static boolean isLargeMessage(String msg) {
        return BasicTextUtil.getNumberOfLines(msg) > 5 || BasicTextUtil.getMaxLineWidth(msg) > 120;
    }

    public static void escapeRTFControlChars(String toEscape, StringBuilder toReturn) {
        int length = toEscape.length();
        for (int i = 0; i < length; ++i) {
            char c = toEscape.charAt(i);
            if (c > '\u0080') {
                toReturn.append("\\u").append((int)c).append(' ');
                continue;
            }
            switch (c) {
                case '\\': 
                case '{': 
                case '}': {
                    toReturn.append('\\');
                    break;
                }
                case '\n': {
                    toReturn.append("\\line");
                }
            }
            toReturn.append(c);
        }
    }

    public static String escapeRTFControlChars(String toEscape) {
        StringBuilder toReturn = new StringBuilder();
        BasicTextUtil.escapeRTFControlChars(toEscape, toReturn);
        return toReturn.toString();
    }

    public static boolean startsWithIgnoreCase(String main, String prefix) {
        return main.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String main, String suffix) {
        int length = suffix.length();
        return main.regionMatches(true, main.length() - length, suffix, 0, length);
    }

    public static String escapeForRegExPattern(String string) {
        StringBuilder pattern = new StringBuilder(string.length() + 16);
        int length = string.length();
        block9: for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    pattern.append('\\').append(ch);
                    continue block9;
                }
                case '\n': {
                    pattern.append("\\n");
                    continue block9;
                }
                case '\r': {
                    pattern.append("\\r");
                    continue block9;
                }
                case '\t': {
                    pattern.append("\\t");
                    continue block9;
                }
                case '\f': {
                    pattern.append("\\f");
                    continue block9;
                }
                case '\u0007': {
                    pattern.append("\\a");
                    continue block9;
                }
                case '\u001b': {
                    pattern.append("\\e");
                    continue block9;
                }
                default: {
                    if ('\u0000' <= ch && ch < ' ') {
                        pattern.append("\\x");
                        pattern.append(Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));
                        continue block9;
                    }
                    pattern.append(ch);
                }
            }
        }
        return pattern.toString();
    }

    public static String capitalize(String str) {
        if (str != null && ((String)str).length() > 0) {
            str = ((String)str).toLowerCase();
            str = Character.toUpperCase(((String)str).charAt(0)) + ((String)str).substring(1);
        }
        return str;
    }

    public static boolean isPartOfLetterOrDigit(int ch) {
        boolean isPart = Character.isLetterOrDigit(ch) || ch > 768 && ch < 879 || Character.getType(ch) == 6;
        return isPart;
    }

    public static String avoidTooManyLines(String comment) {
        int nlCnt = 0;
        for (int i = 0; i < ((String)comment).length(); ++i) {
            char ch = ((String)comment).charAt(i);
            if (ch == '\n') {
                ++nlCnt;
            }
            if (nlCnt <= 5) continue;
            comment = ((String)comment).substring(0, i) + "...";
            break;
        }
        return comment;
    }

    private static int getMaxLineWidth(String message) {
        int maxLineWidth = 0;
        int intermediaryLineWidth = 0;
        int len = message.length();
        for (int i = 0; i < len; ++i) {
            if (message.charAt(i) == '\n') {
                maxLineWidth = Math.max(maxLineWidth, intermediaryLineWidth);
                intermediaryLineWidth = 0;
                continue;
            }
            ++intermediaryLineWidth;
        }
        if (intermediaryLineWidth > 0) {
            maxLineWidth = Math.max(maxLineWidth, intermediaryLineWidth);
        }
        return maxLineWidth;
    }

    public static String formatMessage(String messageToFormat, String key, String value) {
        Object result = messageToFormat;
        int pos = ((String)result).indexOf(key);
        while (pos != -1) {
            String afterString = ((String)result).substring(pos + key.length(), ((String)result).length());
            result = ((String)result).substring(0, pos);
            result = (String)result + value;
            result = (String)result + afterString;
            pos = ((String)result).indexOf(key);
        }
        return result;
    }

    public static boolean isOneOf(char ch, char[] array) {
        boolean ret = false;
        for (int i = 0; i < array.length; ++i) {
            if (ch != array[i]) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static String getCorrespondingKey(Map<String, String> map, String value) {
        if (map == null) {
            return null;
        }
        String correspondingKey = null;
        Set<String> keys = map.keySet();
        for (String key : keys) {
            if (value == null || !value.equals(map.get(key))) continue;
            correspondingKey = key;
            break;
        }
        return correspondingKey;
    }

    public static String replaceAll(String original, String match, String toReplaceWith) {
        try {
            return Pattern.compile(match, 16).matcher(original).replaceAll(Matcher.quoteReplacement(toReplaceWith));
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return original;
        }
    }

    public static String escapeForPaste(String string) {
        return BasicTextUtil.escapeForPaste(string, false, false);
    }

    public static String escapeForPaste(String string, boolean skipQuote, boolean skipApostrophe) {
        if (string == null) {
            return null;
        }
        int length = string.length();
        StringBuilder toPaste = new StringBuilder(length + 16);
        boolean escapeEncountered = false;
        block11: for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\\': {
                    if (escapeEncountered) {
                        toPaste.append("\\\\");
                    }
                    escapeEncountered = !escapeEncountered;
                    continue block11;
                }
                case '\'': {
                    if (escapeEncountered) {
                        escapeEncountered = false;
                    }
                    if (!skipApostrophe) {
                        toPaste.append('\\');
                    }
                    toPaste.append(ch);
                    continue block11;
                }
                case '\"': {
                    if (escapeEncountered) {
                        escapeEncountered = false;
                    }
                    if (!skipQuote) {
                        toPaste.append('\\');
                    }
                    toPaste.append(ch);
                    continue block11;
                }
                case '\n': {
                    escapeEncountered = false;
                    toPaste.append("\\n");
                    continue block11;
                }
                case '\r': {
                    escapeEncountered = false;
                    toPaste.append("\\r");
                    continue block11;
                }
                case '\t': {
                    escapeEncountered = false;
                    toPaste.append("\\t");
                    continue block11;
                }
                case '\f': {
                    escapeEncountered = false;
                    toPaste.append("\\f");
                    continue block11;
                }
                case '\u0007': {
                    escapeEncountered = false;
                    toPaste.append("\\a");
                    continue block11;
                }
                case '\u001b': {
                    escapeEncountered = false;
                    toPaste.append("\\e");
                    continue block11;
                }
                default: {
                    if ('\u0000' <= ch && ch < ' ') {
                        toPaste.append("\\x");
                        toPaste.append(Integer.toHexString(ch).toUpperCase());
                    } else {
                        if (escapeEncountered) {
                            escapeEncountered = false;
                            toPaste.append("\\");
                        }
                        toPaste.append(ch);
                    }
                    escapeEncountered = false;
                }
            }
        }
        return toPaste.toString();
    }
}

