/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.log4j.appenders;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogPasswordFilterUtil {
    private static final Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("(?:A|a)uthorization: (.*)$");
    private static final Pattern URI_CREDENTIALS_PATTERN = Pattern.compile("(\\w+://)([^\\s@]+@)");
    private static final int AUTHENTICATION_DATA_GROUP_INDEX = 2;

    private LogPasswordFilterUtil() {
    }

    public static String filterAuthorizationHeaders(String format) {
        Matcher m = AUTHORIZATION_HEADER_PATTERN.matcher((CharSequence)format);
        if (m.find()) {
            String headerValue;
            int start = m.start(1);
            int end = m.end(1);
            if (start != -1 && end != -1 && (headerValue = ((String)format).substring(start, end)).length() > 0) {
                format = ((String)format).substring(0, m.start(1)) + "USER_PASSWORD_HASH" + ((String)format).substring(m.end(1));
            }
        }
        return format;
    }

    public static String maskCredentialsFromURIs(String format) {
        if (format.contains("@")) {
            Matcher m = URI_CREDENTIALS_PATTERN.matcher(format);
            StringBuffer credentialsRedacted = new StringBuffer(format.length());
            while (m.find()) {
                int start = m.start(2);
                int end = m.end(2);
                if (start != -1 && end != -1) {
                    m.appendReplacement(credentialsRedacted, m.group(1) + "****@");
                    continue;
                }
                m.appendReplacement(credentialsRedacted, m.group());
            }
            m.appendTail(credentialsRedacted);
            format = credentialsRedacted.toString();
        }
        return format;
    }
}

