/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.ModifiedFromTests;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.EmptyLineBufferedReader;
import ro.sync.basic.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class IOUtil {
    private static Logger logger = LoggerFactory.getLogger((String)IOUtil.class.getName());
    @ModifiedFromTests
    public static Boolean logOutOfMemoryForTc = false;

    private IOUtil() {
    }

    public static final String removeCRCharactes(String str) {
        if (str.contains("\r")) {
            int length = str.length();
            StringBuilder toReturn = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char ch = str.charAt(i);
                if (ch == '\r') continue;
                toReturn.append(ch);
            }
            return toReturn.toString();
        }
        return str;
    }

    public static final String getFileSizeAsString(long fileSize) {
        if (fileSize < 1024L) {
            return fileSize + " bytes";
        }
        double fs = fileSize;
        DecimalFormat df = new DecimalFormat();
        ((NumberFormat)df).setMaximumFractionDigits(2);
        if (fs / 1024.0 < 1024.0) {
            return df.format(fs / 1024.0) + " KB";
        }
        return df.format(fs / 1048576.0) + " MB";
    }

    public static final File changeFileExtension(File file, String extension) {
        if (null == extension || "".equals(extension)) {
            return file;
        }
        String fileName = IOUtil.changeExtension(file.toString(), extension);
        return new File(fileName);
    }

    public static final URL changeURLFileExtension(URL url, String extension) {
        block3: {
            if (null != extension && !"".equals(extension)) {
                String fileName = IOUtil.changeExtension(url.toExternalForm(), extension);
                try {
                    url = new URL(fileName);
                }
                catch (MalformedURLException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return url;
    }

    public static final String changeExtension(String fileName, String extension) {
        String name;
        int lastDot;
        int lastSlash = ((String)fileName).lastIndexOf(File.separatorChar);
        if (lastSlash == -1) {
            lastSlash = 0;
        }
        fileName = (lastDot = (name = ((String)fileName).substring(lastSlash)).lastIndexOf(46)) == -1 ? (String)fileName + "." + extension : ((String)fileName).substring(0, lastSlash + lastDot) + "." + extension;
        return fileName;
    }

    public static final File correctFileExtension(File file, String extension) {
        String name;
        int lastDot;
        Object fileName = file.toString();
        int lastSlash = ((String)fileName).lastIndexOf(File.separatorChar);
        if (lastSlash == -1) {
            lastSlash = 0;
        }
        if ((lastDot = (name = ((String)fileName).substring(lastSlash)).lastIndexOf(46)) == -1 && !"".equals(extension)) {
            fileName = (String)fileName + "." + extension;
        }
        return new File((String)fileName);
    }

    public static final String correctFileExtension(String fileName, String extension) {
        int lastDot = ((String)fileName).lastIndexOf(46);
        if (lastDot == -1 && !"".equals(extension)) {
            fileName = (String)fileName + "." + extension;
        }
        return fileName;
    }

    public static final int detectLongestLine(Reader reader) throws IOException {
        int longestLine = 0;
        reader = new BufferedReader(reader);
        char[] cbuf = new char[1024];
        int cnt = -1;
        int currentLineCnt = 0;
        while ((cnt = reader.read(cbuf)) != -1) {
            for (int i = 0; i < cnt; ++i) {
                char ch = cbuf[i];
                if (ch == '\n' || ch == '\r') {
                    if (currentLineCnt > longestLine) {
                        longestLine = currentLineCnt;
                    }
                    currentLineCnt = 0;
                    continue;
                }
                ++currentLineCnt;
            }
        }
        if (currentLineCnt > longestLine) {
            longestLine = currentLineCnt;
        }
        return longestLine;
    }

    public static final List<File> collectFiles(File dir, FileFilter fileFilter) {
        ArrayList<File> files = new ArrayList<File>();
        File[] coll = dir.listFiles();
        if (coll != null) {
            for (int i = 0; i < coll.length; ++i) {
                if (!fileFilter.accept(coll[i])) continue;
                if (coll[i].isDirectory()) {
                    files.addAll(IOUtil.collectFiles(coll[i], fileFilter));
                    continue;
                }
                files.add(coll[i]);
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StringBuilder readUnaltered(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[1024];
        int len = -1;
        try {
            while ((len = reader.read(chars)) != -1) {
                sb.append(chars, 0, len);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readBytes(InputStream is) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            byte[] bytes = new byte[1024];
            int len = -1;
            try {
                while ((len = is.read(bytes)) != -1) {
                    os.write(bytes, 0, len);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static final String readFile(File file, String encoding, boolean concatenateLines, boolean trimResult) throws IOException {
        FileInputStream is = new FileInputStream(file);
        String result = IOUtil.readFromStream(concatenateLines, is, encoding);
        return trimResult ? result.trim() : result;
    }

    private static BufferedInputStream consumeUTF8BOM(InputStream in) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(3);
        try {
            if (bin.read() != 239 || bin.read() != 187 || bin.read() != 191) {
                bin.reset();
            }
        }
        catch (IOException e) {
            bin.reset();
        }
        return bin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readFromStream(boolean concatenateLines, InputStream is, String encoding) throws IOException {
        BufferedReader in;
        if (encoding == null) {
            in = new BufferedReader(new InputStreamReader(is));
        } else {
            if ("UTF8".equalsIgnoreCase(encoding) || "UTF-8".equalsIgnoreCase(encoding)) {
                is = IOUtil.consumeUTF8BOM(is);
            }
            in = new BufferedReader(new InputStreamReader(is, encoding));
        }
        StringBuilder result = new StringBuilder(4000);
        try {
            String line = in.readLine();
            while (line != null) {
                result.append(line);
                if (!concatenateLines) {
                    result.append('\n');
                }
                line = in.readLine();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return result.toString();
    }

    public static final String readURL(URL url, String encoding) throws IOException {
        InputStream is = url.openConnection().getInputStream();
        return IOUtil.readFromStream(false, is, encoding);
    }

    public static final String readFile(File file) throws IOException {
        return IOUtil.readFile(file, null);
    }

    public static final String readFile(File file, String encoding) throws IOException {
        return IOUtil.readFile(file, encoding, false);
    }

    public static final String readFile(File file, String encoding, boolean concatenateLines) throws IOException {
        return IOUtil.readFile(file, encoding, concatenateLines, true);
    }

    public static void saveInURLWithUTF8(URL saveURL, String content) throws IOException {
        OutputStream os = URLUtil.openOutputStream(saveURL);
        try (BufferedWriter toSaveIn = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
            toSaveIn.write(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSimple(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            while ((line = br.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return stringBuilder.toString();
    }

    public static StringBuilder read(Reader reader) throws IOException {
        return IOUtil.read(reader, "\n");
    }

    public static StringBuilder read(Reader reader, String lineSeparator) throws IOException {
        return IOUtil.readWithLongLineDetection((Reader)reader, (String)lineSeparator).readBuffer;
    }

    public static ReadInfo readWithLongLineDetection(Reader reader) throws IOException {
        return IOUtil.readWithLongLineDetection(reader, "\n");
    }

    private static ReadInfo readWithLongLineDetection(Reader reader, String lineSeparator) throws IOException {
        return IOUtil.readWithLongLineDetection(reader, lineSeparator, true);
    }

    public static ReadInfo readWithLongLineDetection(Reader reader, String lineSeparator, boolean closeReader) throws IOException {
        EmptyLineBufferedReader rd = new EmptyLineBufferedReader(reader);
        boolean error = false;
        try {
            StringBuilder buf = new StringBuilder();
            int longestLineChars = 0;
            String line = rd.readLine();
            boolean first = true;
            while (line != null) {
                if (!first) {
                    buf.append(lineSeparator);
                } else {
                    first = false;
                }
                if (line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                buf.append(line);
                longestLineChars = Math.max(longestLineChars, line.length());
                line = rd.readLine();
            }
            ReadInfo readInfo = new ReadInfo(buf, longestLineChars);
            return readInfo;
        }
        catch (OutOfMemoryError e) {
            error = true;
            if (logOutOfMemoryForTc.booleanValue()) {
                logger.error(e.getMessage(), (Throwable)e);
                ReadInfo readInfo = null;
                return readInfo;
            }
            throw new OutOfMemoryIOException("Document too large.");
        }
        finally {
            block18: {
                if (closeReader) {
                    try {
                        rd.close();
                    }
                    catch (IOException e) {
                        if (error) break block18;
                        throw e;
                    }
                }
            }
        }
    }

    public static class ReadInfo {
        public final StringBuilder readBuffer;
        public final int longestLineCharsNo;

        public ReadInfo(StringBuilder readBuffer, int longestLineCharsNo) {
            this.readBuffer = readBuffer;
            this.longestLineCharsNo = longestLineCharsNo;
        }
    }

    public static class OutOfMemoryIOException
    extends IOException {
        public OutOfMemoryIOException(String message) {
            super(message);
        }
    }
}

