/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;

public class IOStreamUtil {
    public static void copyAll(Reader reader, Writer writer) throws IOException {
        int bufSize = 4096;
        char[] buffer = new char[bufSize];
        int readCount = reader.read(buffer);
        while (readCount >= 0) {
            writer.write(buffer, 0, readCount);
            readCount = reader.read(buffer);
        }
        writer.flush();
    }

    public static void copy(Reader reader, Writer writer, int length) throws IOException {
        if (length == -1) {
            IOStreamUtil.copyAll(reader, writer);
            return;
        }
        int bufSize = 4096;
        char[] buffer = new char[bufSize];
        int remaining = length;
        int toRead = remaining > bufSize ? bufSize : remaining;
        int read = -1;
        while (toRead > 0 && (read = reader.read(buffer, 0, toRead)) > 0) {
            writer.write(buffer, 0, read);
            toRead = (remaining -= read) > bufSize ? bufSize : remaining;
        }
    }

    public static final int readFully(Reader reader, char[] charArray) throws IOException {
        int count;
        int n = 0;
        int off = 0;
        boolean eofEncountered = false;
        do {
            if ((count = reader.read(charArray, off + n, charArray.length - n)) >= 0) continue;
            eofEncountered = true;
            break;
        } while ((n += count) < charArray.length);
        if (eofEncountered && n == 0) {
            n = -1;
        }
        return n;
    }

    public static final int readFully(InputStream is, byte[] byteArray) throws IOException {
        return IOStreamUtil.readFully(is, byteArray, 0, byteArray.length);
    }

    public static final int readFully(final RandomAccessFile raf, byte[] byteArray, int off, int len) throws IOException {
        return IOStreamUtil.readFully(new InputStreamWrapper(){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return raf.read(b, off, len);
            }
        }, byteArray, off, len);
    }

    private static final int readFully(final InputStream is, byte[] byteArray, int off, int len) throws IOException {
        return IOStreamUtil.readFully(new InputStreamWrapper(){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return is.read(b, off, len);
            }
        }, byteArray, off, len);
    }

    private static final int readFully(InputStreamWrapper is, byte[] byteArray, int off, int len) throws IOException {
        int count;
        int n = 0;
        boolean eofEncountered = false;
        do {
            if ((count = is.read(byteArray, off + n, len - n)) >= 0) continue;
            eofEncountered = true;
            break;
        } while ((n += count) < len);
        if (eofEncountered && n == 0) {
            n = -1;
        }
        return n;
    }

    public static void closeQuietly(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static interface InputStreamWrapper {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

