/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.html5;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.TextMessageTextHandler;
import nu.validator.messages.types.MessageType;
import ro.sync.exml.validate.external.api.ValidationException;
import ro.sync.exml.validate.external.api.ValidationSeverity;

public class OxygenErrorEmitter
extends MessageEmitter {
    private List<ValidationException> validationExceptionList = new ArrayList<ValidationException>();
    private String systemId;
    private int oneBasedFirstLine;
    private int oneBasedFirstColumn;
    private int oneBasedLastLine;
    private int oneBasedLastColumn;
    private ValidationSeverity severity;
    private TextMessageTextHandler messageTextHandler;
    private final StringWriter messageWriter = new StringWriter();

    public OxygenErrorEmitter() {
        this(false);
    }

    public OxygenErrorEmitter(boolean asciiQuotes) {
        this.messageTextHandler = new TextMessageTextHandler(this.messageWriter, asciiQuotes);
    }

    @Override
    public void startMessage(MessageType type, String systemId, int oneBasedFirstLine, int oneBasedFirstColumn, int oneBasedLastLine, int oneBasedLastColumn, boolean exact) {
        this.systemId = systemId;
        this.oneBasedFirstLine = oneBasedFirstLine;
        this.oneBasedFirstColumn = oneBasedFirstColumn;
        this.oneBasedLastLine = oneBasedLastLine;
        this.oneBasedLastColumn = oneBasedLastColumn;
        this.severity = OxygenErrorEmitter.getMessageSeverity(type);
    }

    private static ValidationSeverity getMessageSeverity(MessageType type) {
        ValidationSeverity msgSeverity = ValidationSeverity.ERROR;
        if (type == MessageType.FATAL) {
            msgSeverity = ValidationSeverity.FATAL;
        } else if (type == MessageType.WARNING) {
            msgSeverity = ValidationSeverity.WARNING;
        } else if (type == MessageType.INFO) {
            msgSeverity = ValidationSeverity.INFO;
        }
        return msgSeverity;
    }

    @Override
    public void endMessage() {
        ValidationException validationException = new ValidationException(this.messageWriter.toString(), this.systemId, this.severity, null);
        this.messageWriter.getBuffer().setLength(0);
        validationException.setLineNumber(this.oneBasedFirstLine);
        validationException.setColumnNumber(this.oneBasedFirstColumn);
        validationException.setEndLineNumber(this.oneBasedLastLine);
        validationException.setEndColumnNumber(this.oneBasedLastColumn);
        this.validationExceptionList.add(validationException);
    }

    @Override
    public MessageTextHandler startText() {
        return this.messageTextHandler;
    }

    public List<ValidationException> getValidationExceptionList() {
        return new ArrayList<ValidationException>(this.validationExceptionList);
    }

    public void clearValidationExceptionList() {
        if (this.validationExceptionList != null) {
            this.validationExceptionList.clear();
        }
    }
}

